/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.Function1;
import de.caff.generics.function.LongOperator1;
import de.caff.generics.mda.AbstractBasicMultiDimensionalArray;
import de.caff.generics.mda.MappingMultiIndexLinearizer;
import de.caff.generics.mda.MultiIndexLinearizer;
import java.util.Arrays;
import java.util.function.Function;

public class MultiDimensionalLongArray
extends AbstractBasicMultiDimensionalArray<Long> {
    @NotNull
    private final long[] array;

    public MultiDimensionalLongArray(int ... nArray) {
        super(nArray);
        this.array = new long[(int)this.getNumElements()];
    }

    public MultiDimensionalLongArray(@NotNull MultiDimensionalLongArray multiDimensionalLongArray, @NotNull Function1<int[], int[]> function1, int ... nArray) {
        this(multiDimensionalLongArray, new MappingMultiIndexLinearizer(multiDimensionalLongArray.getIndexLinearizer(), function1, nArray));
    }

    private MultiDimensionalLongArray(@NotNull MultiDimensionalLongArray multiDimensionalLongArray, @NotNull MultiIndexLinearizer multiIndexLinearizer) {
        super(multiIndexLinearizer);
        this.array = multiDimensionalLongArray.array;
    }

    @Override
    @NotNull
    public Long getElement(int ... nArray) {
        return this.getValueAt(nArray);
    }

    @Override
    public void setElement(@NotNull Long l, int ... nArray) {
        this.setValueAt(l, nArray);
    }

    @Override
    @NotNull
    public Long change(@NotNull Function<? super Long, ? extends Long> function, int ... nArray) {
        return this.changeValueAt(function::apply, nArray);
    }

    public long getValueAt(int ... nArray) {
        return this.array[this.toLinear(nArray)];
    }

    public void setValueAt(long l, int ... nArray) {
        this.array[this.toLinear((int[])nArray)] = l;
    }

    public long changeValueAt(@NotNull LongOperator1 longOperator1, int ... nArray) {
        long l;
        int n = this.toLinear(nArray);
        this.array[n] = l = longOperator1.applyAsLong(this.array[n]);
        return l;
    }

    public void setValuesFrom(long ... lArray) {
        if (lArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), lArray.length));
        }
        System.arraycopy(lArray, 0, this.array, 0, this.array.length);
    }

    public void setValuesFrom(@NotNull MultiIndexLinearizer.Sequencer sequencer, long ... lArray) {
        if (lArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), lArray.length));
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            this.array[this.toLinear((int[])((int[])sequencer.get((int)i)))] = lArray[i];
        }
    }

    @NotNull
    public MultiDimensionalLongArray sub(int ... nArray) {
        return new MultiDimensionalLongArray(this, this.indexLinearizer.sub(nArray));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalLongArray multiDimensionalLongArray = (MultiDimensionalLongArray)object;
        if (!Arrays.equals(this.getSizes(), multiDimensionalLongArray.getSizes())) {
            return false;
        }
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            if (this.getValueAt(nArray) == multiDimensionalLongArray.getElement(nArray).longValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.getSizes(), this.toList(this.indexLinearizer.getHighFastSequencer())});
    }

    @NotNull
    public MultiDimensionalLongArray getCopy() {
        MultiDimensionalLongArray multiDimensionalLongArray = new MultiDimensionalLongArray(this.getSizes());
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            multiDimensionalLongArray.setValueAt(this.getValueAt(nArray), nArray);
        }
        return multiDimensionalLongArray;
    }
}

