/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.Function1;
import de.caff.generics.function.IntOperator1;
import de.caff.generics.mda.AbstractBasicMultiDimensionalArray;
import de.caff.generics.mda.MappingMultiIndexLinearizer;
import de.caff.generics.mda.MultiIndexLinearizer;
import java.util.Arrays;
import java.util.function.Function;

public class MultiDimensionalIntArray
extends AbstractBasicMultiDimensionalArray<Integer> {
    @NotNull
    private final int[] array;

    public MultiDimensionalIntArray(int ... nArray) {
        super(nArray);
        this.array = new int[(int)this.getNumElements()];
    }

    public MultiDimensionalIntArray(@NotNull MultiDimensionalIntArray multiDimensionalIntArray, @NotNull Function1<int[], int[]> function1, int ... nArray) {
        this(multiDimensionalIntArray, new MappingMultiIndexLinearizer(multiDimensionalIntArray.getIndexLinearizer(), function1, nArray));
    }

    private MultiDimensionalIntArray(@NotNull MultiDimensionalIntArray multiDimensionalIntArray, @NotNull MultiIndexLinearizer multiIndexLinearizer) {
        super(multiIndexLinearizer);
        this.array = multiDimensionalIntArray.array;
    }

    @Override
    @NotNull
    public Integer getElement(int ... nArray) {
        return this.getValue(nArray);
    }

    @Override
    public void setElement(@NotNull Integer n, int ... nArray) {
        this.setValue(n, nArray);
    }

    @Override
    @NotNull
    public Integer change(@NotNull Function<? super Integer, ? extends Integer> function, int ... nArray) {
        return this.changeValue(function::apply, nArray);
    }

    public int getValue(int ... nArray) {
        return this.array[this.toLinear(nArray)];
    }

    public void setValue(int n, int ... nArray) {
        this.array[this.toLinear((int[])nArray)] = n;
    }

    public int changeValue(@NotNull IntOperator1 intOperator1, int ... nArray) {
        int n;
        int n2 = this.toLinear(nArray);
        this.array[n2] = n = intOperator1.applyAsInt(this.array[n2]);
        return n;
    }

    public void setValuesFrom(int ... nArray) {
        if (nArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), nArray.length));
        }
        System.arraycopy(nArray, 0, this.array, 0, this.array.length);
    }

    public void setValuesFrom(@NotNull MultiIndexLinearizer.Sequencer sequencer, int ... nArray) {
        if (nArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), nArray.length));
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            this.array[this.toLinear((int[])((int[])sequencer.get((int)i)))] = nArray[i];
        }
    }

    @NotNull
    public MultiDimensionalIntArray sub(int ... nArray) {
        return new MultiDimensionalIntArray(this, this.indexLinearizer.sub(nArray));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalIntArray multiDimensionalIntArray = (MultiDimensionalIntArray)object;
        if (!Arrays.equals(this.getSizes(), multiDimensionalIntArray.getSizes())) {
            return false;
        }
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            if (this.getValue(nArray) == multiDimensionalIntArray.getElement(nArray).intValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.getSizes(), this.toList(this.indexLinearizer.getHighFastSequencer())});
    }

    @NotNull
    public MultiDimensionalIntArray getCopy() {
        MultiDimensionalIntArray multiDimensionalIntArray = new MultiDimensionalIntArray(this.getSizes());
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            multiDimensionalIntArray.setValue(this.getValue(nArray), nArray);
        }
        return multiDimensionalIntArray;
    }
}

