/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.FloatOperator1;
import de.caff.generics.function.Function1;
import de.caff.generics.mda.AbstractBasicMultiDimensionalArray;
import de.caff.generics.mda.MappingMultiIndexLinearizer;
import de.caff.generics.mda.MultiIndexLinearizer;
import java.util.Arrays;
import java.util.function.Function;

public class MultiDimensionalFloatArray
extends AbstractBasicMultiDimensionalArray<Float> {
    @NotNull
    private final float[] array;

    public MultiDimensionalFloatArray(int ... nArray) {
        super(nArray);
        this.array = new float[(int)this.getNumElements()];
    }

    public MultiDimensionalFloatArray(@NotNull MultiDimensionalFloatArray multiDimensionalFloatArray, @NotNull Function1<int[], int[]> function1, int ... nArray) {
        this(multiDimensionalFloatArray, new MappingMultiIndexLinearizer(multiDimensionalFloatArray.getIndexLinearizer(), function1, nArray));
    }

    private MultiDimensionalFloatArray(@NotNull MultiDimensionalFloatArray multiDimensionalFloatArray, @NotNull MultiIndexLinearizer multiIndexLinearizer) {
        super(multiIndexLinearizer);
        this.array = multiDimensionalFloatArray.array;
    }

    @Override
    @NotNull
    public Float getElement(int ... nArray) {
        return Float.valueOf(this.getValue(nArray));
    }

    @Override
    public void setElement(@NotNull Float f, int ... nArray) {
        this.setValue(f.floatValue(), nArray);
    }

    @Override
    @NotNull
    public Float change(@NotNull Function<? super Float, ? extends Float> function, int ... nArray) {
        return Float.valueOf(this.changeValue(function::apply, nArray));
    }

    public void setValuesFrom(float ... fArray) {
        if (fArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), fArray.length));
        }
        System.arraycopy(fArray, 0, this.array, 0, this.array.length);
    }

    public void setValuesFrom(@NotNull MultiIndexLinearizer.Sequencer sequencer, float ... fArray) {
        if (fArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), fArray.length));
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            this.array[this.toLinear((int[])((int[])sequencer.get((int)i)))] = fArray[i];
        }
    }

    public float getValue(int ... nArray) {
        return this.array[this.toLinear(nArray)];
    }

    public void setValue(float f, int ... nArray) {
        this.array[this.toLinear((int[])nArray)] = f;
    }

    public float changeValue(@NotNull FloatOperator1 floatOperator1, int ... nArray) {
        float f;
        int n = this.toLinear(nArray);
        this.array[n] = f = floatOperator1.applyAsFloat(this.array[n]);
        return f;
    }

    @NotNull
    public MultiDimensionalFloatArray sub(int ... nArray) {
        return new MultiDimensionalFloatArray(this, this.indexLinearizer.sub(nArray));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalFloatArray multiDimensionalFloatArray = (MultiDimensionalFloatArray)object;
        if (!Arrays.equals(this.getSizes(), multiDimensionalFloatArray.getSizes())) {
            return false;
        }
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            if (this.getValue(nArray) == multiDimensionalFloatArray.getElement(nArray).floatValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.getSizes(), this.toList(this.indexLinearizer.getHighFastSequencer())});
    }

    @NotNull
    public MultiDimensionalFloatArray getCopy() {
        MultiDimensionalFloatArray multiDimensionalFloatArray = new MultiDimensionalFloatArray(this.getSizes());
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            multiDimensionalFloatArray.setValue(this.getValue(nArray), nArray);
        }
        return multiDimensionalFloatArray;
    }
}

