/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.Function1;
import de.caff.generics.mda.AbstractBasicMultiDimensionalArray;
import de.caff.generics.mda.MappingMultiIndexLinearizer;
import de.caff.generics.mda.MultiIndexLinearizer;
import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;

public class MultiDimensionalDoubleArray
extends AbstractBasicMultiDimensionalArray<Double> {
    @NotNull
    private final double[] array;

    public MultiDimensionalDoubleArray(int ... nArray) {
        super(nArray);
        this.array = new double[(int)this.getNumElements()];
    }

    public MultiDimensionalDoubleArray(@NotNull MultiDimensionalDoubleArray multiDimensionalDoubleArray, @NotNull Function1<int[], int[]> function1, int ... nArray) {
        this(multiDimensionalDoubleArray, new MappingMultiIndexLinearizer(multiDimensionalDoubleArray.getIndexLinearizer(), function1, nArray));
    }

    private MultiDimensionalDoubleArray(@NotNull MultiDimensionalDoubleArray multiDimensionalDoubleArray, @NotNull MultiIndexLinearizer multiIndexLinearizer) {
        super(multiIndexLinearizer);
        this.array = multiDimensionalDoubleArray.array;
    }

    @Override
    @NotNull
    public Double getElement(int ... nArray) {
        return this.getValue(nArray);
    }

    @Override
    public void setElement(@NotNull Double d, int ... nArray) {
        this.setValue(d, nArray);
    }

    @Override
    @NotNull
    public Double change(@NotNull Function<? super Double, ? extends Double> function, int ... nArray) {
        return this.changeValue(function::apply, nArray);
    }

    public double getValue(int ... nArray) {
        return this.array[this.toLinear(nArray)];
    }

    public void setValue(double d, int ... nArray) {
        this.array[this.toLinear((int[])nArray)] = d;
    }

    public double changeValue(@NotNull DoubleUnaryOperator doubleUnaryOperator, int ... nArray) {
        double d;
        int n = this.toLinear(nArray);
        this.array[n] = d = doubleUnaryOperator.applyAsDouble(this.array[n]);
        return d;
    }

    public void setValuesFrom(double ... dArray) {
        if (dArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), dArray.length));
        }
        System.arraycopy(dArray, 0, this.array, 0, this.array.length);
    }

    public void setValuesFrom(@NotNull MultiIndexLinearizer.Sequencer sequencer, double ... dArray) {
        if (dArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), dArray.length));
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            this.array[this.toLinear((int[])((int[])sequencer.get((int)i)))] = dArray[i];
        }
    }

    @NotNull
    public MultiDimensionalDoubleArray sub(int ... nArray) {
        return new MultiDimensionalDoubleArray(this, this.indexLinearizer.sub(nArray));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalDoubleArray multiDimensionalDoubleArray = (MultiDimensionalDoubleArray)object;
        if (!Arrays.equals(this.getSizes(), multiDimensionalDoubleArray.getSizes())) {
            return false;
        }
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            if (this.getValue(nArray) == multiDimensionalDoubleArray.getElement(nArray).doubleValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.getSizes(), this.toList(this.indexLinearizer.getHighFastSequencer())});
    }

    @NotNull
    public MultiDimensionalDoubleArray getCopy() {
        MultiDimensionalDoubleArray multiDimensionalDoubleArray = new MultiDimensionalDoubleArray(this.getSizes());
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            multiDimensionalDoubleArray.setValue(this.getValue(nArray), nArray);
        }
        return multiDimensionalDoubleArray;
    }
}

