/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.CharOperator1;
import de.caff.generics.function.Function1;
import de.caff.generics.mda.AbstractBasicMultiDimensionalArray;
import de.caff.generics.mda.MappingMultiIndexLinearizer;
import de.caff.generics.mda.MultiIndexLinearizer;
import java.util.Arrays;
import java.util.function.Function;

public class MultiDimensionalCharArray
extends AbstractBasicMultiDimensionalArray<Character> {
    @NotNull
    private final char[] array;

    public MultiDimensionalCharArray(int ... nArray) {
        super(nArray);
        this.array = new char[(int)this.getNumElements()];
    }

    public MultiDimensionalCharArray(@NotNull MultiDimensionalCharArray multiDimensionalCharArray, @NotNull Function1<int[], int[]> function1, int ... nArray) {
        this(multiDimensionalCharArray, new MappingMultiIndexLinearizer(multiDimensionalCharArray.getIndexLinearizer(), function1, nArray));
    }

    private MultiDimensionalCharArray(@NotNull MultiDimensionalCharArray multiDimensionalCharArray, @NotNull MultiIndexLinearizer multiIndexLinearizer) {
        super(multiIndexLinearizer);
        this.array = multiDimensionalCharArray.array;
    }

    @Override
    @NotNull
    public Character getElement(int ... nArray) {
        return Character.valueOf(this.getValue(nArray));
    }

    @Override
    public void setElement(@NotNull Character c, int ... nArray) {
        this.setValue(c.charValue(), nArray);
    }

    @Override
    @NotNull
    public Character change(@NotNull Function<? super Character, ? extends Character> function, int ... nArray) {
        return Character.valueOf(this.changeValue(function::apply, nArray));
    }

    public void setValuesFrom(char ... cArray) {
        if (cArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), cArray.length));
        }
        System.arraycopy(cArray, 0, this.array, 0, this.array.length);
    }

    public void setValuesFrom(@NotNull MultiIndexLinearizer.Sequencer sequencer, char ... cArray) {
        if (cArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), cArray.length));
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            this.array[this.toLinear((int[])((int[])sequencer.get((int)i)))] = cArray[i];
        }
    }

    public char getValue(int ... nArray) {
        return this.array[this.toLinear(nArray)];
    }

    public void setValue(char c, int ... nArray) {
        this.array[this.toLinear((int[])nArray)] = c;
    }

    public char changeValue(@NotNull CharOperator1 charOperator1, int ... nArray) {
        char c;
        int n = this.toLinear(nArray);
        this.array[n] = c = charOperator1.applyAsChar(this.array[n]);
        return c;
    }

    @NotNull
    public MultiDimensionalCharArray sub(int ... nArray) {
        return new MultiDimensionalCharArray(this, this.indexLinearizer.sub(nArray));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalCharArray multiDimensionalCharArray = (MultiDimensionalCharArray)object;
        if (!Arrays.equals(this.getSizes(), multiDimensionalCharArray.getSizes())) {
            return false;
        }
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            if (this.getValue(nArray) == multiDimensionalCharArray.getElement(nArray).charValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.getSizes(), this.toList(this.indexLinearizer.getHighFastSequencer())});
    }

    @NotNull
    public MultiDimensionalCharArray getCopy() {
        MultiDimensionalCharArray multiDimensionalCharArray = new MultiDimensionalCharArray(this.getSizes());
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            multiDimensionalCharArray.setValue(this.getValue(nArray), nArray);
        }
        return multiDimensionalCharArray;
    }
}

