/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.ByteOperator1;
import de.caff.generics.function.Function1;
import de.caff.generics.mda.AbstractBasicMultiDimensionalArray;
import de.caff.generics.mda.MappingMultiIndexLinearizer;
import de.caff.generics.mda.MultiIndexLinearizer;
import java.util.Arrays;
import java.util.function.Function;

public class MultiDimensionalByteArray
extends AbstractBasicMultiDimensionalArray<Byte> {
    @NotNull
    private final byte[] array;

    public MultiDimensionalByteArray(int ... nArray) {
        super(nArray);
        this.array = new byte[(int)this.getNumElements()];
    }

    public MultiDimensionalByteArray(@NotNull MultiDimensionalByteArray multiDimensionalByteArray, @NotNull Function1<int[], int[]> function1, int ... nArray) {
        this(multiDimensionalByteArray, new MappingMultiIndexLinearizer(multiDimensionalByteArray.getIndexLinearizer(), function1, nArray));
    }

    private MultiDimensionalByteArray(@NotNull MultiDimensionalByteArray multiDimensionalByteArray, @NotNull MultiIndexLinearizer multiIndexLinearizer) {
        super(multiIndexLinearizer);
        this.array = multiDimensionalByteArray.array;
    }

    @Override
    @NotNull
    public Byte getElement(int ... nArray) {
        return this.getValue(nArray);
    }

    @Override
    public void setElement(@NotNull Byte by, int ... nArray) {
        this.setValue(by, nArray);
    }

    @Override
    @NotNull
    public Byte change(@NotNull Function<? super Byte, ? extends Byte> function, int ... nArray) {
        return this.changeValue(function::apply, nArray);
    }

    public void setValuesFrom(byte ... byArray) {
        if (byArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), byArray.length));
        }
        System.arraycopy(byArray, 0, this.array, 0, this.array.length);
    }

    public void setValuesFrom(@NotNull MultiIndexLinearizer.Sequencer sequencer, byte ... byArray) {
        if (byArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), byArray.length));
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            this.array[this.toLinear((int[])((int[])sequencer.get((int)i)))] = byArray[i];
        }
    }

    public byte getValue(int ... nArray) {
        return this.array[this.toLinear(nArray)];
    }

    public void setValue(byte by, int ... nArray) {
        this.array[this.toLinear((int[])nArray)] = by;
    }

    public byte changeValue(@NotNull ByteOperator1 byteOperator1, int ... nArray) {
        byte by;
        int n = this.toLinear(nArray);
        this.array[n] = by = byteOperator1.applyAsByte(this.array[n]);
        return by;
    }

    @NotNull
    public MultiDimensionalByteArray sub(int ... nArray) {
        return new MultiDimensionalByteArray(this, this.indexLinearizer.sub(nArray));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalByteArray multiDimensionalByteArray = (MultiDimensionalByteArray)object;
        if (!Arrays.equals(this.getSizes(), multiDimensionalByteArray.getSizes())) {
            return false;
        }
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            if (this.getValue(nArray) == multiDimensionalByteArray.getElement(nArray).byteValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.getSizes(), this.toList(this.indexLinearizer.getHighFastSequencer())});
    }

    @NotNull
    public MultiDimensionalByteArray getCopy() {
        MultiDimensionalByteArray multiDimensionalByteArray = new MultiDimensionalByteArray(this.getSizes());
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            multiDimensionalByteArray.setValue(this.getValue(nArray), nArray);
        }
        return multiDimensionalByteArray;
    }
}

