/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.BooleanOperator1;
import de.caff.generics.function.Function1;
import de.caff.generics.mda.AbstractBasicMultiDimensionalArray;
import de.caff.generics.mda.MappingMultiIndexLinearizer;
import de.caff.generics.mda.MultiIndexLinearizer;
import java.util.Arrays;
import java.util.function.Function;

public class MultiDimensionalBooleanArray
extends AbstractBasicMultiDimensionalArray<Boolean> {
    @NotNull
    private final boolean[] array;

    public MultiDimensionalBooleanArray(int ... nArray) {
        super(nArray);
        this.array = new boolean[(int)this.getNumElements()];
    }

    public MultiDimensionalBooleanArray(@NotNull MultiDimensionalBooleanArray multiDimensionalBooleanArray, @NotNull Function1<int[], int[]> function1, int ... nArray) {
        this(multiDimensionalBooleanArray, new MappingMultiIndexLinearizer(multiDimensionalBooleanArray.getIndexLinearizer(), function1, nArray));
    }

    private MultiDimensionalBooleanArray(@NotNull MultiDimensionalBooleanArray multiDimensionalBooleanArray, @NotNull MultiIndexLinearizer multiIndexLinearizer) {
        super(multiIndexLinearizer);
        this.array = multiDimensionalBooleanArray.array;
    }

    @Override
    public Boolean getElement(int ... nArray) {
        return this.getValue(nArray);
    }

    @Override
    public void setElement(Boolean bl, int ... nArray) {
        this.setValue(bl, nArray);
    }

    @Override
    @NotNull
    public Boolean change(@NotNull Function<? super Boolean, ? extends Boolean> function, int ... nArray) {
        return this.changeValue(function::apply, nArray);
    }

    public boolean getValue(int ... nArray) {
        return this.array[this.toLinear(nArray)];
    }

    public void setValue(boolean bl, int ... nArray) {
        this.array[this.toLinear((int[])nArray)] = bl;
    }

    public boolean changeValue(@NotNull BooleanOperator1 booleanOperator1, int ... nArray) {
        boolean bl;
        int n = this.toLinear(nArray);
        this.array[n] = bl = booleanOperator1.applyAsBoolean(this.array[n]);
        return bl;
    }

    public void setValuesFrom(boolean ... blArray) {
        if (blArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), blArray.length));
        }
        System.arraycopy(blArray, 0, this.array, 0, this.array.length);
    }

    public void setValuesFrom(@NotNull MultiIndexLinearizer.Sequencer sequencer, boolean ... blArray) {
        if (blArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), blArray.length));
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            this.array[this.toLinear((int[])((int[])sequencer.get((int)i)))] = blArray[i];
        }
    }

    @NotNull
    public MultiDimensionalBooleanArray sub(int ... nArray) {
        return new MultiDimensionalBooleanArray(this, this.indexLinearizer.sub(nArray));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalBooleanArray multiDimensionalBooleanArray = (MultiDimensionalBooleanArray)object;
        if (!Arrays.equals(this.getSizes(), multiDimensionalBooleanArray.getSizes())) {
            return false;
        }
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            if (this.getValue(nArray) == multiDimensionalBooleanArray.getElement(nArray).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.getSizes(), this.toList(this.indexLinearizer.getHighFastSequencer())});
    }

    @NotNull
    public MultiDimensionalBooleanArray getCopy() {
        MultiDimensionalBooleanArray multiDimensionalBooleanArray = new MultiDimensionalBooleanArray(this.getSizes());
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            multiDimensionalBooleanArray.setValue(this.getValue(nArray), nArray);
        }
        return multiDimensionalBooleanArray;
    }
}

