/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.Function1;
import de.caff.generics.mda.AbstractBasicMultiDimensionalArray;
import de.caff.generics.mda.HighFastMultiIndexLinearizer;
import de.caff.generics.mda.MappingMultiIndexLinearizer;
import de.caff.generics.mda.MultiIndexLinearizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class MultiDimensionalArray<T>
extends AbstractBasicMultiDimensionalArray<T> {
    @NotNull
    private final List<T> elements;

    public MultiDimensionalArray(int ... nArray) {
        this(new HighFastMultiIndexLinearizer(nArray));
    }

    public MultiDimensionalArray(@NotNull MultiIndexLinearizer multiIndexLinearizer) {
        super(multiIndexLinearizer);
        this.elements = new ArrayList<T>((int)this.getNumElements());
        for (int i = (int)this.getNumElements(); i > 0; --i) {
            this.elements.add(null);
        }
    }

    public MultiDimensionalArray(@NotNull MultiDimensionalArray<T> multiDimensionalArray, @NotNull Function1<int[], int[]> function1, int ... nArray) {
        this(multiDimensionalArray.elements, new MappingMultiIndexLinearizer(multiDimensionalArray.getIndexLinearizer(), function1, nArray));
    }

    private MultiDimensionalArray(@NotNull List<T> list, @NotNull MultiIndexLinearizer multiIndexLinearizer) {
        super(multiIndexLinearizer);
        this.elements = list;
    }

    private MultiDimensionalArray(@NotNull List<T> list, int[] nArray) {
        super(nArray);
        this.elements = list;
    }

    @Override
    public T getElement(int ... nArray) {
        return this.elements.get(this.indexLinearizer.toLinear(nArray));
    }

    @Override
    public void setElement(T t, int ... nArray) {
        this.elements.set(this.indexLinearizer.toLinear(nArray), t);
    }

    @Override
    public T change(@NotNull Function<? super T, ? extends T> function, int ... nArray) {
        int n = this.indexLinearizer.toLinear(nArray);
        T t = function.apply(this.elements.get(n));
        this.elements.set(n, t);
        return t;
    }

    @Override
    public void setFrom(@NotNull Collection<? extends T> collection) {
        if ((long)collection.size() < this.getNumElements()) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), collection.size()));
        }
        int n = 0;
        for (T t : collection) {
            this.elements.set(n++, t);
        }
    }

    @NotNull
    public MultiDimensionalArray<T> sub(int ... nArray) {
        if (nArray.length == 0) {
            return this;
        }
        return new MultiDimensionalArray<T>(this.elements, this.indexLinearizer.sub(nArray));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalArray multiDimensionalArray = (MultiDimensionalArray)object;
        if (!Arrays.equals(this.getSizes(), multiDimensionalArray.getSizes())) {
            return false;
        }
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            if (this.getElement(nArray).equals(multiDimensionalArray.getElement(nArray))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.getSizes(), this.toList(this.indexLinearizer.getHighFastSequencer())});
    }

    @NotNull
    public MultiDimensionalArray<T> getCopy() {
        MultiDimensionalArray<T> multiDimensionalArray = new MultiDimensionalArray<T>(this.getSizes());
        multiDimensionalArray.elements.clear();
        multiDimensionalArray.elements.addAll(this.elements);
        return multiDimensionalArray;
    }

    @NotNull
    public <R> MultiDimensionalArray<R> getCopy(@NotNull Function1<? extends R, ? super T> function1) {
        MultiDimensionalArray<T> multiDimensionalArray = new MultiDimensionalArray<T>(this.getSizes());
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            multiDimensionalArray.elements.set(i, function1.apply(this.elements.get(i)));
        }
        return multiDimensionalArray;
    }
}

