/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.Function1;
import de.caff.generics.mda.MultiIndexLinearizer;

class MappingMultiIndexLinearizer
implements MultiIndexLinearizer {
    @NotNull
    private final MultiIndexLinearizer baseIndexLinearizer;
    @NotNull
    private final int[] sizes;
    @NotNull
    private final Function1<int[], int[]> mapper;
    private final int numElements;

    MappingMultiIndexLinearizer(@NotNull MultiIndexLinearizer multiIndexLinearizer, @NotNull Function1<int[], int[]> function1, int ... nArray) {
        this.baseIndexLinearizer = multiIndexLinearizer;
        this.sizes = (int[])nArray.clone();
        this.mapper = function1;
        int n = 1;
        for (int n2 : nArray) {
            n *= n2;
        }
        this.numElements = n;
    }

    @Override
    public int toLinear(int ... nArray) {
        MultiIndexLinearizer.checkIndexes(this.sizes, nArray);
        return this.baseIndexLinearizer.toLinear((int[])this.mapper.apply(nArray));
    }

    @Override
    public int getNumDimensions() {
        return this.sizes.length;
    }

    @Override
    public int getSize(int n) {
        return this.sizes[n];
    }

    @Override
    @NotNull
    public int[] getSizes() {
        return (int[])this.sizes.clone();
    }

    @Override
    public long getNumElements() {
        return this.numElements;
    }
}

