/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.mda.MultiIndexLinearizer;
import java.math.BigInteger;

public class LowFastMultiIndexLinearizer
implements MultiIndexLinearizer {
    private final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    @NotNull
    final int[] sizes;
    private final int numElements;
    private final int[] multiplicators;

    protected LowFastMultiIndexLinearizer(int ... nArray) {
        BigInteger bigInteger = BigInteger.ONE;
        this.multiplicators = new int[nArray.length];
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 <= 0) {
                throw new IllegalArgumentException("Dimensional sizes have to be positive!");
            }
            bigInteger = bigInteger.multiply(BigInteger.valueOf(n2));
            this.multiplicators[i] = n;
            n *= n2;
        }
        if (bigInteger.compareTo(this.MAX_INT) >= 0) {
            throw new IllegalArgumentException("Too many elements for integer index: " + bigInteger + "!");
        }
        this.sizes = (int[])nArray.clone();
        this.numElements = bigInteger.intValue();
    }

    @Override
    public int getNumDimensions() {
        return this.sizes.length;
    }

    @Override
    public int getSize(int n) {
        return this.sizes[n];
    }

    @Override
    @NotNull
    public int[] getSizes() {
        return (int[])this.sizes.clone();
    }

    @Override
    public int toLinear(int ... nArray) {
        if (nArray.length != this.sizes.length) {
            throw new IllegalArgumentException(String.format("Incorrect number of indexes for an array with %d dimensions: %d!", this.sizes.length, nArray.length));
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            MultiIndexLinearizer.checkIndex(i, this.sizes[i], n2);
            n += this.multiplicators[i] * n2;
        }
        return n;
    }

    @Override
    public long getNumElements() {
        return this.numElements;
    }

    @NotNull
    public int[] fromLinear(int n) {
        if (n < 0 || n >= this.numElements) {
            throw new IllegalArgumentException("Index out of range: " + n);
        }
        int[] nArray = new int[this.sizes.length];
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n2 = this.multiplicators[i];
            nArray[i] = n / n2;
            n %= n2;
        }
        return nArray;
    }
}

