/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.Indexable;
import de.caff.generics.Types;
import de.caff.generics.function.Function1;
import de.caff.generics.mda.HighFastMultiIndexLinearizer;
import de.caff.generics.mda.MultiDimensionalAccess;
import de.caff.generics.mda.MultiIndexLinearizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractBasicMultiDimensionalArray<T>
implements MultiDimensionalAccess<T>,
Iterable<T> {
    @NotNull
    protected final MultiIndexLinearizer indexLinearizer;

    protected AbstractBasicMultiDimensionalArray(int ... nArray) {
        this(new HighFastMultiIndexLinearizer(nArray));
    }

    protected AbstractBasicMultiDimensionalArray(@NotNull MultiIndexLinearizer multiIndexLinearizer) {
        this.indexLinearizer = multiIndexLinearizer;
    }

    @NotNull
    public MultiIndexLinearizer getIndexLinearizer() {
        return this.indexLinearizer;
    }

    protected int toLinear(int ... nArray) {
        return this.indexLinearizer.toLinear(nArray);
    }

    @Override
    public int getNumDimensions() {
        return this.indexLinearizer.getNumDimensions();
    }

    @Override
    public int getSize(int n) {
        return this.indexLinearizer.getSize(n);
    }

    @Override
    @NotNull
    public int[] getSizes() {
        return this.indexLinearizer.getSizes();
    }

    @Override
    public long getNumElements() {
        return this.indexLinearizer.getNumElements();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.iterator(this.indexLinearizer.getHighFastSequencer());
    }

    @NotNull
    public Iterator<T> iterator(@NotNull MultiIndexLinearizer.Sequencer sequencer) {
        if (!Arrays.equals(sequencer.getSizes(), this.getSizes())) {
            throw new IllegalArgumentException(String.format("Sequencer working on dimensions %s does not fit to this multi-dimensional array with dimensions %s!", Arrays.toString(sequencer.getSizes()), Arrays.toString(this.getSizes())));
        }
        final Iterator iterator = sequencer.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return AbstractBasicMultiDimensionalArray.this.getElement((int[])iterator.next());
            }
        };
    }

    public void setFrom(@NotNull Collection<? extends T> collection) {
        this.setFrom(this.indexLinearizer.getHighFastSequencer(), collection);
    }

    public void setFrom(@NotNull Iterable<? extends T> iterable) {
        this.setFrom(this.indexLinearizer.getHighFastSequencer(), iterable);
    }

    @Override
    public void setFrom(@NotNull MultiIndexLinearizer.Sequencer sequencer, @NotNull Iterable<? extends T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            if (!iterator.hasNext()) {
                throw new IllegalArgumentException("Not enough elements in iterable!");
            }
            this.setElement(iterator.next(), nArray);
        }
    }

    @NotNull
    public Indexable<T> asLinearArray() {
        return this.asLinearArray(object -> object);
    }

    @NotNull
    public Indexable<T> asLinearArray(@NotNull MultiIndexLinearizer.Sequencer sequencer) {
        return this.asLinearArray(sequencer, object -> object);
    }

    @NotNull
    public <R> Indexable<R> asLinearArray(@NotNull Function1<R, T> function1) {
        return this.asLinearArray(this.indexLinearizer.getHighFastSequencer(), function1);
    }

    @NotNull
    public <R> Indexable<R> asLinearArray(final @NotNull MultiIndexLinearizer.Sequencer sequencer, final @NotNull Function1<R, T> function1) {
        if (!Arrays.equals(sequencer.getSizes(), this.getSizes())) {
            throw new IllegalArgumentException(String.format("Sequencer working on dimensions %s does not fit to this multi-dimensional array with dimensions %s!", Arrays.toString(sequencer.getSizes()), Arrays.toString(this.getSizes())));
        }
        return new Indexable.Base<R>(){

            @Override
            public int size() {
                return (int)sequencer.getNumElements();
            }

            @Override
            public R get(int n) {
                return function1.apply(AbstractBasicMultiDimensionalArray.this.getElement((int[])sequencer.get(n)));
            }
        };
    }

    @NotNull
    public ArrayList<T> toList() {
        return this.toList(object -> object);
    }

    @NotNull
    public <R> ArrayList<R> toList(@NotNull Function1<R, T> function1) {
        return this.toList(this.indexLinearizer.getHighFastSequencer(), function1);
    }

    @NotNull
    public ArrayList<T> toList(@NotNull MultiIndexLinearizer.Sequencer sequencer) {
        return this.toList(sequencer, object -> object);
    }

    @NotNull
    public <R> ArrayList<R> toList(@NotNull MultiIndexLinearizer.Sequencer sequencer, @NotNull Function1<R, T> function1) {
        if (!Arrays.equals(sequencer.getSizes(), this.getSizes())) {
            throw new IllegalArgumentException(String.format("Sequencer working on dimensions %s does not fit to this multi-dimensional array with dimensions %s!", Arrays.toString(sequencer.getSizes()), Arrays.toString(this.getSizes())));
        }
        return Types.map(new ArrayList((int)sequencer.getNumElements()), this.iterator(sequencer), function1);
    }
}

