/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.matcher;

import de.caff.annotation.NotNull;
import de.caff.generics.Matcher;
import de.caff.generics.UniformMatcher;
import de.caff.generics.matcher.BasicMatcher;
import de.caff.generics.matcher.ComparableMatcher;
import de.caff.generics.matcher.ComparatorMatcher;
import de.caff.generics.matcher.NegateMatcher;
import de.caff.generics.matcher.NullCheckMatcher;
import de.caff.generics.matcher.ReferenceMatcher;
import de.caff.generics.matcher.RevertedMatcher;
import de.caff.generics.matcher.RevertedUniformMatcher;
import java.util.Comparator;

public final class Match {
    public static final UniformMatcher<Object> DEFAULT_MATCHER = new BasicMatcher();
    public static final UniformMatcher<Object> REVERTED_DEFAULT_MATCHER = new RevertedUniformMatcher<Object>(DEFAULT_MATCHER);
    public static final UniformMatcher<Object> REFERENCE_MATCHER = new ReferenceMatcher();

    private Match() {
    }

    public static <T1, T2> Matcher<T1, T2> revert(@NotNull Matcher<T2, T1> matcher) {
        return new RevertedMatcher<T1, T2>(matcher);
    }

    public static <T1, T2> Matcher<T1, T2> negate(@NotNull Matcher<T1, T2> matcher) {
        return new NegateMatcher<T1, T2>(matcher);
    }

    public static <T1, T2> Matcher<T1, T2> withNull(@NotNull Matcher<T1, T2> matcher) {
        return new NullCheckMatcher<T1, T2>(matcher);
    }

    public static <T> UniformMatcher<T> from(@NotNull Comparator<T> comparator) {
        return new ComparatorMatcher<T>(comparator);
    }

    public static <T extends Comparable<T>> UniformMatcher<T> forClass(@NotNull Class<T> clazz) {
        return new ComparableMatcher();
    }
}

