/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.handler;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.FragileLoopItemHandler;
import de.caff.generics.LoopItemHandler;

public class CarelessLoopItemHandler<T, E extends Exception, L extends FragileLoopItemHandler<T, E>>
implements LoopItemHandler<T> {
    private final L wrapped;
    private E exception;

    public CarelessLoopItemHandler(@NotNull L l) {
        this.wrapped = l;
    }

    @Override
    public boolean handle(T t) {
        try {
            return this.wrapped.handle(t);
        }
        catch (Exception exception) {
            this.exception = exception;
            return false;
        }
    }

    @Override
    public void beforeStart() {
        this.wrapped.beforeStart();
        this.exception = null;
    }

    @Override
    public void afterFinish() {
        this.wrapped.afterFinish();
    }

    @NotNull
    public L getWrapped() {
        return this.wrapped;
    }

    @Nullable
    public E getException() {
        return this.exception;
    }
}

