/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.function;

import de.caff.annotation.NotNull;
import de.caff.generics.Order;
import de.caff.generics.function.IntOrdering;
import de.caff.generics.function.Ordering;
import java.io.Serializable;
import java.util.Comparator;

@FunctionalInterface
public interface ShortOrdering {
    public static final ShortOrdering ASCENDING = new Serial(){
        private static final long serialVersionUID = -7646031177018732313L;

        @Override
        @NotNull
        public Order checkShort(short s, short s2) {
            return s < s2 ? Order.Ascending : (s > s2 ? Order.Descending : Order.Same);
        }

        @Override
        @NotNull
        public ShortOrdering inverse() {
            return DESCENDING;
        }

        @Override
        @NotNull
        public Comparator<Short> asShortComparator() {
            return Short::compare;
        }
    };
    public static final ShortOrdering DESCENDING = new Serial(){
        private static final long serialVersionUID = 3026851066329505442L;

        @Override
        @NotNull
        public Order checkShort(short s, short s2) {
            return s2 < s ? Order.Ascending : (s2 > s ? Order.Descending : Order.Same);
        }

        @Override
        @NotNull
        public ShortOrdering inverse() {
            return ASCENDING;
        }

        @Override
        @NotNull
        public Comparator<Short> asShortComparator() {
            return (Comparator & Serializable)(s, s2) -> Short.compare(s2, s);
        }
    };
    public static final ShortOrdering UNSIGNED_ASCENDING = new Serial(){
        private static final long serialVersionUID = -3495520630473840505L;

        @Override
        @NotNull
        public Order checkShort(short s, short s2) {
            return IntOrdering.ASCENDING.checkInt(s & 0xFFFF, s2 & 0xFFFF);
        }

        @Override
        @NotNull
        public ShortOrdering inverse() {
            return UNSIGNED_DESCENDING;
        }

        @Override
        @NotNull
        public Comparator<Short> asShortComparator() {
            return Comparator.comparingInt(s -> s & 0xFFFF);
        }
    };
    public static final ShortOrdering UNSIGNED_DESCENDING = new Serial(){
        private static final long serialVersionUID = 8393916740777317119L;

        @Override
        @NotNull
        public Order checkShort(short s, short s2) {
            return IntOrdering.DESCENDING.checkInt(s & 0xFFFF, s2 & 0xFFFF);
        }

        @Override
        @NotNull
        public ShortOrdering inverse() {
            return UNSIGNED_ASCENDING;
        }

        @Override
        @NotNull
        public Comparator<Short> asShortComparator() {
            return (Comparator & Serializable)(s, s2) -> Integer.compareUnsigned(s2.shortValue(), s.shortValue());
        }
    };

    @NotNull
    public Order checkShort(short var1, short var2);

    default public boolean ascending(short s, short s2) {
        return this.checkShort((short)s, (short)s2).ascending;
    }

    default public boolean ascendingOrSame(short s, short s2) {
        return this.checkShort((short)s, (short)s2).ascendingOrSame;
    }

    default public boolean descending(short s, short s2) {
        return this.checkShort((short)s, (short)s2).descending;
    }

    default public boolean descendingOrSame(short s, short s2) {
        return this.checkShort((short)s, (short)s2).descendingOrSame;
    }

    default public boolean same(short s, short s2) {
        return this.checkShort((short)s, (short)s2).same;
    }

    default public boolean different(short s, short s2) {
        return this.checkShort((short)s, (short)s2).different;
    }

    @NotNull
    default public ShortOrdering inverse() {
        return new Serial(){
            private static final long serialVersionUID = 3270504639153727362L;

            @Override
            @NotNull
            public Order checkShort(short s, short s2) {
                return ShortOrdering.this.checkShort(s2, s);
            }

            @Override
            @NotNull
            public ShortOrdering inverse() {
                return ShortOrdering.this;
            }
        };
    }

    @NotNull
    default public Comparator<Short> asShortComparator() {
        return (Comparator & Serializable)(s, s2) -> this.checkShort((short)s.shortValue(), (short)s2.shortValue()).comparison;
    }

    @NotNull
    default public Comparator<Number> asNumberComparator() {
        return (Comparator & Serializable)(number, number2) -> this.checkShort((short)number.shortValue(), (short)number2.shortValue()).comparison;
    }

    @NotNull
    default public Ordering<Short> asShortOrdering() {
        return this::checkShort;
    }

    @NotNull
    public static ShortOrdering fromComparator(final @NotNull Comparator<Short> comparator) {
        return new Serial(){
            private static final long serialVersionUID = 393576352771473074L;

            @Override
            @NotNull
            public Order checkShort(short s, short s2) {
                return Order.fromCompare(comparator.compare(s, s2));
            }

            @Override
            @NotNull
            public Comparator<Short> asShortComparator() {
                return comparator;
            }
        };
    }

    public static interface Serial
    extends ShortOrdering,
    Serializable {
    }
}

