/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.function;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.function.Predicates;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface Predicate1<P>
extends Predicate<P> {
    @Deprecated
    public static final Predicate1<Object> ALWAYS_TRUE = object -> true;
    @Deprecated
    public static final Predicate1<Object> ALWAYS_FALSE = object -> false;

    default public boolean testNonNull(P p, boolean bl) {
        return p == null ? bl : this.test(p);
    }

    @Override
    @NotNull
    default public Predicate1<P> and(@NotNull Predicate<? super P> predicate) {
        return object -> this.test(object) && predicate.test((P)object);
    }

    @NotNull
    default public <T extends P> Predicate1<T> and_(@NotNull Predicate<T> predicate) {
        return object -> this.test(object) && predicate.test(object);
    }

    @Override
    @NotNull
    default public Predicate1<P> or(@NotNull Predicate<? super P> predicate) {
        return object -> this.test(object) || predicate.test((P)object);
    }

    @NotNull
    default public <T extends P> Predicate1<T> or_(@NotNull Predicate<T> predicate) {
        return object -> this.test(object) || predicate.test(object);
    }

    @NotNull
    default public Predicate1<P> xor(@NotNull Predicate<? super P> predicate) {
        return object -> this.test(object) ^ predicate.test((P)object);
    }

    @NotNull
    default public <T extends P> Predicate1<T> xor_(@NotNull Predicate<T> predicate) {
        return object -> this.test(object) ^ predicate.test(object);
    }

    @Override
    @NotNull
    default public Predicate1<P> negate() {
        return new Predicate1<P>(){

            @Override
            public boolean test(P p) {
                return !Predicate1.this.test(p);
            }

            @Override
            @NotNull
            public Predicate1<P> negate() {
                return Predicate1.this;
            }
        };
    }

    @NotNull
    default public <S> Predicate1<S> adapted(@NotNull Function<? super S, ? extends P> function) {
        return object -> this.test(function.apply((Object)object));
    }

    @NotNull
    public static <T> Predicate1<T> from(@NotNull Predicate<T> predicate) {
        return predicate instanceof Predicate1 ? (Predicate1)predicate : predicate::test;
    }

    @NotNull
    public static <T> Predicate1<T> alwaysTrue() {
        return Predicates.TRUE1;
    }

    @NotNull
    public static <T> Predicate1<T> alwaysFalse() {
        return Predicates.FALSE1;
    }

    @NotNull
    public static <T> Predicate1<T> isNull() {
        return Objects::isNull;
    }

    @NotNull
    public static <T> Predicate1<T> notNull() {
        return Objects::nonNull;
    }

    @NotNull
    public static <T> Predicate1<T> isEqual(@Nullable T t) {
        return object2 -> Objects.deepEquals(t, object2);
    }

    @NotNull
    public static <T> Predicate1<T> and(@NotNull Predicate<? super T> predicate, @NotNull Predicate<? super T> predicate2) {
        return object -> predicate.test(object) && predicate2.test(object);
    }

    @NotNull
    public static <T> Predicate1<T> or(@NotNull Predicate<? super T> predicate, @NotNull Predicate<? super T> predicate2) {
        return object -> predicate.test(object) || predicate2.test(object);
    }

    @NotNull
    public static <T> Predicate1<T> xor(@NotNull Predicate<? super T> predicate, @NotNull Predicate<? super T> predicate2) {
        return object -> predicate.test(object) ^ predicate2.test(object);
    }
}

