/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.function;

import de.caff.annotation.NotNull;
import de.caff.generics.Order;
import de.caff.generics.function.DoubleOrdering;
import java.io.Serializable;
import java.util.Comparator;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;

@FunctionalInterface
public interface Ordering<T> {
    @NotNull
    public Order check(T var1, T var2);

    default public boolean ascending(T t, T t2) {
        return this.check(t, t2).ascending;
    }

    default public boolean ascendingOrSame(T t, T t2) {
        return this.check(t, t2).ascendingOrSame;
    }

    default public boolean descending(T t, T t2) {
        return this.check(t, t2).descending;
    }

    default public boolean descendingOrSame(T t, T t2) {
        return this.check(t, t2).descendingOrSame;
    }

    default public boolean same(T t, T t2) {
        return this.check(t, t2).same;
    }

    default public boolean different(T t, T t2) {
        return this.check(t, t2).different;
    }

    @NotNull
    default public Ordering<T> inverse() {
        return new Serial<T>(){
            private static final long serialVersionUID = -4235884649457541199L;

            @Override
            @NotNull
            public Order check(T t, T t2) {
                return Ordering.this.check(t2, t);
            }

            @Override
            @NotNull
            public Ordering<T> inverse() {
                return Ordering.this;
            }
        };
    }

    default public Ordering<T> nullsFirst() {
        return (Ordering<Object> & Serializable)(object, object2) -> object == null ? (object2 == null ? Order.Same : Order.Ascending) : (object2 == null ? Order.Descending : this.check(object, object2));
    }

    default public Ordering<T> nullsLast() {
        return (Ordering<Object> & Serializable)(object, object2) -> object == null ? (object2 == null ? Order.Same : Order.Descending) : (object2 == null ? Order.Ascending : this.check(object, object2));
    }

    @NotNull
    default public Comparator<T> asComparator() {
        return (Comparator & Serializable)(object, object2) -> this.check(object, object2).comparison;
    }

    @NotNull
    default public Ordering<T> andIfSame(@NotNull Ordering<? super T> ordering) {
        return (Ordering<Object> & Serializable)(object, object2) -> {
            Order order = this.check(object, object2);
            return order == Order.Same ? ordering.check(object, object2) : order;
        };
    }

    @NotNull
    default public <S> Ordering<T> andIfSame(@NotNull Function<? super T, ? extends S> function, @NotNull Ordering<? super S> ordering) {
        return this.andIfSame(Ordering.ordering(function, ordering));
    }

    @NotNull
    default public <S extends Comparable<? super S>> Ordering<T> andIfSame(@NotNull Function<? super T, ? extends S> function) {
        return this.andIfSame(Ordering.ordering(function));
    }

    @NotNull
    public static <S, K> Ordering<S> ordering(@NotNull Function<? super S, ? extends K> function, @NotNull Ordering<? super K> ordering) {
        return (Ordering<Object> & Serializable)(object, object2) -> ordering.check((Object)function.apply((Object)object), (Object)function.apply((Object)object2));
    }

    @NotNull
    public static <S, K extends Comparable<? super K>> Ordering<S> ordering(@NotNull Function<? super S, ? extends K> function) {
        return (Ordering<Object> & Serializable)(object, object2) -> Order.fromCompare(((Comparable)function.apply((Object)object)).compareTo(function.apply((Object)object2)));
    }

    @NotNull
    public static <S> Ordering<S> orderingDouble(@NotNull ToDoubleFunction<? super S> toDoubleFunction, @NotNull DoubleOrdering doubleOrdering) {
        return (object, object2) -> doubleOrdering.checkDouble(toDoubleFunction.applyAsDouble((Object)object), toDoubleFunction.applyAsDouble((Object)object2));
    }

    @NotNull
    public static <S> Ordering<S> orderingDouble(@NotNull ToDoubleFunction<? super S> toDoubleFunction) {
        return Ordering.orderingDouble(toDoubleFunction, DoubleOrdering.STANDARD_ASCENDING);
    }

    @NotNull
    default public BiPredicate<T, T> asEqualityChecker() {
        return (object, object2) -> this.check(object, object2) == Order.Same;
    }

    @NotNull
    public static <E> Ordering<E> fromComparator(final @NotNull Comparator<E> comparator) {
        return new Serial<E>(){
            private static final long serialVersionUID = 1262617626311521623L;

            @Override
            @NotNull
            public Order check(E e, E e2) {
                return Order.fromCompare(comparator.compare(e, e2));
            }

            @Override
            @NotNull
            public Comparator<E> asComparator() {
                return comparator;
            }
        };
    }

    @NotNull
    public static <E extends Comparable<? super E>> Ordering<E> natural() {
        return new Serial<E>(){
            private static final long serialVersionUID = -7486072987131063309L;

            @Override
            @NotNull
            public Order check(E e, E e2) {
                return Order.fromCompare(e.compareTo(e2));
            }

            @Override
            @NotNull
            public Comparator<E> asComparator() {
                return Comparator.naturalOrder();
            }
        };
    }

    @NotNull
    public static <E extends Comparable<? super E>> Ordering<E> inverseNatural() {
        return new Serial<E>(){
            private static final long serialVersionUID = -1428976512512032469L;

            @Override
            @NotNull
            public Order check(E e, E e2) {
                return Order.fromCompare(e2.compareTo(e));
            }

            @Override
            @NotNull
            public Comparator<E> asComparator() {
                return (Comparator & Serializable)(comparable, comparable2) -> comparable2.compareTo(comparable);
            }
        };
    }

    public static interface Serial<E>
    extends Ordering<E>,
    Serializable {
    }
}

