/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.function;

import de.caff.annotation.NotNull;
import de.caff.generics.Order;
import de.caff.generics.function.Ordering;
import java.io.Serializable;
import java.util.Comparator;

@FunctionalInterface
public interface LongOrdering {
    public static final LongOrdering ASCENDING = new Serial(){
        private static final long serialVersionUID = -7646031177018732313L;

        @Override
        @NotNull
        public Order checkLong(long l, long l2) {
            return l < l2 ? Order.Ascending : (l > l2 ? Order.Descending : Order.Same);
        }

        @Override
        @NotNull
        public LongOrdering inverse() {
            return DESCENDING;
        }

        @Override
        @NotNull
        public Comparator<Long> asLongComparator() {
            return Long::compare;
        }
    };
    public static final LongOrdering DESCENDING = new Serial(){
        private static final long serialVersionUID = 3026851066329505442L;

        @Override
        @NotNull
        public Order checkLong(long l, long l2) {
            return l2 < l ? Order.Ascending : (l2 > l ? Order.Descending : Order.Same);
        }

        @Override
        @NotNull
        public LongOrdering inverse() {
            return ASCENDING;
        }

        @Override
        @NotNull
        public Comparator<Long> asLongComparator() {
            return (Comparator & Serializable)(l, l2) -> Long.compare(l2, l);
        }
    };
    public static final LongOrdering UNSIGNED_ASCENDING = new Serial(){
        private static final long serialVersionUID = -3495520630473840505L;

        @Override
        @NotNull
        public Order checkLong(long l, long l2) {
            return ASCENDING.checkLong(l + Long.MIN_VALUE, l2 + Long.MIN_VALUE);
        }

        @Override
        @NotNull
        public LongOrdering inverse() {
            return UNSIGNED_DESCENDING;
        }

        @Override
        @NotNull
        public Comparator<Long> asLongComparator() {
            return Long::compareUnsigned;
        }
    };
    public static final LongOrdering UNSIGNED_DESCENDING = new Serial(){
        private static final long serialVersionUID = 8393916740777317119L;

        @Override
        @NotNull
        public Order checkLong(long l, long l2) {
            return DESCENDING.checkLong(l + Long.MIN_VALUE, l2 + Long.MIN_VALUE);
        }

        @Override
        @NotNull
        public LongOrdering inverse() {
            return UNSIGNED_ASCENDING;
        }

        @Override
        @NotNull
        public Comparator<Long> asLongComparator() {
            return (Comparator & Serializable)(l, l2) -> Long.compareUnsigned(l2, l);
        }
    };

    @NotNull
    public Order checkLong(long var1, long var3);

    @NotNull
    default public Order check(Long l, Long l2) {
        return this.checkLong(l, l2);
    }

    default public boolean ascending(long l, long l2) {
        return this.checkLong((long)l, (long)l2).ascending;
    }

    default public boolean ascendingOrSame(long l, long l2) {
        return this.checkLong((long)l, (long)l2).ascendingOrSame;
    }

    default public boolean descending(long l, long l2) {
        return this.checkLong((long)l, (long)l2).descending;
    }

    default public boolean descendingOrSame(long l, long l2) {
        return this.checkLong((long)l, (long)l2).descendingOrSame;
    }

    default public boolean same(long l, long l2) {
        return this.checkLong((long)l, (long)l2).same;
    }

    default public boolean different(long l, long l2) {
        return this.checkLong((long)l, (long)l2).different;
    }

    @NotNull
    default public LongOrdering inverse() {
        return new Serial(){
            private static final long serialVersionUID = 3270504639153727362L;

            @Override
            @NotNull
            public Order checkLong(long l, long l2) {
                return LongOrdering.this.checkLong(l2, l);
            }

            @Override
            @NotNull
            public LongOrdering inverse() {
                return LongOrdering.this;
            }
        };
    }

    @NotNull
    default public Comparator<Long> asLongComparator() {
        return (Comparator & Serializable)(l, l2) -> this.checkLong((long)l.longValue(), (long)l2.longValue()).comparison;
    }

    @NotNull
    default public Comparator<Number> asNumberComparator() {
        return (Comparator & Serializable)(number, number2) -> this.checkLong((long)number.longValue(), (long)number2.longValue()).comparison;
    }

    @NotNull
    default public Ordering<Long> asLongOrdering() {
        return this::checkLong;
    }

    @NotNull
    public static LongOrdering fromComparator(final @NotNull Comparator<Long> comparator) {
        return new Serial(){
            private static final long serialVersionUID = 393576352771473074L;

            @Override
            @NotNull
            public Order checkLong(long l, long l2) {
                return Order.fromCompare(comparator.compare(l, l2));
            }

            @Override
            @NotNull
            public Comparator<Long> asLongComparator() {
                return comparator;
            }
        };
    }

    public static interface Serial
    extends LongOrdering,
    Serializable {
    }
}

