/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.function;

import de.caff.annotation.NotNull;
import de.caff.generics.Order;
import de.caff.generics.function.ByteOrdering;
import de.caff.generics.function.CharOrdering;
import de.caff.generics.function.Ordering;
import de.caff.generics.function.ShortOrdering;
import java.io.Serializable;
import java.util.Comparator;

@FunctionalInterface
public interface IntOrdering
extends ByteOrdering,
ShortOrdering,
CharOrdering {
    public static final IntOrdering ASCENDING = new Serial(){
        private static final long serialVersionUID = -7646031177018732313L;

        @Override
        @NotNull
        public Order checkInt(int n, int n2) {
            return n < n2 ? Order.Ascending : (n > n2 ? Order.Descending : Order.Same);
        }

        @Override
        @NotNull
        public IntOrdering inverse() {
            return DESCENDING;
        }

        @Override
        @NotNull
        public Comparator<Integer> asIntComparator() {
            return Integer::compare;
        }
    };
    public static final IntOrdering DESCENDING = new Serial(){
        private static final long serialVersionUID = 3026851066329505442L;

        @Override
        @NotNull
        public Order checkInt(int n, int n2) {
            return n2 < n ? Order.Ascending : (n2 > n ? Order.Descending : Order.Same);
        }

        @Override
        @NotNull
        public IntOrdering inverse() {
            return ASCENDING;
        }

        @Override
        @NotNull
        public Comparator<Integer> asIntComparator() {
            return (Comparator & Serializable)(n, n2) -> Integer.compare(n2, n);
        }
    };
    public static final IntOrdering UNSIGNED_ASCENDING = new Serial(){
        private static final long serialVersionUID = -3495520630473840505L;

        @Override
        @NotNull
        public Order checkInt(int n, int n2) {
            return ASCENDING.checkInt(n + Integer.MIN_VALUE, n2 + Integer.MIN_VALUE);
        }

        @Override
        @NotNull
        public IntOrdering inverse() {
            return UNSIGNED_DESCENDING;
        }

        @Override
        @NotNull
        public Comparator<Integer> asIntComparator() {
            return Integer::compareUnsigned;
        }
    };
    public static final IntOrdering UNSIGNED_DESCENDING = new Serial(){
        private static final long serialVersionUID = 8393916740777317119L;

        @Override
        @NotNull
        public Order checkInt(int n, int n2) {
            return DESCENDING.checkInt(n + Integer.MIN_VALUE, n2 + Integer.MIN_VALUE);
        }

        @Override
        @NotNull
        public IntOrdering inverse() {
            return UNSIGNED_ASCENDING;
        }

        @Override
        @NotNull
        public Comparator<Integer> asIntComparator() {
            return (Comparator & Serializable)(n, n2) -> Integer.compareUnsigned(n2, n);
        }
    };

    @NotNull
    public Order checkInt(int var1, int var2);

    @Override
    @NotNull
    default public Order checkByte(byte by, byte by2) {
        return this.checkInt(by, by2);
    }

    @Override
    @NotNull
    default public Order checkChar(char c, char c2) {
        return this.checkInt(c, c2);
    }

    @Override
    @NotNull
    default public Order checkShort(short s, short s2) {
        return this.checkInt(s, s2);
    }

    default public boolean ascending(int n, int n2) {
        return this.checkInt((int)n, (int)n2).ascending;
    }

    default public boolean ascendingOrSame(int n, int n2) {
        return this.checkInt((int)n, (int)n2).ascendingOrSame;
    }

    default public boolean descending(int n, int n2) {
        return this.checkInt((int)n, (int)n2).descending;
    }

    default public boolean descendingOrSame(int n, int n2) {
        return this.checkInt((int)n, (int)n2).descendingOrSame;
    }

    default public boolean same(int n, int n2) {
        return this.checkInt((int)n, (int)n2).same;
    }

    default public boolean different(int n, int n2) {
        return this.checkInt((int)n, (int)n2).different;
    }

    @Override
    @NotNull
    default public IntOrdering inverse() {
        return new Serial(){
            private static final long serialVersionUID = 3270504639153727362L;

            @Override
            @NotNull
            public Order checkInt(int n, int n2) {
                return IntOrdering.this.checkInt(n2, n);
            }

            @Override
            @NotNull
            public IntOrdering inverse() {
                return IntOrdering.this;
            }
        };
    }

    @NotNull
    default public Comparator<Integer> asIntComparator() {
        return (Comparator & Serializable)(n, n2) -> this.checkInt((int)n.intValue(), (int)n2.intValue()).comparison;
    }

    @Override
    @NotNull
    default public Comparator<Number> asNumberComparator() {
        return (Comparator & Serializable)(number, number2) -> this.checkInt((int)number.intValue(), (int)number2.intValue()).comparison;
    }

    @NotNull
    default public Ordering<Integer> asIntOrdering() {
        return this::checkInt;
    }

    @NotNull
    public static IntOrdering fromComparator(final @NotNull Comparator<Integer> comparator) {
        return new Serial(){
            private static final long serialVersionUID = 393576352771473074L;

            @Override
            @NotNull
            public Order checkInt(int n, int n2) {
                return Order.fromCompare(comparator.compare(n, n2));
            }

            @Override
            @NotNull
            public Comparator<Integer> asIntComparator() {
                return comparator;
            }
        };
    }

    public static interface Serial
    extends IntOrdering,
    Serializable {
    }
}

