/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.function;

import de.caff.annotation.NotNull;
import de.caff.generics.Types;
import de.caff.generics.WrappedFragileException;
import de.caff.generics.function.EvaluationException;
import de.caff.generics.function.FragileFunction1;
import de.caff.generics.function.Function0;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface Function1<R, P>
extends Function<P, R> {
    @NotNull
    default public R applyOrDefault(P p, @NotNull R r) {
        return Types.notNull(this.apply(p), r);
    }

    default public R applyNonNull(P p, R r) {
        return p == null ? r : this.apply(p);
    }

    @NotNull
    default public Function1<R, P> withFallback(@NotNull Function1<? extends R, ? super P> function1) {
        return Function1.fallback(this, function1);
    }

    @NotNull
    default public Function0<R> partial(P p) {
        return () -> this.apply(p);
    }

    @NotNull
    default public <T> Function1<R, T> after(@NotNull Function<? super T, ? extends P> function) {
        return object -> this.apply(function.apply(object));
    }

    @Override
    @NotNull
    default public <T> Function1<T, P> andThen(@NotNull Function<? super R, ? extends T> function) {
        return object -> function.apply((R)this.apply(object));
    }

    @NotNull
    public static <TT, PP, EE extends Exception> Function1<TT, PP> from(@NotNull FragileFunction1<TT, EE, PP> fragileFunction1) {
        return object -> {
            try {
                return fragileFunction1.apply(object);
            }
            catch (Exception exception) {
                throw new EvaluationException("Caught exception during function evaluation!", exception);
            }
        };
    }

    @NotNull
    public static <RR, PP> Function1<RR, PP> from(@NotNull Function<PP, RR> function) {
        return function instanceof Function1 ? (Function1)function : function::apply;
    }

    @NotNull
    public static <RR, PP> Function1<RR, PP> fallback(@NotNull Function1<? extends RR, ? super PP> function1, @NotNull Function1<? extends RR, ? super PP> function12) {
        return object -> {
            Object r = function1.apply(object);
            return r != null ? r : function12.apply(object);
        };
    }

    @NotNull
    public static <RR, PP> Function1<RR, PP> fallback(@NotNull Predicate<? super RR> predicate, @NotNull Function1<? extends RR, ? super PP> function1, @NotNull Function1<? extends RR, ? super PP> function12) {
        return object -> {
            Object r = function1.apply(object);
            return predicate.test((Object)r) ? r : function12.apply(object);
        };
    }

    @NotNull
    public static <E extends Exception, RR, PP> Function1<RR, PP> nonFragile(@NotNull FragileFunction1<? extends RR, E, ? super PP> fragileFunction1) {
        return object -> {
            try {
                return fragileFunction1.apply((Object)object);
            }
            catch (Exception exception) {
                throw new WrappedFragileException(exception, "Caught hidden fragile exception!");
            }
        };
    }

    @NotNull
    public static <E extends Exception, RR, PP> Function1<RR, PP> nonFragile(@NotNull FragileFunction1<? extends RR, E, ? super PP> fragileFunction1, RR RR) {
        return object2 -> {
            try {
                return fragileFunction1.apply((Object)object2);
            }
            catch (Exception exception) {
                return RR;
            }
        };
    }

    @NotNull
    public static <E extends Exception, RR, PP> Function1<RR, PP> nonFragileX(@NotNull FragileFunction1<? extends RR, E, ? super PP> fragileFunction1, @NotNull BiFunction<? super E, ? super PP, ? extends RR> biFunction) {
        return object -> {
            try {
                return fragileFunction1.apply((Object)object);
            }
            catch (Exception exception) {
                return biFunction.apply((Object)exception, (Object)object);
            }
        };
    }
}

