/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.function;

import de.caff.annotation.NotNull;
import de.caff.generics.Order;
import de.caff.generics.Primitives;
import de.caff.generics.function.Ordering;
import java.io.Serializable;
import java.util.Comparator;

@FunctionalInterface
public interface FloatOrdering {
    public static final FloatOrdering NATURAL_ASCENDING = new Serial(){
        private static final long serialVersionUID = 3025885466446256167L;

        @Override
        @NotNull
        public Order checkFloat(float f, float f2) {
            return Primitives.order(f, f2);
        }

        @Override
        @NotNull
        public Comparator<Float> asFloatComparator() {
            return Primitives::compare;
        }

        @Override
        @NotNull
        public FloatOrdering inverse() {
            return NATURAL_DESCENDING;
        }
    };
    public static final FloatOrdering NATURAL_DESCENDING = new Serial(){
        private static final long serialVersionUID = 3025885466446256167L;

        @Override
        @NotNull
        public Order checkFloat(float f, float f2) {
            return Primitives.order(f2, f);
        }

        @Override
        @NotNull
        public Comparator<Float> asFloatComparator() {
            return (Comparator & Serializable)(f, f2) -> Primitives.compare(f2.floatValue(), f.floatValue());
        }

        @Override
        @NotNull
        public FloatOrdering inverse() {
            return NATURAL_ASCENDING;
        }
    };
    public static final FloatOrdering STANDARD_ASCENDING = new Serial(){
        private static final long serialVersionUID = 3025885466446256167L;

        @Override
        @NotNull
        public Order checkFloat(float f, float f2) {
            int n;
            if (f < f2) {
                return Order.Ascending;
            }
            if (f > f2) {
                return Order.Descending;
            }
            int n2 = Float.floatToIntBits(f);
            return n2 == (n = Float.floatToIntBits(f2)) ? Order.Same : (n2 < n ? Order.Ascending : Order.Descending);
        }

        @Override
        @NotNull
        public FloatOrdering inverse() {
            return STANDARD_DESCENDING;
        }

        @Override
        @NotNull
        public Comparator<Float> asFloatComparator() {
            return Float::compare;
        }
    };
    public static final FloatOrdering STANDARD_DESCENDING = new Serial(){
        private static final long serialVersionUID = 8490254886442973329L;

        @Override
        @NotNull
        public Order checkFloat(float f, float f2) {
            int n;
            if (f2 < f) {
                return Order.Ascending;
            }
            if (f2 > f) {
                return Order.Descending;
            }
            int n2 = Float.floatToIntBits(f2);
            return n2 == (n = Float.floatToIntBits(f)) ? Order.Same : (n2 < n ? Order.Ascending : Order.Descending);
        }

        @Override
        @NotNull
        public FloatOrdering inverse() {
            return STANDARD_ASCENDING;
        }

        @Override
        @NotNull
        public Comparator<Float> asFloatComparator() {
            return (f, f2) -> Float.compare(f2.floatValue(), f.floatValue());
        }
    };

    @NotNull
    public Order checkFloat(float var1, float var2);

    default public boolean ascending(float f, float f2) {
        return this.checkFloat((float)f, (float)f2).ascending;
    }

    default public boolean ascendingOrSame(float f, float f2) {
        return this.checkFloat((float)f, (float)f2).ascendingOrSame;
    }

    default public boolean descending(float f, float f2) {
        return this.checkFloat((float)f, (float)f2).descending;
    }

    default public boolean descendingOrSame(float f, float f2) {
        return this.checkFloat((float)f, (float)f2).descendingOrSame;
    }

    default public boolean same(float f, float f2) {
        return this.checkFloat((float)f, (float)f2).same;
    }

    default public boolean different(float f, float f2) {
        return this.checkFloat((float)f, (float)f2).different;
    }

    @NotNull
    default public FloatOrdering inverse() {
        return new FloatOrdering(){

            @Override
            @NotNull
            public Order checkFloat(float f, float f2) {
                return FloatOrdering.this.checkFloat(f2, f);
            }

            @Override
            @NotNull
            public FloatOrdering inverse() {
                return FloatOrdering.this;
            }
        };
    }

    @NotNull
    default public Comparator<Float> asFloatComparator() {
        return (f, f2) -> this.checkFloat((float)f.floatValue(), (float)f2.floatValue()).comparison;
    }

    @NotNull
    default public Comparator<Number> asNumberComparator() {
        return (Comparator & Serializable)(number, number2) -> this.checkFloat((float)number.floatValue(), (float)number2.floatValue()).comparison;
    }

    @NotNull
    default public Ordering<Float> asFloatOrdering() {
        return this::checkFloat;
    }

    @NotNull
    public static FloatOrdering fromComparator(@NotNull Comparator<Float> comparator) {
        return (f, f2) -> Order.fromCompare(comparator.compare(Float.valueOf(f), Float.valueOf(f2)));
    }

    public static interface Serial
    extends FloatOrdering,
    Serializable {
    }
}

