/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.function;

import de.caff.annotation.NotNull;
import de.caff.generics.Order;
import de.caff.generics.Primitives;
import de.caff.generics.function.FloatOrdering;
import de.caff.generics.function.Ordering;
import java.io.Serializable;
import java.util.Comparator;

@FunctionalInterface
public interface DoubleOrdering
extends FloatOrdering {
    public static final DoubleOrdering NATURAL_ASCENDING = new Serial(){
        private static final long serialVersionUID = 3025885466446256167L;

        @Override
        @NotNull
        public Order checkDouble(double d, double d2) {
            return Primitives.order(d, d2);
        }

        @Override
        @NotNull
        public Comparator<Double> asDoubleComparator() {
            return Primitives::compare;
        }

        @Override
        @NotNull
        public DoubleOrdering inverse() {
            return NATURAL_DESCENDING;
        }
    };
    public static final DoubleOrdering NATURAL_DESCENDING = new Serial(){
        private static final long serialVersionUID = 3025885466446256167L;

        @Override
        @NotNull
        public Order checkDouble(double d, double d2) {
            return Primitives.order(d2, d);
        }

        @Override
        @NotNull
        public Comparator<Double> asDoubleComparator() {
            return (Comparator & Serializable)(d, d2) -> Primitives.compare(d2, d);
        }

        @Override
        @NotNull
        public DoubleOrdering inverse() {
            return NATURAL_ASCENDING;
        }
    };
    public static final DoubleOrdering STANDARD_ASCENDING = new Serial(){
        private static final long serialVersionUID = 3025885466446256167L;

        @Override
        @NotNull
        public Order checkDouble(double d, double d2) {
            long l;
            if (d < d2) {
                return Order.Ascending;
            }
            if (d > d2) {
                return Order.Descending;
            }
            long l2 = Double.doubleToLongBits(d);
            return l2 == (l = Double.doubleToLongBits(d2)) ? Order.Same : (l2 < l ? Order.Ascending : Order.Descending);
        }

        @Override
        @NotNull
        public DoubleOrdering inverse() {
            return STANDARD_DESCENDING;
        }

        @Override
        @NotNull
        public Comparator<Double> asDoubleComparator() {
            return Double::compare;
        }
    };
    public static final DoubleOrdering STANDARD_DESCENDING = new Serial(){
        private static final long serialVersionUID = 8490254886442973329L;

        @Override
        @NotNull
        public Order checkDouble(double d, double d2) {
            long l;
            if (d2 < d) {
                return Order.Ascending;
            }
            if (d2 > d) {
                return Order.Descending;
            }
            long l2 = Double.doubleToLongBits(d2);
            return l2 == (l = Double.doubleToLongBits(d)) ? Order.Same : (l2 < l ? Order.Ascending : Order.Descending);
        }

        @Override
        @NotNull
        public DoubleOrdering inverse() {
            return STANDARD_ASCENDING;
        }

        @Override
        @NotNull
        public Comparator<Double> asDoubleComparator() {
            return (d, d2) -> Double.compare(d2, d);
        }
    };

    @NotNull
    public Order checkDouble(double var1, double var3);

    @Override
    @NotNull
    default public Order checkFloat(float f, float f2) {
        return this.checkDouble(f, f2);
    }

    @NotNull
    default public Ordering<Number> asNumberOrdering() {
        return (number, number2) -> this.checkDouble(number.doubleValue(), number2.doubleValue());
    }

    default public boolean ascending(double d, double d2) {
        return this.checkDouble((double)d, (double)d2).ascending;
    }

    default public boolean ascendingOrSame(double d, double d2) {
        return this.checkDouble((double)d, (double)d2).ascendingOrSame;
    }

    default public boolean descending(double d, double d2) {
        return this.checkDouble((double)d, (double)d2).descending;
    }

    default public boolean descendingOrSame(double d, double d2) {
        return this.checkDouble((double)d, (double)d2).descendingOrSame;
    }

    default public boolean same(double d, double d2) {
        return this.checkDouble((double)d, (double)d2).same;
    }

    default public boolean different(double d, double d2) {
        return this.checkDouble((double)d, (double)d2).different;
    }

    @Override
    @NotNull
    default public DoubleOrdering inverse() {
        return new DoubleOrdering(){

            @Override
            @NotNull
            public Order checkDouble(double d, double d2) {
                return DoubleOrdering.this.checkDouble(d2, d);
            }

            @Override
            @NotNull
            public DoubleOrdering inverse() {
                return DoubleOrdering.this;
            }
        };
    }

    @NotNull
    default public Comparator<Double> asDoubleComparator() {
        return (Comparator & Serializable)(d, d2) -> this.checkDouble((double)d.doubleValue(), (double)d2.doubleValue()).comparison;
    }

    @Override
    @NotNull
    default public Comparator<Number> asNumberComparator() {
        return (Comparator & Serializable)(number, number2) -> this.checkDouble((double)number.doubleValue(), (double)number2.doubleValue()).comparison;
    }

    @NotNull
    default public Ordering<Double> asDoubleOrdering() {
        return this::checkDouble;
    }

    @NotNull
    public static DoubleOrdering fromComparator(final @NotNull Comparator<Double> comparator) {
        return new Serial(){
            private static final long serialVersionUID = -7834494744673376888L;

            @Override
            @NotNull
            public Order checkDouble(double d, double d2) {
                return Order.fromCompare(comparator.compare(d, d2));
            }

            @Override
            @NotNull
            public Comparator<Double> asDoubleComparator() {
                return comparator;
            }
        };
    }

    public static interface Serial
    extends DoubleOrdering,
    Serializable {
    }
}

