/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.function;

import de.caff.annotation.NotNull;
import de.caff.generics.Order;
import de.caff.generics.function.Ordering;
import java.io.Serializable;
import java.util.Comparator;

@FunctionalInterface
public interface CharOrdering {
    public static final CharOrdering ASCENDING = new Serial(){
        private static final long serialVersionUID = -7646031177018732313L;

        @Override
        @NotNull
        public Order checkChar(char c, char c2) {
            return c < c2 ? Order.Ascending : (c > c2 ? Order.Descending : Order.Same);
        }

        @Override
        @NotNull
        public CharOrdering inverse() {
            return DESCENDING;
        }

        @Override
        @NotNull
        public Comparator<Character> asCharComparator() {
            return Character::compare;
        }
    };
    public static final CharOrdering DESCENDING = new Serial(){
        private static final long serialVersionUID = 3026851066329505442L;

        @Override
        @NotNull
        public Order checkChar(char c, char c2) {
            return c2 < c ? Order.Ascending : (c2 > c ? Order.Descending : Order.Same);
        }

        @Override
        @NotNull
        public CharOrdering inverse() {
            return ASCENDING;
        }

        @Override
        @NotNull
        public Comparator<Character> asCharComparator() {
            return (Comparator & Serializable)(c, c2) -> Character.compare(c2.charValue(), c.charValue());
        }
    };

    @NotNull
    public Order checkChar(char var1, char var2);

    default public boolean ascending(char c, char c2) {
        return this.checkChar((char)c, (char)c2).ascending;
    }

    default public boolean ascendingOrSame(char c, char c2) {
        return this.checkChar((char)c, (char)c2).ascendingOrSame;
    }

    default public boolean descending(char c, char c2) {
        return this.checkChar((char)c, (char)c2).descending;
    }

    default public boolean descendingOrSame(char c, char c2) {
        return this.checkChar((char)c, (char)c2).descendingOrSame;
    }

    default public boolean same(char c, char c2) {
        return this.checkChar((char)c, (char)c2).same;
    }

    default public boolean different(char c, char c2) {
        return this.checkChar((char)c, (char)c2).different;
    }

    @NotNull
    default public CharOrdering inverse() {
        return new Serial(){
            private static final long serialVersionUID = 3270504639153727362L;

            @Override
            @NotNull
            public Order checkChar(char c, char c2) {
                return CharOrdering.this.checkChar(c2, c);
            }

            @Override
            @NotNull
            public CharOrdering inverse() {
                return CharOrdering.this;
            }
        };
    }

    @NotNull
    default public Comparator<Character> asCharComparator() {
        return (Comparator & Serializable)(c, c2) -> this.checkChar((char)c.charValue(), (char)c2.charValue()).comparison;
    }

    @NotNull
    default public Ordering<Character> asCharOrdering() {
        return this::checkChar;
    }

    @NotNull
    public static CharOrdering fromComparator(final @NotNull Comparator<Character> comparator) {
        return new Serial(){
            private static final long serialVersionUID = 393576352771473074L;

            @Override
            @NotNull
            public Order checkChar(char c, char c2) {
                return Order.fromCompare(comparator.compare(Character.valueOf(c), Character.valueOf(c2)));
            }

            @Override
            @NotNull
            public Comparator<Character> asCharComparator() {
                return comparator;
            }
        };
    }

    public static interface Serial
    extends CharOrdering,
    Serializable {
    }
}

