/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.function;

import de.caff.annotation.NotNull;
import de.caff.generics.Order;
import de.caff.generics.function.IntOrdering;
import de.caff.generics.function.Ordering;
import java.io.Serializable;
import java.util.Comparator;

@FunctionalInterface
public interface ByteOrdering {
    public static final ByteOrdering ASCENDING = new Serial(){
        private static final long serialVersionUID = -7646031177018732313L;

        @Override
        @NotNull
        public Order checkByte(byte by, byte by2) {
            return by < by2 ? Order.Ascending : (by > by2 ? Order.Descending : Order.Same);
        }

        @Override
        @NotNull
        public ByteOrdering inverse() {
            return DESCENDING;
        }

        @Override
        @NotNull
        public Comparator<Byte> asByteComparator() {
            return Byte::compare;
        }
    };
    public static final ByteOrdering DESCENDING = new Serial(){
        private static final long serialVersionUID = 3026851066329505442L;

        @Override
        @NotNull
        public Order checkByte(byte by, byte by2) {
            return by2 < by ? Order.Ascending : (by2 > by ? Order.Descending : Order.Same);
        }

        @Override
        @NotNull
        public ByteOrdering inverse() {
            return ASCENDING;
        }

        @Override
        @NotNull
        public Comparator<Byte> asByteComparator() {
            return (Comparator & Serializable)(by, by2) -> Byte.compare(by2, by);
        }
    };
    public static final ByteOrdering UNSIGNED_ASCENDING = new Serial(){
        private static final long serialVersionUID = -3495520630473840505L;

        @Override
        @NotNull
        public Order checkByte(byte by, byte by2) {
            return IntOrdering.ASCENDING.checkInt(by & 0xFF, by2 & 0xFF);
        }

        @Override
        @NotNull
        public ByteOrdering inverse() {
            return UNSIGNED_DESCENDING;
        }

        @Override
        @NotNull
        public Comparator<Byte> asByteComparator() {
            return Comparator.comparingInt(by -> by & 0xFF);
        }
    };
    public static final ByteOrdering UNSIGNED_DESCENDING = new Serial(){
        private static final long serialVersionUID = 8393916740777317119L;

        @Override
        @NotNull
        public Order checkByte(byte by, byte by2) {
            return IntOrdering.DESCENDING.checkInt(by & 0xFF, by2 & 0xFF);
        }

        @Override
        @NotNull
        public ByteOrdering inverse() {
            return UNSIGNED_ASCENDING;
        }

        @Override
        @NotNull
        public Comparator<Byte> asByteComparator() {
            return (Comparator & Serializable)(by, by2) -> Integer.compareUnsigned(by2.byteValue(), by.byteValue());
        }
    };

    @NotNull
    public Order checkByte(byte var1, byte var2);

    default public boolean ascending(byte by, byte by2) {
        return this.checkByte((byte)by, (byte)by2).ascending;
    }

    default public boolean ascendingOrSame(byte by, byte by2) {
        return this.checkByte((byte)by, (byte)by2).ascendingOrSame;
    }

    default public boolean descending(byte by, byte by2) {
        return this.checkByte((byte)by, (byte)by2).descending;
    }

    default public boolean descendingOrSame(byte by, byte by2) {
        return this.checkByte((byte)by, (byte)by2).descendingOrSame;
    }

    default public boolean same(byte by, byte by2) {
        return this.checkByte((byte)by, (byte)by2).same;
    }

    default public boolean different(byte by, byte by2) {
        return this.checkByte((byte)by, (byte)by2).different;
    }

    @NotNull
    default public ByteOrdering inverse() {
        return new Serial(){
            private static final long serialVersionUID = 3270504639153727362L;

            @Override
            @NotNull
            public Order checkByte(byte by, byte by2) {
                return ByteOrdering.this.checkByte(by2, by);
            }

            @Override
            @NotNull
            public ByteOrdering inverse() {
                return ByteOrdering.this;
            }
        };
    }

    @NotNull
    default public Comparator<Byte> asByteComparator() {
        return (Comparator & Serializable)(by, by2) -> this.checkByte((byte)by.byteValue(), (byte)by2.byteValue()).comparison;
    }

    @NotNull
    default public Comparator<Number> asNumberComparator() {
        return (Comparator & Serializable)(number, number2) -> this.checkByte((byte)number.byteValue(), (byte)number2.byteValue()).comparison;
    }

    @NotNull
    default public Ordering<Byte> asByteOrdering() {
        return this::checkByte;
    }

    @NotNull
    public static ByteOrdering fromComparator(final @NotNull Comparator<Byte> comparator) {
        return new Serial(){
            private static final long serialVersionUID = 393576352771473074L;

            @Override
            @NotNull
            public Order checkByte(byte by, byte by2) {
                return Order.fromCompare(comparator.compare(by, by2));
            }

            @Override
            @NotNull
            public Comparator<Byte> asByteComparator() {
                return comparator;
            }
        };
    }

    public static interface Serial
    extends ByteOrdering,
    Serializable {
    }
}

