/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.converter;

import de.caff.annotation.NotNull;
import de.caff.generics.OrderedPair;
import de.caff.generics.function.Function1;
import java.util.Map;
import java.util.function.Function;

public class MapKeyValueConverter<KT, VT, KS, VS>
implements Function1<Map.Entry<KT, VT>, Map.Entry<KS, VS>> {
    @NotNull
    private final Function<KS, KT> keyConverter;
    @NotNull
    private final Function<VS, VT> valueConverter;

    public MapKeyValueConverter(@NotNull Function<KS, KT> function, @NotNull Function<VS, VT> function2) {
        this.keyConverter = function;
        this.valueConverter = function2;
    }

    @Override
    public Map.Entry<KT, VT> apply(Map.Entry<KS, VS> entry) {
        return OrderedPair.create(this.keyConverter.apply(entry.getKey()), this.valueConverter.apply(entry.getValue()));
    }
}

