/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.converter;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.FragileTypeConverter;
import de.caff.generics.TypeConverterException;
import de.caff.generics.function.Function1;

public class CarelessTypeConverter<T, S>
implements Function1<T, S> {
    @NotNull
    private final FragileTypeConverter<T, S> wrapped;
    private final T defaultValue;
    private TypeConverterException latestException;

    public CarelessTypeConverter(@NotNull FragileTypeConverter<T, S> fragileTypeConverter, @Nullable T t) {
        this.wrapped = fragileTypeConverter;
        this.defaultValue = t;
    }

    @Nullable
    public TypeConverterException getLatestException() {
        return this.latestException;
    }

    public void clear() {
        this.latestException = null;
    }

    @Override
    public T apply(S s) {
        try {
            return this.wrapped.convert(s);
        }
        catch (TypeConverterException typeConverterException) {
            this.latestException = typeConverterException;
            return this.defaultValue;
        }
    }
}

