/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.checker;

import de.caff.annotation.NotNull;
import de.caff.generics.function.Predicate1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;

public class OrChecker<T>
implements Predicate1<T> {
    private final Collection<Predicate<T>> checker;

    public OrChecker(@NotNull Predicate<? super T> predicate, @NotNull Predicate<? super T> predicate2) {
        this.checker = new ArrayList<Predicate<T>>(2);
        this.checker.add(predicate);
        this.checker.add(predicate2);
    }

    @SafeVarargs
    public OrChecker(@NotNull Predicate<? super T> predicate, @NotNull Predicate<? super T> predicate2, Predicate<? super T> ... predicateArray) {
        this.checker = new ArrayList<Predicate<T>>(2 + predicateArray.length);
        this.checker.add(predicate);
        this.checker.add(predicate2);
        for (Predicate<? super T> predicate3 : predicateArray) {
            this.checker.add(predicate3);
        }
    }

    public OrChecker(@NotNull Collection<? extends Predicate<T>> collection) {
        this.checker = new ArrayList<Predicate<T>>(collection);
    }

    @Override
    public boolean test(T t) {
        for (Predicate<T> predicate : this.checker) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }
}

