/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.checker;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.checker.AndChecker;
import de.caff.generics.checker.EqualsChecker;
import de.caff.generics.checker.GreaterEqualsChecker;
import de.caff.generics.checker.GreaterThanChecker;
import de.caff.generics.checker.LessEqualsChecker;
import de.caff.generics.checker.LessThanChecker;
import de.caff.generics.checker.NotEqualsChecker;
import de.caff.generics.checker.OrChecker;
import de.caff.generics.function.Predicate1;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Predicate;

public final class Check {
    private Check() {
    }

    @NotNull
    public static <T> Predicate1<T> isEqual(@NotNull T t) {
        return new EqualsChecker<T>(t);
    }

    @NotNull
    public static <T> Predicate1<T> notEquals(@NotNull T t) {
        return new NotEqualsChecker<T>(t);
    }

    @NotNull
    public static <T> Predicate1<T> refEquals(@Nullable T t) {
        return object2 -> t == object2;
    }

    @NotNull
    public static <T> Predicate1<T> notRefEquals(@Nullable T t) {
        return object2 -> t != object2;
    }

    @NotNull
    public static <T> Predicate1<T> and(@NotNull Predicate<? super T> predicate, @NotNull Predicate<? super T> predicate2) {
        return new AndChecker<T>(predicate, predicate2);
    }

    @SafeVarargs
    @NotNull
    public static <T> Predicate1<T> and(@NotNull Predicate<? super T> predicate, @NotNull Predicate<? super T> predicate2, Predicate<? super T> ... predicateArray) {
        return new AndChecker<T>(predicate, predicate2, predicateArray);
    }

    @NotNull
    public static <T> Predicate1<T> and(@NotNull Collection<? extends Predicate<T>> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("checkers must not be enpty!");
        }
        if (collection.size() == 1) {
            return Predicate1.from(collection.iterator().next());
        }
        return new AndChecker(collection);
    }

    @NotNull
    public static <T> Predicate1<T> or(@NotNull Predicate<? super T> predicate, @NotNull Predicate<? super T> predicate2) {
        return new OrChecker<T>(predicate, predicate2);
    }

    @SafeVarargs
    @NotNull
    public static <T> Predicate1<T> or(@NotNull Predicate<? super T> predicate, @NotNull Predicate<? super T> predicate2, Predicate<? super T> ... predicateArray) {
        return new OrChecker<T>(predicate, predicate2, predicateArray);
    }

    @NotNull
    public static <T> Predicate1<T> or(@NotNull Collection<? extends Predicate<T>> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("checkers must not be enpty!");
        }
        if (collection.size() == 1) {
            return Predicate1.from(collection.iterator().next());
        }
        return new OrChecker(collection);
    }

    @NotNull
    public static <T> Predicate1<T> xor(@NotNull Predicate<? super T> predicate, @NotNull Predicate<? super T> predicate2) {
        return object -> predicate.test(object) ^ predicate2.test(object);
    }

    @NotNull
    public static <T> Predicate1<T> not(@NotNull Predicate<T> predicate) {
        return object -> !predicate.test(object);
    }

    @NotNull
    public static <T> Predicate1<T> lessThan(@NotNull Comparable<T> comparable) {
        return object -> comparable.compareTo(object) > 0;
    }

    @NotNull
    public static <T> Predicate1<T> lessThan(@NotNull T t, @NotNull Comparator<T> comparator) {
        return new LessThanChecker<T>(t, comparator);
    }

    @NotNull
    public static <T> Predicate1<T> lessEquals(@NotNull Comparable<T> comparable) {
        return object -> comparable.compareTo(object) >= 0;
    }

    @NotNull
    public static <T> Predicate1<T> lessEquals(@NotNull T t, @NotNull Comparator<T> comparator) {
        return new LessEqualsChecker<T>(t, comparator);
    }

    @NotNull
    public static <T> Predicate1<T> greaterThan(@NotNull Comparable<T> comparable) {
        return object -> comparable.compareTo(object) < 0;
    }

    @NotNull
    public static <T> Predicate1<T> greaterThan(@NotNull T t, @NotNull Comparator<T> comparator) {
        return new GreaterThanChecker<T>(t, comparator);
    }

    @NotNull
    public static <T> Predicate1<T> greaterEquals(@NotNull Comparable<T> comparable) {
        return object -> comparable.compareTo(object) <= 0;
    }

    @NotNull
    public static <T> Predicate1<T> greaterEquals(@NotNull T t, @NotNull Comparator<T> comparator) {
        return new GreaterEqualsChecker<T>(t, comparator);
    }

    @NotNull
    public static <T> Predicate1<T> isType(@NotNull Class<?> clazz) {
        return clazz::isInstance;
    }

    @NotNull
    public static <T> Predicate1<T> isNotType(@NotNull Class<?> clazz) {
        return object -> !clazz.isInstance(object);
    }
}

