/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.algorithm;

import de.caff.annotation.NotNull;
import de.caff.generics.IntIndexable;
import de.caff.generics.MutableIntIndexable;
import de.caff.generics.Order;
import de.caff.generics.function.IntOrdering;

public class TimSortInt {
    private static final int MIN_MERGE = 16;
    private static final int MAX_MERGE_PENDING = 38;
    private static final int MIN_GALLOP = 7;
    private static final int INITIAL_MERGE_ARRAY_SIZE = 256;
    private static final int MIN_GALLOP_PENALTY = 1;
    @NotNull
    private final MutableIntIndexable elements;
    @NotNull
    private final IntOrdering order;
    private int minGallop = 7;
    @NotNull
    private int[] tmp;
    private int numSlices;
    private final int[] sliceBase;
    private final int[] sliceLength;

    private TimSortInt(@NotNull MutableIntIndexable mutableIntIndexable, @NotNull IntOrdering intOrdering) {
        this.elements = mutableIntIndexable;
        this.order = intOrdering;
        this.tmp = new int[256];
        this.sliceBase = new int[38];
        this.sliceLength = new int[38];
    }

    private void addSlice(int n, int n2) {
        this.sliceBase[this.numSlices] = n;
        this.sliceLength[this.numSlices] = n2;
        ++this.numSlices;
    }

    private void mergeCollapse() {
        while (this.numSlices > 1) {
            int n = this.numSlices - 2;
            if (n > 0 && this.sliceLength[n - 1] <= this.sliceLength[n] + this.sliceLength[n + 1]) {
                if (this.sliceLength[n - 1] < this.sliceLength[n + 1]) {
                    --n;
                }
            } else if (this.sliceLength[n] > this.sliceLength[n + 1]) {
                return;
            }
            this.mergeAt(n);
        }
    }

    private void mergeAt(int n) {
        assert (this.numSlices >= 2 && n >= 0 && (n == this.numSlices - 2 || n == this.numSlices - 3));
        int n2 = this.sliceBase[n];
        int n3 = this.sliceLength[n];
        int n4 = this.sliceBase[n + 1];
        int n5 = this.sliceLength[n + 1];
        assert (n3 > 0 && n5 > 0 && n2 + n3 == n4);
        this.sliceLength[n] = n3 + n5;
        if (n == this.numSlices - 3) {
            this.sliceBase[n + 1] = this.sliceBase[n + 2];
            this.sliceLength[n + 1] = this.sliceLength[n + 2];
        }
        --this.numSlices;
        int n6 = TimSortInt.gallopRight(this.elements.get(n4), this.elements.subSet(n2, n2 + n3), 0, this.order);
        assert (n6 >= 0);
        n2 += n6;
        if ((n3 -= n6) == 0) {
            return;
        }
        n5 = TimSortInt.gallopLeft(this.elements.get(n2 + n3 - 1), this.elements.subSet(n4, n4 + n5), n5 - 1, this.order);
        assert (n5 >= 0);
        if (n5 > 0) {
            if (n3 <= n5) {
                this.mergeLo(n2, n3, n4, n5);
            } else {
                this.mergeHi(n2, n3, n4, n5);
            }
        }
    }

    private int[] tmpArray(int n) {
        if (this.tmp.length < n) {
            int n2 = Math.max(Integer.highestOneBit(n) << 1, n);
            this.tmp = new int[n2];
        }
        return this.tmp;
    }

    private void mergeLo(int n, int n2, int n3, int n4) {
        assert (n2 > 0 && n4 > 0 && n + n2 == n3);
        MutableIntIndexable mutableIntIndexable = this.elements;
        int[] nArray = this.tmpArray(n2);
        int n5 = 0;
        int n6 = n3;
        int n7 = n;
        mutableIntIndexable.addToArray(nArray, n5, n, n2);
        mutableIntIndexable.set(n7++, mutableIntIndexable.get(n6++));
        if (--n4 == 0) {
            mutableIntIndexable.setFromArray(nArray, n5, n7, n2);
            return;
        }
        if (n2 == 1) {
            mutableIntIndexable.copyInternally(n6, n7, n4);
            mutableIntIndexable.set(n7 + n4, nArray[n5]);
            return;
        }
        IntOrdering intOrdering = this.order;
        int n8 = this.minGallop;
        block4: while (true) {
            int n9 = 0;
            int n10 = 0;
            do {
                assert (n2 > 1 && n4 > 0);
                if (intOrdering.checkInt(mutableIntIndexable.get(n6), nArray[n5]) == Order.Ascending) {
                    mutableIntIndexable.set(n7++, mutableIntIndexable.get(n6++));
                    ++n10;
                    n9 = 0;
                    if (--n4 != 0) continue;
                    break block4;
                }
                mutableIntIndexable.set(n7++, nArray[n5++]);
                ++n9;
                n10 = 0;
                if (--n2 == 1) break block4;
            } while (n9 < n8 || n10 < n8);
            do {
                assert (n2 > 1 && n4 > 0);
                n9 = TimSortInt.gallopRight(mutableIntIndexable.get(n6), IntIndexable.viewArray(nArray, n5, n2), 0, intOrdering);
                if (n9 != 0) {
                    mutableIntIndexable.setFromArray(nArray, n5, n7, n9);
                    n7 += n9;
                    n5 += n9;
                    if ((n2 -= n9) <= 1) break block4;
                }
                mutableIntIndexable.set(n7++, mutableIntIndexable.get(n6++));
                if (--n4 == 0) break block4;
                n10 = TimSortInt.gallopLeft(nArray[n5], mutableIntIndexable.subSet(n6, n4), 0, intOrdering);
                if (n10 != 0) {
                    mutableIntIndexable.copyInternally(n6, n7, n10);
                    n7 += n10;
                    n6 += n10;
                    if ((n4 -= n10) == 0) break block4;
                }
                mutableIntIndexable.set(n7++, nArray[n5++]);
                if (--n2 == 1) break block4;
                --n8;
            } while (n9 >= 7 | n10 >= 7);
            if (n8 < 0) {
                n8 = 0;
            }
            ++n8;
        }
        this.minGallop = Math.max(n8, 1);
        switch (n2) {
            case 0: {
                throw new IllegalArgumentException("Order violates contract!");
            }
            case 1: {
                assert (n4 > 0);
                mutableIntIndexable.copyInternally(n6, n7, n4);
                mutableIntIndexable.set(n7 + n4, nArray[n5]);
                break;
            }
            default: {
                assert (n4 == 0);
                mutableIntIndexable.setFromArray(nArray, n5, n7, n2);
            }
        }
    }

    private void mergeHi(int n, int n2, int n3, int n4) {
        assert (n2 > 0 && n4 > 0 && n + n2 == n3);
        MutableIntIndexable mutableIntIndexable = this.elements;
        int[] nArray = this.tmpArray(n4);
        mutableIntIndexable.addToArray(nArray, 0, n3, n4);
        int n5 = n + n2 - 1;
        int n6 = n4 - 1;
        int n7 = n3 + n4 - 1;
        mutableIntIndexable.set(n7--, mutableIntIndexable.get(n5--));
        if (--n2 == 0) {
            mutableIntIndexable.setFromArray(nArray, 0, n7 - (n4 - 1), n4);
            return;
        }
        if (n4 == 1) {
            mutableIntIndexable.copyInternally((n5 -= n2) + 1, (n7 -= n2) + 1, n2);
            mutableIntIndexable.set(n7, nArray[n6]);
            return;
        }
        IntOrdering intOrdering = this.order;
        int n8 = this.minGallop;
        block4: while (true) {
            int n9 = 0;
            int n10 = 0;
            do {
                assert (n2 > 0 && n4 > 1);
                if (intOrdering.checkInt(nArray[n6], mutableIntIndexable.get(n5)) == Order.Ascending) {
                    mutableIntIndexable.set(n7--, mutableIntIndexable.get(n5--));
                    ++n9;
                    n10 = 0;
                    if (--n2 != 0) continue;
                    break block4;
                }
                mutableIntIndexable.set(n7--, nArray[n6--]);
                ++n10;
                n9 = 0;
                if (--n4 == 1) break block4;
            } while (n9 < n8 || n10 < n8);
            do {
                assert (n2 > 0 && n4 > 1);
                n9 = n2 - TimSortInt.gallopRight(nArray[n6], mutableIntIndexable.subSet(n, n2), n2 - 1, intOrdering);
                if (n9 != 0) {
                    mutableIntIndexable.copyInternally((n5 -= n9) + 1, (n7 -= n9) + 1, n9);
                    if ((n2 -= n9) == 0) break block4;
                }
                mutableIntIndexable.set(n7--, nArray[n6--]);
                if (--n4 == 1) break block4;
                n10 = n4 - TimSortInt.gallopLeft(mutableIntIndexable.get(n5), IntIndexable.viewArray(nArray, 0, n4), n4 - 1, intOrdering);
                if (n10 != 0) {
                    mutableIntIndexable.setFromArray(nArray, (n6 -= n10) + 1, (n7 -= n10) + 1, n10);
                    if ((n4 -= n10) <= 1) break block4;
                }
                mutableIntIndexable.set(n7--, mutableIntIndexable.get(n5--));
                if (--n2 == 0) break block4;
                --n8;
            } while (n9 >= 7 | n10 >= 7);
            if (n8 < 0) {
                n8 = 0;
            }
            ++n8;
        }
        this.minGallop = Math.max(n8, 1);
        switch (n4) {
            case 0: {
                throw new IllegalArgumentException("Order is broken!");
            }
            case 1: {
                assert (n2 > 0);
                mutableIntIndexable.copyInternally((n5 -= n2) + 1, (n7 -= n2) + 1, n2);
                mutableIntIndexable.set(n7, nArray[n6]);
                break;
            }
            default: {
                assert (n2 == 0 && n4 > 0);
                mutableIntIndexable.setFromArray(nArray, 0, n7 - (n4 - 1), n4);
            }
        }
    }

    public static void sort(@NotNull int[] nArray, @NotNull IntOrdering intOrdering) {
        TimSortInt.sort(MutableIntIndexable.viewArray(nArray), intOrdering);
    }

    public static void sort(@NotNull int[] nArray, int n, int n2, @NotNull IntOrdering intOrdering) {
        TimSortInt.sort(MutableIntIndexable.viewArray(nArray, n, n2), intOrdering);
    }

    public static void sort(@NotNull MutableIntIndexable mutableIntIndexable) {
        TimSortInt.sort(mutableIntIndexable, IntOrdering.ASCENDING);
    }

    public static void sort(@NotNull MutableIntIndexable mutableIntIndexable, @NotNull IntOrdering intOrdering) {
        int n;
        int n2 = mutableIntIndexable.size();
        if (n2 < 2) {
            return;
        }
        TimSortInt timSortInt = new TimSortInt(mutableIntIndexable, intOrdering);
        int n3 = TimSortInt.mergeComputeMinrun(n2);
        int n4 = 0;
        int n5 = n2;
        do {
            if ((n = TimSortInt.countRun(mutableIntIndexable, n4, n5, intOrdering)) < n3) {
                int n6 = Math.min(n2, n3);
                TimSortInt.binarySort(mutableIntIndexable.subSet(n4, n4 + n6), n, intOrdering);
                n = n6;
            }
            timSortInt.addSlice(n4, n);
            timSortInt.mergeCollapse();
            n4 += n;
        } while ((n2 -= n) != 0);
        assert (n4 == n5);
        timSortInt.mergeForceCollapse();
        assert (timSortInt.numSlices == 1);
    }

    private void mergeForceCollapse() {
        while (this.numSlices > 1) {
            int n = this.numSlices - 2;
            if (n > 0 && this.sliceLength[n - 1] < this.sliceLength[n + 1]) {
                --n;
            }
            this.mergeAt(n);
        }
    }

    static int mergeComputeMinrun(int n) {
        int n2 = 0;
        assert (n >= 0);
        while (n >= 16) {
            n2 |= n & 1;
            n >>= 1;
        }
        return n + n2;
    }

    private static void binarySort(@NotNull MutableIntIndexable mutableIntIndexable, int n, @NotNull IntOrdering intOrdering) {
        int n2 = mutableIntIndexable.size();
        assert (0 <= n && n <= mutableIntIndexable.size());
        if (n == 0) {
            ++n;
        }
        while (n < n2) {
            int n3;
            int n4 = 0;
            int n5 = n;
            int n6 = mutableIntIndexable.get(n5);
            assert (n4 < n5);
            do {
                if (intOrdering.checkInt(n6, mutableIntIndexable.get(n3 = n4 + n5 >> 1)) == Order.Ascending) {
                    n5 = n3;
                    continue;
                }
                n4 = n3 + 1;
            } while (n4 < n5);
            assert (n4 == n5);
            for (n3 = n; n3 > n4; --n3) {
                mutableIntIndexable.set(n3, mutableIntIndexable.get(n3 - 1));
            }
            mutableIntIndexable.set(n4, n6);
            ++n;
        }
    }

    private static int countRun(@NotNull MutableIntIndexable mutableIntIndexable, int n, int n2, @NotNull IntOrdering intOrdering) {
        assert (n < n2);
        int n3 = n + 1;
        if (n3 == n2) {
            return 1;
        }
        if (intOrdering.checkInt(mutableIntIndexable.get(n), mutableIntIndexable.get(n3++)) == Order.Descending) {
            while (n3 < n2 && intOrdering.checkInt(mutableIntIndexable.get(n3), mutableIntIndexable.get(n3 - 1)) == Order.Ascending) {
                ++n3;
            }
            mutableIntIndexable.revert(n, n3 - 1);
        } else {
            while (n3 < n2 && intOrdering.checkInt(mutableIntIndexable.get(n3 - 1), mutableIntIndexable.get(n3)) != Order.Descending) {
                ++n3;
            }
        }
        return n3 - n;
    }

    private static int gallopLeft(int n, @NotNull IntIndexable intIndexable, int n2, @NotNull IntOrdering intOrdering) {
        int n3;
        int n4 = intIndexable.size();
        assert (n2 >= 0 && n2 < n4);
        int n5 = 0;
        int n6 = 1;
        if (intOrdering.checkInt(intIndexable.get(n2), n) == Order.Ascending) {
            n3 = n4 - n2;
            while (n6 < n3 && intOrdering.checkInt(intIndexable.get(n2 + n6), n) == Order.Ascending) {
                n5 = n6;
                if ((n6 = (n6 << 1) + 1) > 0) continue;
                n6 = n3;
            }
            if (n6 > n3) {
                n6 = n3;
            }
            n5 += n2;
            n6 += n2;
        } else {
            n3 = n2 + 1;
            while (n6 < n3 && intOrdering.checkInt(intIndexable.get(n2 - n6), n) != Order.Ascending) {
                n5 = n6;
                if ((n6 = (n6 << 1) + 1) > 0) continue;
                n6 = n3;
            }
            if (n6 > n3) {
                n6 = n3;
            }
            int n7 = n5;
            n5 = n2 - n6;
            n6 = n2 - n7;
        }
        assert (-1 <= n5 && n5 < n6 && n6 <= n4);
        ++n5;
        while (n5 < n6) {
            n3 = n5 + (n6 - n5 >>> 1);
            if (intOrdering.checkInt(intIndexable.get(n3), n) == Order.Ascending) {
                n5 = n3 + 1;
                continue;
            }
            n6 = n3;
        }
        assert (n5 == n6);
        return n6;
    }

    private static int gallopRight(int n, @NotNull IntIndexable intIndexable, int n2, @NotNull IntOrdering intOrdering) {
        int n3;
        int n4 = intIndexable.size();
        assert (n2 >= 0 && n2 < n4);
        int n5 = 0;
        int n6 = 1;
        if (intOrdering.checkInt(n, intIndexable.get(n2)) == Order.Ascending) {
            n3 = n2 + 1;
            while (n6 < n3 && intOrdering.checkInt(n, intIndexable.get(n2 - n6)) == Order.Ascending) {
                n5 = n6;
                if ((n6 = (n6 << 1) + 1) > 0) continue;
                n6 = n3;
            }
            if (n6 > n3) {
                n6 = n3;
            }
            int n7 = n5;
            n5 = n2 - n6;
            n6 = n2 - n7;
        } else {
            n3 = n4 - n2;
            while (n6 < n3 && intOrdering.checkInt(n, intIndexable.get(n2 + n6)) != Order.Ascending) {
                n5 = n6;
                if ((n6 = (n6 << 1) + 1) > 0) continue;
                n6 = n3;
            }
            if (n6 > n3) {
                n6 = n3;
            }
            n5 += n2;
            n6 += n2;
        }
        assert (-1 <= n5 && n5 < n6 && n6 <= n4);
        ++n5;
        while (n5 < n6) {
            n3 = n5 + (n6 - n5 >>> 1);
            if (intOrdering.checkInt(n, intIndexable.get(n3)) == Order.Ascending) {
                n6 = n3;
                continue;
            }
            n5 = n3 + 1;
        }
        assert (n5 == n6);
        return n6;
    }
}

