/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.algorithm;

import de.caff.annotation.NotNull;
import de.caff.generics.FloatIndexable;
import de.caff.generics.MutableFloatIndexable;
import de.caff.generics.Order;
import de.caff.generics.function.FloatOrdering;

public class TimSortFloat {
    private static final int MIN_MERGE = 16;
    private static final int MAX_MERGE_PENDING = 38;
    private static final int MIN_GALLOP = 7;
    private static final int INITIAL_MERGE_ARRAY_SIZE = 256;
    private static final int MIN_GALLOP_PENALTY = 1;
    @NotNull
    private final MutableFloatIndexable elements;
    @NotNull
    private final FloatOrdering order;
    private int minGallop = 7;
    @NotNull
    private float[] tmp;
    private int numSlices;
    private final int[] sliceBase;
    private final int[] sliceLength;

    private TimSortFloat(@NotNull MutableFloatIndexable mutableFloatIndexable, @NotNull FloatOrdering floatOrdering) {
        this.elements = mutableFloatIndexable;
        this.order = floatOrdering;
        this.tmp = new float[256];
        this.sliceBase = new int[38];
        this.sliceLength = new int[38];
    }

    private void addSlice(int n, int n2) {
        this.sliceBase[this.numSlices] = n;
        this.sliceLength[this.numSlices] = n2;
        ++this.numSlices;
    }

    private void mergeCollapse() {
        while (this.numSlices > 1) {
            int n = this.numSlices - 2;
            if (n > 0 && this.sliceLength[n - 1] <= this.sliceLength[n] + this.sliceLength[n + 1]) {
                if (this.sliceLength[n - 1] < this.sliceLength[n + 1]) {
                    --n;
                }
            } else if (this.sliceLength[n] > this.sliceLength[n + 1]) {
                return;
            }
            this.mergeAt(n);
        }
    }

    private void mergeAt(int n) {
        assert (this.numSlices >= 2 && n >= 0 && (n == this.numSlices - 2 || n == this.numSlices - 3));
        int n2 = this.sliceBase[n];
        int n3 = this.sliceLength[n];
        int n4 = this.sliceBase[n + 1];
        int n5 = this.sliceLength[n + 1];
        assert (n3 > 0 && n5 > 0 && n2 + n3 == n4);
        this.sliceLength[n] = n3 + n5;
        if (n == this.numSlices - 3) {
            this.sliceBase[n + 1] = this.sliceBase[n + 2];
            this.sliceLength[n + 1] = this.sliceLength[n + 2];
        }
        --this.numSlices;
        int n6 = TimSortFloat.gallopRight(this.elements.get(n4), this.elements.subSet(n2, n2 + n3), 0, this.order);
        assert (n6 >= 0);
        n2 += n6;
        if ((n3 -= n6) == 0) {
            return;
        }
        n5 = TimSortFloat.gallopLeft(this.elements.get(n2 + n3 - 1), this.elements.subSet(n4, n4 + n5), n5 - 1, this.order);
        assert (n5 >= 0);
        if (n5 > 0) {
            if (n3 <= n5) {
                this.mergeLo(n2, n3, n4, n5);
            } else {
                this.mergeHi(n2, n3, n4, n5);
            }
        }
    }

    private float[] tmpArray(int n) {
        if (this.tmp.length < n) {
            int n2 = Math.max(Integer.highestOneBit(n) << 1, n);
            this.tmp = new float[n2];
        }
        return this.tmp;
    }

    private void mergeLo(int n, int n2, int n3, int n4) {
        assert (n2 > 0 && n4 > 0 && n + n2 == n3);
        MutableFloatIndexable mutableFloatIndexable = this.elements;
        float[] fArray = this.tmpArray(n2);
        int n5 = 0;
        int n6 = n3;
        int n7 = n;
        mutableFloatIndexable.addToArray(fArray, n5, n, n2);
        mutableFloatIndexable.set(n7++, mutableFloatIndexable.get(n6++));
        if (--n4 == 0) {
            mutableFloatIndexable.setFromArray(fArray, n5, n7, n2);
            return;
        }
        if (n2 == 1) {
            mutableFloatIndexable.copyInternally(n6, n7, n4);
            mutableFloatIndexable.set(n7 + n4, fArray[n5]);
            return;
        }
        FloatOrdering floatOrdering = this.order;
        int n8 = this.minGallop;
        block4: while (true) {
            int n9 = 0;
            int n10 = 0;
            do {
                assert (n2 > 1 && n4 > 0);
                if (floatOrdering.checkFloat(mutableFloatIndexable.get(n6), fArray[n5]) == Order.Ascending) {
                    mutableFloatIndexable.set(n7++, mutableFloatIndexable.get(n6++));
                    ++n10;
                    n9 = 0;
                    if (--n4 != 0) continue;
                    break block4;
                }
                mutableFloatIndexable.set(n7++, fArray[n5++]);
                ++n9;
                n10 = 0;
                if (--n2 == 1) break block4;
            } while (n9 < n8 || n10 < n8);
            do {
                assert (n2 > 1 && n4 > 0);
                n9 = TimSortFloat.gallopRight(mutableFloatIndexable.get(n6), FloatIndexable.viewArray(fArray, n5, n2), 0, floatOrdering);
                if (n9 != 0) {
                    mutableFloatIndexable.setFromArray(fArray, n5, n7, n9);
                    n7 += n9;
                    n5 += n9;
                    if ((n2 -= n9) <= 1) break block4;
                }
                mutableFloatIndexable.set(n7++, mutableFloatIndexable.get(n6++));
                if (--n4 == 0) break block4;
                n10 = TimSortFloat.gallopLeft(fArray[n5], mutableFloatIndexable.subSet(n6, n4), 0, floatOrdering);
                if (n10 != 0) {
                    mutableFloatIndexable.copyInternally(n6, n7, n10);
                    n7 += n10;
                    n6 += n10;
                    if ((n4 -= n10) == 0) break block4;
                }
                mutableFloatIndexable.set(n7++, fArray[n5++]);
                if (--n2 == 1) break block4;
                --n8;
            } while (n9 >= 7 | n10 >= 7);
            if (n8 < 0) {
                n8 = 0;
            }
            ++n8;
        }
        this.minGallop = Math.max(n8, 1);
        switch (n2) {
            case 0: {
                throw new IllegalArgumentException("Order violates contract!");
            }
            case 1: {
                assert (n4 > 0);
                mutableFloatIndexable.copyInternally(n6, n7, n4);
                mutableFloatIndexable.set(n7 + n4, fArray[n5]);
                break;
            }
            default: {
                assert (n4 == 0);
                mutableFloatIndexable.setFromArray(fArray, n5, n7, n2);
            }
        }
    }

    private void mergeHi(int n, int n2, int n3, int n4) {
        assert (n2 > 0 && n4 > 0 && n + n2 == n3);
        MutableFloatIndexable mutableFloatIndexable = this.elements;
        float[] fArray = this.tmpArray(n4);
        mutableFloatIndexable.addToArray(fArray, 0, n3, n4);
        int n5 = n + n2 - 1;
        int n6 = n4 - 1;
        int n7 = n3 + n4 - 1;
        mutableFloatIndexable.set(n7--, mutableFloatIndexable.get(n5--));
        if (--n2 == 0) {
            mutableFloatIndexable.setFromArray(fArray, 0, n7 - (n4 - 1), n4);
            return;
        }
        if (n4 == 1) {
            mutableFloatIndexable.copyInternally((n5 -= n2) + 1, (n7 -= n2) + 1, n2);
            mutableFloatIndexable.set(n7, fArray[n6]);
            return;
        }
        FloatOrdering floatOrdering = this.order;
        int n8 = this.minGallop;
        block4: while (true) {
            int n9 = 0;
            int n10 = 0;
            do {
                assert (n2 > 0 && n4 > 1);
                if (floatOrdering.checkFloat(fArray[n6], mutableFloatIndexable.get(n5)) == Order.Ascending) {
                    mutableFloatIndexable.set(n7--, mutableFloatIndexable.get(n5--));
                    ++n9;
                    n10 = 0;
                    if (--n2 != 0) continue;
                    break block4;
                }
                mutableFloatIndexable.set(n7--, fArray[n6--]);
                ++n10;
                n9 = 0;
                if (--n4 == 1) break block4;
            } while (n9 < n8 || n10 < n8);
            do {
                assert (n2 > 0 && n4 > 1);
                n9 = n2 - TimSortFloat.gallopRight(fArray[n6], mutableFloatIndexable.subSet(n, n2), n2 - 1, floatOrdering);
                if (n9 != 0) {
                    mutableFloatIndexable.copyInternally((n5 -= n9) + 1, (n7 -= n9) + 1, n9);
                    if ((n2 -= n9) == 0) break block4;
                }
                mutableFloatIndexable.set(n7--, fArray[n6--]);
                if (--n4 == 1) break block4;
                n10 = n4 - TimSortFloat.gallopLeft(mutableFloatIndexable.get(n5), FloatIndexable.viewArray(fArray, 0, n4), n4 - 1, floatOrdering);
                if (n10 != 0) {
                    mutableFloatIndexable.setFromArray(fArray, (n6 -= n10) + 1, (n7 -= n10) + 1, n10);
                    if ((n4 -= n10) <= 1) break block4;
                }
                mutableFloatIndexable.set(n7--, mutableFloatIndexable.get(n5--));
                if (--n2 == 0) break block4;
                --n8;
            } while (n9 >= 7 | n10 >= 7);
            if (n8 < 0) {
                n8 = 0;
            }
            ++n8;
        }
        this.minGallop = Math.max(n8, 1);
        switch (n4) {
            case 0: {
                throw new IllegalArgumentException("Order is broken!");
            }
            case 1: {
                assert (n2 > 0);
                mutableFloatIndexable.copyInternally((n5 -= n2) + 1, (n7 -= n2) + 1, n2);
                mutableFloatIndexable.set(n7, fArray[n6]);
                break;
            }
            default: {
                assert (n2 == 0 && n4 > 0);
                mutableFloatIndexable.setFromArray(fArray, 0, n7 - (n4 - 1), n4);
            }
        }
    }

    public static void sort(@NotNull float[] fArray, @NotNull FloatOrdering floatOrdering) {
        TimSortFloat.sort(MutableFloatIndexable.viewArray(fArray), floatOrdering);
    }

    public static void sort(@NotNull float[] fArray, int n, int n2, @NotNull FloatOrdering floatOrdering) {
        TimSortFloat.sort(MutableFloatIndexable.viewArray(fArray, n, n2), floatOrdering);
    }

    public static void sort(@NotNull MutableFloatIndexable mutableFloatIndexable) {
        TimSortFloat.sort(mutableFloatIndexable, FloatOrdering.NATURAL_ASCENDING);
    }

    public static void sort(@NotNull MutableFloatIndexable mutableFloatIndexable, @NotNull FloatOrdering floatOrdering) {
        int n;
        int n2 = mutableFloatIndexable.size();
        if (n2 < 2) {
            return;
        }
        TimSortFloat timSortFloat = new TimSortFloat(mutableFloatIndexable, floatOrdering);
        int n3 = TimSortFloat.mergeComputeMinrun(n2);
        int n4 = 0;
        int n5 = n2;
        do {
            if ((n = TimSortFloat.countRun(mutableFloatIndexable, n4, n5, floatOrdering)) < n3) {
                int n6 = Math.min(n2, n3);
                TimSortFloat.binarySort(mutableFloatIndexable.subSet(n4, n4 + n6), n, floatOrdering);
                n = n6;
            }
            timSortFloat.addSlice(n4, n);
            timSortFloat.mergeCollapse();
            n4 += n;
        } while ((n2 -= n) != 0);
        assert (n4 == n5);
        timSortFloat.mergeForceCollapse();
        assert (timSortFloat.numSlices == 1);
    }

    private void mergeForceCollapse() {
        while (this.numSlices > 1) {
            int n = this.numSlices - 2;
            if (n > 0 && this.sliceLength[n - 1] < this.sliceLength[n + 1]) {
                --n;
            }
            this.mergeAt(n);
        }
    }

    static int mergeComputeMinrun(int n) {
        int n2 = 0;
        assert (n >= 0);
        while (n >= 16) {
            n2 |= n & 1;
            n >>= 1;
        }
        return n + n2;
    }

    private static void binarySort(@NotNull MutableFloatIndexable mutableFloatIndexable, int n, @NotNull FloatOrdering floatOrdering) {
        int n2 = mutableFloatIndexable.size();
        assert (0 <= n && n <= mutableFloatIndexable.size());
        if (n == 0) {
            ++n;
        }
        while (n < n2) {
            int n3;
            int n4 = 0;
            int n5 = n;
            float f = mutableFloatIndexable.get(n5);
            assert (n4 < n5);
            do {
                if (floatOrdering.checkFloat(f, mutableFloatIndexable.get(n3 = n4 + n5 >> 1)) == Order.Ascending) {
                    n5 = n3;
                    continue;
                }
                n4 = n3 + 1;
            } while (n4 < n5);
            assert (n4 == n5);
            for (n3 = n; n3 > n4; --n3) {
                mutableFloatIndexable.set(n3, mutableFloatIndexable.get(n3 - 1));
            }
            mutableFloatIndexable.set(n4, f);
            ++n;
        }
    }

    private static int countRun(@NotNull MutableFloatIndexable mutableFloatIndexable, int n, int n2, @NotNull FloatOrdering floatOrdering) {
        assert (n < n2);
        int n3 = n + 1;
        if (n3 == n2) {
            return 1;
        }
        if (floatOrdering.checkFloat(mutableFloatIndexable.get(n), mutableFloatIndexable.get(n3++)) == Order.Descending) {
            while (n3 < n2 && floatOrdering.checkFloat(mutableFloatIndexable.get(n3), mutableFloatIndexable.get(n3 - 1)) == Order.Ascending) {
                ++n3;
            }
            mutableFloatIndexable.revert(n, n3 - 1);
        } else {
            while (n3 < n2 && floatOrdering.checkFloat(mutableFloatIndexable.get(n3 - 1), mutableFloatIndexable.get(n3)) != Order.Descending) {
                ++n3;
            }
        }
        return n3 - n;
    }

    private static int gallopLeft(float f, @NotNull FloatIndexable floatIndexable, int n, @NotNull FloatOrdering floatOrdering) {
        int n2;
        int n3 = floatIndexable.size();
        assert (n >= 0 && n < n3);
        int n4 = 0;
        int n5 = 1;
        if (floatOrdering.checkFloat(floatIndexable.get(n), f) == Order.Ascending) {
            n2 = n3 - n;
            while (n5 < n2 && floatOrdering.checkFloat(floatIndexable.get(n + n5), f) == Order.Ascending) {
                n4 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n2;
            }
            if (n5 > n2) {
                n5 = n2;
            }
            n4 += n;
            n5 += n;
        } else {
            n2 = n + 1;
            while (n5 < n2 && floatOrdering.checkFloat(floatIndexable.get(n - n5), f) != Order.Ascending) {
                n4 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n2;
            }
            if (n5 > n2) {
                n5 = n2;
            }
            int n6 = n4;
            n4 = n - n5;
            n5 = n - n6;
        }
        assert (-1 <= n4 && n4 < n5 && n5 <= n3);
        ++n4;
        while (n4 < n5) {
            n2 = n4 + (n5 - n4 >>> 1);
            if (floatOrdering.checkFloat(floatIndexable.get(n2), f) == Order.Ascending) {
                n4 = n2 + 1;
                continue;
            }
            n5 = n2;
        }
        assert (n4 == n5);
        return n5;
    }

    private static int gallopRight(float f, @NotNull FloatIndexable floatIndexable, int n, @NotNull FloatOrdering floatOrdering) {
        int n2;
        int n3 = floatIndexable.size();
        assert (n >= 0 && n < n3);
        int n4 = 0;
        int n5 = 1;
        if (floatOrdering.checkFloat(f, floatIndexable.get(n)) == Order.Ascending) {
            n2 = n + 1;
            while (n5 < n2 && floatOrdering.checkFloat(f, floatIndexable.get(n - n5)) == Order.Ascending) {
                n4 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n2;
            }
            if (n5 > n2) {
                n5 = n2;
            }
            int n6 = n4;
            n4 = n - n5;
            n5 = n - n6;
        } else {
            n2 = n3 - n;
            while (n5 < n2 && floatOrdering.checkFloat(f, floatIndexable.get(n + n5)) != Order.Ascending) {
                n4 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n2;
            }
            if (n5 > n2) {
                n5 = n2;
            }
            n4 += n;
            n5 += n;
        }
        assert (-1 <= n4 && n4 < n5 && n5 <= n3);
        ++n4;
        while (n4 < n5) {
            n2 = n4 + (n5 - n4 >>> 1);
            if (floatOrdering.checkFloat(f, floatIndexable.get(n2)) == Order.Ascending) {
                n5 = n2;
                continue;
            }
            n4 = n2 + 1;
        }
        assert (n4 == n5);
        return n5;
    }
}

