/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.algorithm;

import de.caff.annotation.NotNull;
import de.caff.generics.Indexable;
import de.caff.generics.MutableIndexable;
import de.caff.generics.Order;
import de.caff.generics.function.Ordering;

public class TimSort<T> {
    private static final int MIN_MERGE = 16;
    private static final int MAX_MERGE_PENDING = 38;
    private static final int MIN_GALLOP = 7;
    private static final int INITIAL_MERGE_ARRAY_SIZE = 256;
    private static final int MIN_GALLOP_PENALTY = 1;
    @NotNull
    private final MutableIndexable<T> elements;
    @NotNull
    private final Ordering<? super T> order;
    private int minGallop = 7;
    @NotNull
    private Object[] tmp;
    private int numSlices;
    private final int[] sliceBase;
    private final int[] sliceLength;

    private TimSort(@NotNull MutableIndexable<T> mutableIndexable, @NotNull Ordering<? super T> ordering) {
        this.elements = mutableIndexable;
        this.order = ordering;
        this.tmp = new Object[256];
        this.sliceBase = new int[38];
        this.sliceLength = new int[38];
    }

    private void addSlice(int n, int n2) {
        this.sliceBase[this.numSlices] = n;
        this.sliceLength[this.numSlices] = n2;
        ++this.numSlices;
    }

    private void mergeCollapse() {
        while (this.numSlices > 1) {
            int n = this.numSlices - 2;
            if (n > 0 && this.sliceLength[n - 1] <= this.sliceLength[n] + this.sliceLength[n + 1]) {
                if (this.sliceLength[n - 1] < this.sliceLength[n + 1]) {
                    --n;
                }
            } else if (this.sliceLength[n] > this.sliceLength[n + 1]) {
                return;
            }
            this.mergeAt(n);
        }
    }

    private void mergeAt(int n) {
        assert (this.numSlices >= 2 && n >= 0 && (n == this.numSlices - 2 || n == this.numSlices - 3));
        int n2 = this.sliceBase[n];
        int n3 = this.sliceLength[n];
        int n4 = this.sliceBase[n + 1];
        int n5 = this.sliceLength[n + 1];
        assert (n3 > 0 && n5 > 0 && n2 + n3 == n4);
        this.sliceLength[n] = n3 + n5;
        if (n == this.numSlices - 3) {
            this.sliceBase[n + 1] = this.sliceBase[n + 2];
            this.sliceLength[n + 1] = this.sliceLength[n + 2];
        }
        --this.numSlices;
        int n6 = TimSort.gallopRight(this.elements.get(n4), this.elements.subSet(n2, n2 + n3), 0, this.order);
        assert (n6 >= 0);
        n2 += n6;
        if ((n3 -= n6) == 0) {
            return;
        }
        n5 = TimSort.gallopLeft(this.elements.get(n2 + n3 - 1), this.elements.subSet(n4, n4 + n5), n5 - 1, this.order);
        assert (n5 >= 0);
        if (n5 > 0) {
            if (n3 <= n5) {
                this.mergeLo(n2, n3, n4, n5);
            } else {
                this.mergeHi(n2, n3, n4, n5);
            }
        }
    }

    private T[] tmpArray(int n) {
        if (this.tmp.length < n) {
            int n2 = Math.max(Integer.highestOneBit(n) << 1, n);
            this.tmp = new Object[n2];
        }
        return this.tmp;
    }

    private void mergeLo(int n, int n2, int n3, int n4) {
        assert (n2 > 0 && n4 > 0 && n + n2 == n3);
        MutableIndexable<T> mutableIndexable = this.elements;
        T[] TArray = this.tmpArray(n2);
        int n5 = 0;
        int n6 = n3;
        int n7 = n;
        mutableIndexable.addToArray(TArray, n5, n, n2);
        mutableIndexable.set(n7++, mutableIndexable.get(n6++));
        if (--n4 == 0) {
            mutableIndexable.setFromArray(TArray, n5, n7, n2);
            return;
        }
        if (n2 == 1) {
            mutableIndexable.copyInternally(n6, n7, n4);
            mutableIndexable.set(n7 + n4, TArray[n5]);
            return;
        }
        Ordering ordering = this.order;
        int n8 = this.minGallop;
        block4: while (true) {
            int n9 = 0;
            int n10 = 0;
            do {
                assert (n2 > 1 && n4 > 0);
                if (ordering.check(mutableIndexable.get(n6), TArray[n5]) == Order.Ascending) {
                    mutableIndexable.set(n7++, mutableIndexable.get(n6++));
                    ++n10;
                    n9 = 0;
                    if (--n4 != 0) continue;
                    break block4;
                }
                mutableIndexable.set(n7++, TArray[n5++]);
                ++n9;
                n10 = 0;
                if (--n2 == 1) break block4;
            } while (n9 < n8 || n10 < n8);
            do {
                assert (n2 > 1 && n4 > 0);
                n9 = TimSort.gallopRight(mutableIndexable.get(n6), Indexable.viewArray(TArray, n5, n2), 0, ordering);
                if (n9 != 0) {
                    mutableIndexable.setFromArray(TArray, n5, n7, n9);
                    n7 += n9;
                    n5 += n9;
                    if ((n2 -= n9) <= 1) break block4;
                }
                mutableIndexable.set(n7++, mutableIndexable.get(n6++));
                if (--n4 == 0) break block4;
                n10 = TimSort.gallopLeft(TArray[n5], mutableIndexable.subSet(n6, n4), 0, ordering);
                if (n10 != 0) {
                    mutableIndexable.copyInternally(n6, n7, n10);
                    n7 += n10;
                    n6 += n10;
                    if ((n4 -= n10) == 0) break block4;
                }
                mutableIndexable.set(n7++, TArray[n5++]);
                if (--n2 == 1) break block4;
                --n8;
            } while (n9 >= 7 | n10 >= 7);
            if (n8 < 0) {
                n8 = 0;
            }
            ++n8;
        }
        this.minGallop = Math.max(n8, 1);
        switch (n2) {
            case 0: {
                throw new IllegalArgumentException("Order violates contract!");
            }
            case 1: {
                assert (n4 > 0);
                mutableIndexable.copyInternally(n6, n7, n4);
                mutableIndexable.set(n7 + n4, TArray[n5]);
                break;
            }
            default: {
                assert (n4 == 0);
                mutableIndexable.setFromArray(TArray, n5, n7, n2);
            }
        }
    }

    private void mergeHi(int n, int n2, int n3, int n4) {
        assert (n2 > 0 && n4 > 0 && n + n2 == n3);
        MutableIndexable<T> mutableIndexable = this.elements;
        T[] TArray = this.tmpArray(n4);
        mutableIndexable.addToArray(TArray, 0, n3, n4);
        int n5 = n + n2 - 1;
        int n6 = n4 - 1;
        int n7 = n3 + n4 - 1;
        mutableIndexable.set(n7--, mutableIndexable.get(n5--));
        if (--n2 == 0) {
            mutableIndexable.setFromArray(TArray, 0, n7 - (n4 - 1), n4);
            return;
        }
        if (n4 == 1) {
            mutableIndexable.copyInternally((n5 -= n2) + 1, (n7 -= n2) + 1, n2);
            mutableIndexable.set(n7, TArray[n6]);
            return;
        }
        Ordering<T> ordering = this.order;
        int n8 = this.minGallop;
        block4: while (true) {
            int n9 = 0;
            int n10 = 0;
            do {
                assert (n2 > 0 && n4 > 1);
                if (ordering.check(TArray[n6], mutableIndexable.get(n5)) == Order.Ascending) {
                    mutableIndexable.set(n7--, mutableIndexable.get(n5--));
                    ++n9;
                    n10 = 0;
                    if (--n2 != 0) continue;
                    break block4;
                }
                mutableIndexable.set(n7--, TArray[n6--]);
                ++n10;
                n9 = 0;
                if (--n4 == 1) break block4;
            } while (n9 < n8 || n10 < n8);
            do {
                assert (n2 > 0 && n4 > 1);
                n9 = n2 - TimSort.gallopRight(TArray[n6], mutableIndexable.subSet(n, n2), n2 - 1, ordering);
                if (n9 != 0) {
                    mutableIndexable.copyInternally((n5 -= n9) + 1, (n7 -= n9) + 1, n9);
                    if ((n2 -= n9) == 0) break block4;
                }
                mutableIndexable.set(n7--, TArray[n6--]);
                if (--n4 == 1) break block4;
                n10 = n4 - TimSort.gallopLeft(mutableIndexable.get(n5), Indexable.viewArray(TArray, 0, n4), n4 - 1, ordering);
                if (n10 != 0) {
                    mutableIndexable.setFromArray(TArray, (n6 -= n10) + 1, (n7 -= n10) + 1, n10);
                    if ((n4 -= n10) <= 1) break block4;
                }
                mutableIndexable.set(n7--, mutableIndexable.get(n5--));
                if (--n2 == 0) break block4;
                --n8;
            } while (n9 >= 7 | n10 >= 7);
            if (n8 < 0) {
                n8 = 0;
            }
            ++n8;
        }
        this.minGallop = Math.max(n8, 1);
        switch (n4) {
            case 0: {
                throw new IllegalArgumentException("Order is broken!");
            }
            case 1: {
                assert (n2 > 0);
                mutableIndexable.copyInternally((n5 -= n2) + 1, (n7 -= n2) + 1, n2);
                mutableIndexable.set(n7, TArray[n6]);
                break;
            }
            default: {
                assert (n2 == 0 && n4 > 0);
                mutableIndexable.setFromArray(TArray, 0, n7 - (n4 - 1), n4);
            }
        }
    }

    public static <E extends Comparable<? super E>> void sort(@NotNull MutableIndexable<E> mutableIndexable) {
        TimSort.sort(mutableIndexable, Ordering.natural());
    }

    public static <E> void sort(@NotNull MutableIndexable<E> mutableIndexable, @NotNull Ordering<? super E> ordering) {
        int n;
        int n2 = mutableIndexable.size();
        if (n2 < 2) {
            return;
        }
        TimSort<? super E> timSort = new TimSort<E>(mutableIndexable, ordering);
        int n3 = TimSort.mergeComputeMinrun(n2);
        int n4 = 0;
        int n5 = n2;
        do {
            if ((n = TimSort.countRun(mutableIndexable, n4, n5, ordering)) < n3) {
                int n6 = Math.min(n2, n3);
                TimSort.binarySort(mutableIndexable.subSet(n4, n4 + n6), n, ordering);
                n = n6;
            }
            super.addSlice(n4, n);
            super.mergeCollapse();
            n4 += n;
        } while ((n2 -= n) != 0);
        assert (n4 == n5);
        super.mergeForceCollapse();
        assert (timSort.numSlices == 1);
    }

    private void mergeForceCollapse() {
        while (this.numSlices > 1) {
            int n = this.numSlices - 2;
            if (n > 0 && this.sliceLength[n - 1] < this.sliceLength[n + 1]) {
                --n;
            }
            this.mergeAt(n);
        }
    }

    static int mergeComputeMinrun(int n) {
        int n2 = 0;
        assert (n >= 0);
        while (n >= 16) {
            n2 |= n & 1;
            n >>= 1;
        }
        return n + n2;
    }

    private static <E> void binarySort(@NotNull MutableIndexable<E> mutableIndexable, int n, @NotNull Ordering<? super E> ordering) {
        int n2 = mutableIndexable.size();
        assert (0 <= n && n <= mutableIndexable.size());
        if (n == 0) {
            ++n;
        }
        while (n < n2) {
            int n3;
            int n4 = 0;
            int n5 = n;
            Object t = mutableIndexable.get(n5);
            assert (n4 < n5);
            do {
                if (ordering.check(t, mutableIndexable.get(n3 = n4 + n5 >> 1)) == Order.Ascending) {
                    n5 = n3;
                    continue;
                }
                n4 = n3 + 1;
            } while (n4 < n5);
            assert (n4 == n5);
            for (n3 = n; n3 > n4; --n3) {
                mutableIndexable.set(n3, mutableIndexable.get(n3 - 1));
            }
            mutableIndexable.set(n4, t);
            ++n;
        }
    }

    private static <E> int countRun(@NotNull MutableIndexable<E> mutableIndexable, int n, int n2, @NotNull Ordering<? super E> ordering) {
        assert (n < n2);
        int n3 = n + 1;
        if (n3 == n2) {
            return 1;
        }
        if (ordering.check(mutableIndexable.get(n), mutableIndexable.get(n3++)) == Order.Descending) {
            while (n3 < n2 && ordering.check(mutableIndexable.get(n3), mutableIndexable.get(n3 - 1)) == Order.Ascending) {
                ++n3;
            }
            mutableIndexable.revert(n, n3 - 1);
        } else {
            while (n3 < n2 && ordering.check(mutableIndexable.get(n3 - 1), mutableIndexable.get(n3)) != Order.Descending) {
                ++n3;
            }
        }
        return n3 - n;
    }

    private static <E> int gallopLeft(E e, @NotNull Indexable<E> indexable, int n, @NotNull Ordering<? super E> ordering) {
        int n2;
        int n3 = indexable.size();
        assert (n >= 0 && n < n3);
        int n4 = 0;
        int n5 = 1;
        if (ordering.check(indexable.get(n), e) == Order.Ascending) {
            n2 = n3 - n;
            while (n5 < n2 && ordering.check(indexable.get(n + n5), e) == Order.Ascending) {
                n4 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n2;
            }
            if (n5 > n2) {
                n5 = n2;
            }
            n4 += n;
            n5 += n;
        } else {
            n2 = n + 1;
            while (n5 < n2 && ordering.check(indexable.get(n - n5), e) != Order.Ascending) {
                n4 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n2;
            }
            if (n5 > n2) {
                n5 = n2;
            }
            int n6 = n4;
            n4 = n - n5;
            n5 = n - n6;
        }
        assert (-1 <= n4 && n4 < n5 && n5 <= n3);
        ++n4;
        while (n4 < n5) {
            n2 = n4 + (n5 - n4 >>> 1);
            if (ordering.check(indexable.get(n2), e) == Order.Ascending) {
                n4 = n2 + 1;
                continue;
            }
            n5 = n2;
        }
        assert (n4 == n5);
        return n5;
    }

    private static <E> int gallopRight(E e, @NotNull Indexable<E> indexable, int n, @NotNull Ordering<? super E> ordering) {
        int n2;
        int n3 = indexable.size();
        assert (n >= 0 && n < n3);
        int n4 = 0;
        int n5 = 1;
        if (ordering.check(e, indexable.get(n)) == Order.Ascending) {
            n2 = n + 1;
            while (n5 < n2 && ordering.check(e, indexable.get(n - n5)) == Order.Ascending) {
                n4 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n2;
            }
            if (n5 > n2) {
                n5 = n2;
            }
            int n6 = n4;
            n4 = n - n5;
            n5 = n - n6;
        } else {
            n2 = n3 - n;
            while (n5 < n2 && ordering.check(e, indexable.get(n + n5)) != Order.Ascending) {
                n4 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n2;
            }
            if (n5 > n2) {
                n5 = n2;
            }
            n4 += n;
            n5 += n;
        }
        assert (-1 <= n4 && n4 < n5 && n5 <= n3);
        ++n4;
        while (n4 < n5) {
            n2 = n4 + (n5 - n4 >>> 1);
            if (ordering.check(e, indexable.get(n2)) == Order.Ascending) {
                n5 = n2;
                continue;
            }
            n4 = n2 + 1;
        }
        assert (n4 == n5);
        return n5;
    }
}

