/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.algorithm;

import de.caff.annotation.NotNull;
import de.caff.generics.MutableCharIndexable;
import de.caff.generics.Order;
import de.caff.generics.function.CharOrdering;
import java.util.Arrays;

public class FastSortChar {
    private static final int COUNT_SORT_BOUNDARY = 333;
    public static final int NUM_CHARS = 65536;

    public static void sort(@NotNull byte[] byArray) {
        Arrays.sort(byArray);
    }

    public static void sort(@NotNull char[] cArray, @NotNull CharOrdering charOrdering) {
        FastSortChar.sort(MutableCharIndexable.viewArray(cArray), charOrdering);
    }

    public static void sort(@NotNull char[] cArray, int n, int n2) {
        Arrays.sort(cArray, n, n2);
    }

    public static void sort(@NotNull char[] cArray, int n, int n2, @NotNull CharOrdering charOrdering) {
        FastSortChar.sort(MutableCharIndexable.viewArray(cArray, n, n2), charOrdering);
    }

    public static void sort(@NotNull MutableCharIndexable mutableCharIndexable) {
        FastSortChar.sort(mutableCharIndexable, CharOrdering.ASCENDING);
    }

    public static void sort(@NotNull MutableCharIndexable mutableCharIndexable, @NotNull CharOrdering charOrdering) {
        int n;
        int n2;
        int n3 = mutableCharIndexable.size();
        if (n3 < 333) {
            FastSortChar.quickSort(mutableCharIndexable, charOrdering);
            return;
        }
        int[] nArray = new int[65536];
        mutableCharIndexable.forEachChar(c -> {
            char c2 = c;
            nArray[c2] = nArray[c2] + 1;
        });
        char[] cArray = new char[Math.min(65536, n3)];
        int n4 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n <= 0) continue;
            cArray[n4++] = (char)n2;
        }
        if (n4 == n3) {
            FastSortChar.quickSort(mutableCharIndexable, charOrdering);
            return;
        }
        FastSortChar.quickSort(MutableCharIndexable.viewArray(cArray, 0, n4), charOrdering);
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            char c2 = cArray[n];
            int n5 = nArray[c2];
            assert (n5 > 0);
            mutableCharIndexable.setRange(n2, n5, c2);
            n2 += n5;
        }
    }

    private static void quickSort(@NotNull MutableCharIndexable mutableCharIndexable, @NotNull CharOrdering charOrdering) {
        int n = mutableCharIndexable.size();
        if (n <= 1) {
            return;
        }
        if (n == 2) {
            if (charOrdering.checkChar(mutableCharIndexable.get(0), mutableCharIndexable.get(1)) == Order.Descending) {
                mutableCharIndexable.swap(0, 1);
            }
            return;
        }
        int n2 = FastSortChar.partition(mutableCharIndexable, charOrdering);
        FastSortChar.quickSort(mutableCharIndexable.headSet(n2), charOrdering);
        FastSortChar.quickSort(mutableCharIndexable.tailSet(n2 + 1), charOrdering);
    }

    private static int partition(@NotNull MutableCharIndexable mutableCharIndexable, @NotNull CharOrdering charOrdering) {
        int n = mutableCharIndexable.size() - 1;
        char c = mutableCharIndexable.get(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (charOrdering.checkChar(mutableCharIndexable.get(i), c) != Order.Ascending) continue;
            mutableCharIndexable.swap(n2++, i);
        }
        mutableCharIndexable.swyp(n2, -1);
        return n2;
    }
}

