/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.algorithm;

import de.caff.annotation.NotNull;
import de.caff.generics.MutableByteIndexable;
import de.caff.generics.Order;
import de.caff.generics.function.ByteOrdering;
import java.util.Arrays;

class FastSortByte {
    private static final int NUM_BYTES = 256;
    private static final int OFFSET = 128;
    private static final int COUNT_SORT_BOUNDARY = 33;

    FastSortByte() {
    }

    public static void sort(@NotNull byte[] byArray) {
        Arrays.sort(byArray);
    }

    public static void sort(@NotNull byte[] byArray, @NotNull ByteOrdering byteOrdering) {
        FastSortByte.sort(MutableByteIndexable.viewArray(byArray), byteOrdering);
    }

    public static void sort(@NotNull byte[] byArray, int n, int n2) {
        Arrays.sort(byArray, n, n2);
    }

    public static void sort(@NotNull byte[] byArray, int n, int n2, @NotNull ByteOrdering byteOrdering) {
        FastSortByte.sort(MutableByteIndexable.viewArray(byArray, n, n2), byteOrdering);
    }

    public static void sort(@NotNull MutableByteIndexable mutableByteIndexable) {
        FastSortByte.sort(mutableByteIndexable, ByteOrdering.ASCENDING);
    }

    public static void sort(@NotNull MutableByteIndexable mutableByteIndexable, @NotNull ByteOrdering byteOrdering) {
        int n;
        int n2;
        int n3 = mutableByteIndexable.size();
        if (n3 < 33) {
            FastSortByte.quickSort(mutableByteIndexable, byteOrdering);
            return;
        }
        int[] nArray = new int[256];
        mutableByteIndexable.forEachByte(by -> {
            int n = by + 128;
            nArray[n] = nArray[n] + 1;
        });
        byte[] byArray = new byte[Math.min(256, n3)];
        int n4 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n <= 0) continue;
            byArray[n4++] = (byte)(n2 - 128);
        }
        if (n4 == n3) {
            FastSortByte.quickSort(mutableByteIndexable, byteOrdering);
            return;
        }
        FastSortByte.quickSort(MutableByteIndexable.viewArray(byArray, 0, n4), byteOrdering);
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            byte by2 = byArray[n];
            int n5 = nArray[by2 + 128];
            assert (n5 > 0);
            mutableByteIndexable.setRange(n2, n5, by2);
            n2 += n5;
        }
    }

    static void quickSort(@NotNull MutableByteIndexable mutableByteIndexable, @NotNull ByteOrdering byteOrdering) {
        int n = mutableByteIndexable.size();
        if (n <= 1) {
            return;
        }
        if (n == 2) {
            if (byteOrdering.checkByte(mutableByteIndexable.get(0), mutableByteIndexable.get(1)) == Order.Descending) {
                mutableByteIndexable.swap(0, 1);
            }
            return;
        }
        if (n < 33) {
            FastSortByte.insertionSort(mutableByteIndexable, byteOrdering);
            return;
        }
        int n2 = FastSortByte.partition(mutableByteIndexable, byteOrdering);
        FastSortByte.quickSort(mutableByteIndexable.headSet(n2), byteOrdering);
        FastSortByte.quickSort(mutableByteIndexable.tailSet(n2 + 1), byteOrdering);
    }

    private static int partition(@NotNull MutableByteIndexable mutableByteIndexable, @NotNull ByteOrdering byteOrdering) {
        byte by;
        int n = mutableByteIndexable.size() - 1;
        int n2 = n >> 1;
        byte by2 = mutableByteIndexable.get(0);
        byte by3 = mutableByteIndexable.get(n2);
        byte by4 = mutableByteIndexable.get(n);
        if (byteOrdering.ascending(by2, by3)) {
            if (byteOrdering.ascending(by3, by4)) {
                by = by3;
                mutableByteIndexable.swap(n2, n);
            } else {
                by = by4;
            }
        } else if (byteOrdering.ascending(by3, by4)) {
            by = by2;
            mutableByteIndexable.swap(0, n);
        } else {
            by = by3;
            mutableByteIndexable.swap(n2, n);
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (byteOrdering.checkByte(mutableByteIndexable.get(i), by) != Order.Ascending) continue;
            mutableByteIndexable.swap(n3++, i);
        }
        mutableByteIndexable.swyp(n3, -1);
        return n3;
    }

    private static void insertionSort(@NotNull MutableByteIndexable mutableByteIndexable, @NotNull ByteOrdering byteOrdering) {
        int n;
        int n2 = mutableByteIndexable.size() - 1;
        int n3 = n = 0;
        while (n < n2) {
            byte by = mutableByteIndexable.get(n + 1);
            while (byteOrdering.ascending(by, mutableByteIndexable.get(n3))) {
                mutableByteIndexable.set(n3 + 1, mutableByteIndexable.get(n3));
                if (n3-- != 0) continue;
            }
            mutableByteIndexable.set(n3 + 1, by);
            n3 = ++n;
        }
    }
}

