/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.algorithm;

import de.caff.annotation.NotNull;
import de.caff.generics.ExpandableIntIndexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.ShortIndexable;
import java.util.HashMap;
import java.util.Map;

public class FastShortSequenceSearch {
    @NotNull
    private final ShortIndexable term;
    @NotNull
    private final Map<Short, int[]> skipInfo = new HashMap<Short, int[]>();

    public FastShortSequenceSearch(@NotNull ShortIndexable shortIndexable) {
        this.term = shortIndexable;
        int n = shortIndexable.size();
        for (int i = 0; i < n; ++i) {
            Short s = shortIndexable.get(i);
            int[] nArray = this.skipInfo.get(s);
            if (nArray == null) {
                nArray = new int[]{-i};
            } else {
                int n2 = nArray.length;
                int[] nArray2 = new int[n2 + 1];
                nArray2[0] = -i;
                System.arraycopy(nArray, 0, nArray2, 1, n2);
                nArray = nArray2;
            }
            this.skipInfo.put(s, nArray);
        }
    }

    public FastShortSequenceSearch(short ... sArray) {
        this(ShortIndexable.viewArray(sArray));
    }

    public FastShortSequenceSearch(int ... nArray) {
        this(IntIndexable.viewArray(nArray).viewAsShort().frozen());
    }

    @NotNull
    public ShortIndexable getSearchTerm() {
        return this.term;
    }

    public int findFirst(@NotNull ShortIndexable shortIndexable) {
        return this.findNext(shortIndexable, 0);
    }

    public int findNext(@NotNull ShortIndexable shortIndexable, int n) {
        return this.findNext(shortIndexable, n, shortIndexable.size());
    }

    private boolean checkSimpleMatch(@NotNull ShortIndexable shortIndexable, int n) {
        for (short s : this.term) {
            if (s != shortIndexable.get(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int findNext(@NotNull ShortIndexable shortIndexable, int n, int n2) {
        if (this.skipInfo.size() < 4) {
            int n3 = n2 - this.term.size();
            while (n < n3) {
                if (this.checkSimpleMatch(shortIndexable, n)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        while (n < n2) {
            int n4 = Math.min(n + this.term.size(), n2) - 1;
            int[] nArray = this.skipInfo.get(shortIndexable.get(n4));
            if (nArray != null) {
                int n5 = 0;
                for (int n6 : nArray) {
                    int n7 = this.checkMatch(shortIndexable, n, n4, n2, n6);
                    if (n7 >= 0) {
                        return n7;
                    }
                    n5 = Math.min(n7, n5);
                }
                n += 1 - n5;
                continue;
            }
            n += this.term.size();
        }
        return -1;
    }

    private int checkMatch(@NotNull ShortIndexable shortIndexable, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            return n2 + this.term.size() <= n3 && this.equalsSequence(shortIndexable, n2, this.term.size()) ? n2 : -this.term.size();
        }
        if ((n2 += n4) < n) {
            return n2 - n;
        }
        int n5 = -n4 - this.term.size();
        int[] nArray = this.skipInfo.get(shortIndexable.get(n2));
        if (nArray == null) {
            return n5;
        }
        for (int n6 : nArray) {
            int n7 = this.checkMatch(shortIndexable, n, n2, n3, n6);
            if (n7 >= 0) {
                return n7;
            }
            n5 = Math.min(n7, n5);
        }
        return n5;
    }

    private boolean equalsSequence(@NotNull ShortIndexable shortIndexable, int n, int n2) {
        if (n2 > this.term.size()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.term.get(i) == shortIndexable.get(n + i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public IntIndexable findAllMatches(@NotNull ShortIndexable shortIndexable, boolean bl) {
        int n;
        ExpandableIntIndexable expandableIntIndexable = ExpandableIntIndexable.empty();
        int n2 = 0;
        while ((n = this.findNext(shortIndexable, n2)) >= 0) {
            expandableIntIndexable = expandableIntIndexable.add(n);
            n2 = n + (bl ? 1 : this.term.size());
        }
        return expandableIntIndexable;
    }
}

