/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.algorithm;

import de.caff.annotation.NotNull;
import de.caff.generics.ExpandableIntIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.function.Predicate2;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;

public class FastSequenceSearch<T> {
    @NotNull
    private final Indexable<T> term;
    @NotNull
    private final BiPredicate<? super T, ? super T> equality;
    @NotNull
    private final Map<T, int[]> skipInfo = new HashMap<T, int[]>();

    public FastSequenceSearch(@NotNull Indexable<T> indexable, @NotNull BiPredicate<? super T, ? super T> biPredicate) {
        this.term = indexable;
        this.equality = biPredicate;
        int n = indexable.size();
        for (int i = 0; i < n; ++i) {
            T t = indexable.get(i);
            int[] nArray = this.skipInfo.get(t);
            if (nArray == null) {
                nArray = new int[]{-i};
            } else {
                int n2 = nArray.length;
                int[] nArray2 = new int[n2 + 1];
                nArray2[0] = -i;
                System.arraycopy(nArray, 0, nArray2, 1, n2);
                nArray = nArray2;
            }
            this.skipInfo.put(t, nArray);
        }
    }

    @SafeVarargs
    public FastSequenceSearch(@NotNull BiPredicate<? super T, ? super T> biPredicate, T ... TArray) {
        this(Indexable.viewArray(TArray), biPredicate);
    }

    @NotNull
    public static <TT> FastSequenceSearch<TT> usingEquals(@NotNull Indexable<TT> indexable) {
        return new FastSequenceSearch<Object>(indexable, Objects::equals);
    }

    @SafeVarargs
    @NotNull
    public static <TT> FastSequenceSearch<TT> usingEquals(TT ... TTArray) {
        return new FastSequenceSearch<Object>(Objects::equals, TTArray);
    }

    @NotNull
    public static <TT> FastSequenceSearch<TT> usingDeepEquals(@NotNull Indexable<TT> indexable) {
        return new FastSequenceSearch<Object>(indexable, Objects::deepEquals);
    }

    @SafeVarargs
    @NotNull
    public static <TT> FastSequenceSearch<TT> usingDeepEquals(TT ... TTArray) {
        return new FastSequenceSearch<Object>(Objects::deepEquals, TTArray);
    }

    @NotNull
    public static <TT> FastSequenceSearch<TT> usingIdentity(@NotNull Indexable<TT> indexable) {
        return new FastSequenceSearch<TT>(indexable, Predicate2.areIdentical());
    }

    @SafeVarargs
    @NotNull
    public static <TT> FastSequenceSearch<TT> usingSame(TT ... TTArray) {
        return new FastSequenceSearch(Predicate2.areIdentical(), TTArray);
    }

    @NotNull
    public Indexable<T> getSearchTerm() {
        return this.term;
    }

    public int findFirst(@NotNull Indexable<T> indexable) {
        return this.findNext(indexable, 0);
    }

    public int findNext(@NotNull Indexable<T> indexable, int n) {
        return this.findNext(indexable, n, indexable.size());
    }

    private boolean checkSimpleMatch(@NotNull Indexable<T> indexable, int n) {
        for (T t : this.term) {
            if (!this.equality.test(t, indexable.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int findNext(@NotNull Indexable<T> indexable, int n, int n2) {
        if (this.skipInfo.size() < 4) {
            int n3 = n2 - this.term.size();
            while (n < n3) {
                if (this.checkSimpleMatch(indexable, n)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        while (n < n2) {
            int n4 = Math.min(n + this.term.size(), n2) - 1;
            int[] nArray = this.skipInfo.get(indexable.get(n4));
            if (nArray != null) {
                int n5 = 0;
                for (int n6 : nArray) {
                    int n7 = this.checkMatch(indexable, n, n4, n2, n6);
                    if (n7 >= 0) {
                        return n7;
                    }
                    n5 = Math.min(n7, n5);
                }
                n += 1 - n5;
                continue;
            }
            n += this.term.size();
        }
        return -1;
    }

    private int checkMatch(@NotNull Indexable<T> indexable, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            return n2 + this.term.size() <= n3 && this.equalsSequence(indexable, n2, this.term.size()) ? n2 : -this.term.size();
        }
        if ((n2 += n4) < n) {
            return n2 - n;
        }
        int n5 = -n4 - this.term.size();
        int[] nArray = this.skipInfo.get(indexable.get(n2));
        if (nArray == null) {
            return n5;
        }
        for (int n6 : nArray) {
            int n7 = this.checkMatch(indexable, n, n2, n3, n6);
            if (n7 >= 0) {
                return n7;
            }
            n5 = Math.min(n7, n5);
        }
        return n5;
    }

    private boolean equalsSequence(@NotNull Indexable<T> indexable, int n, int n2) {
        if (n2 > this.term.size()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.term.get(i) == indexable.get(n + i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public IntIndexable findAllMatches(@NotNull Indexable<T> indexable, boolean bl) {
        int n;
        ExpandableIntIndexable expandableIntIndexable = ExpandableIntIndexable.empty();
        int n2 = 0;
        while ((n = this.findNext(indexable, n2)) >= 0) {
            expandableIntIndexable = expandableIntIndexable.add(n);
            n2 = n + (bl ? 1 : this.term.size());
        }
        return expandableIntIndexable;
    }
}

