/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.algorithm;

import de.caff.annotation.NotNull;
import de.caff.generics.ExpandableIntIndexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongIndexable;
import java.util.HashMap;
import java.util.Map;

public class FastLongSequenceSearch {
    @NotNull
    private final LongIndexable term;
    @NotNull
    private final Map<Long, int[]> skipInfo = new HashMap<Long, int[]>();

    public FastLongSequenceSearch(@NotNull LongIndexable longIndexable) {
        this.term = longIndexable;
        int n = longIndexable.size();
        for (int i = 0; i < n; ++i) {
            Long l = longIndexable.get(i);
            int[] nArray = this.skipInfo.get(l);
            if (nArray == null) {
                nArray = new int[]{-i};
            } else {
                int n2 = nArray.length;
                int[] nArray2 = new int[n2 + 1];
                nArray2[0] = -i;
                System.arraycopy(nArray, 0, nArray2, 1, n2);
                nArray = nArray2;
            }
            this.skipInfo.put(l, nArray);
        }
    }

    public FastLongSequenceSearch(long ... lArray) {
        this(LongIndexable.viewArray(lArray));
    }

    @NotNull
    public LongIndexable getSearchTerm() {
        return this.term;
    }

    public int findFirst(@NotNull LongIndexable longIndexable) {
        return this.findNext(longIndexable, 0);
    }

    public int findNext(@NotNull LongIndexable longIndexable, int n) {
        return this.findNext(longIndexable, n, longIndexable.size());
    }

    private boolean checkSimpleMatch(@NotNull LongIndexable longIndexable, int n) {
        for (long l : this.term) {
            if (l != longIndexable.get(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int findNext(@NotNull LongIndexable longIndexable, int n, int n2) {
        if (this.skipInfo.size() < 4) {
            int n3 = n2 - this.term.size();
            while (n < n3) {
                if (this.checkSimpleMatch(longIndexable, n)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        while (n < n2) {
            int n4 = Math.min(n + this.term.size(), n2) - 1;
            int[] nArray = this.skipInfo.get(longIndexable.get(n4));
            if (nArray != null) {
                int n5 = 0;
                for (int n6 : nArray) {
                    int n7 = this.checkMatch(longIndexable, n, n4, n2, n6);
                    if (n7 >= 0) {
                        return n7;
                    }
                    n5 = Math.min(n7, n5);
                }
                n += 1 - n5;
                continue;
            }
            n += this.term.size();
        }
        return -1;
    }

    private int checkMatch(@NotNull LongIndexable longIndexable, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            return n2 + this.term.size() <= n3 && this.equalsSequence(longIndexable, n2, this.term.size()) ? n2 : -this.term.size();
        }
        if ((n2 += n4) < n) {
            return n2 - n;
        }
        int n5 = -n4 - this.term.size();
        int[] nArray = this.skipInfo.get(longIndexable.get(n2));
        if (nArray == null) {
            return n5;
        }
        for (int n6 : nArray) {
            int n7 = this.checkMatch(longIndexable, n, n2, n3, n6);
            if (n7 >= 0) {
                return n7;
            }
            n5 = Math.min(n7, n5);
        }
        return n5;
    }

    private boolean equalsSequence(@NotNull LongIndexable longIndexable, int n, int n2) {
        if (n2 > this.term.size()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.term.get(i) == longIndexable.get(n + i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public IntIndexable findAllMatches(@NotNull LongIndexable longIndexable, boolean bl) {
        int n;
        ExpandableIntIndexable expandableIntIndexable = ExpandableIntIndexable.empty();
        int n2 = 0;
        while ((n = this.findNext(longIndexable, n2)) >= 0) {
            expandableIntIndexable = expandableIntIndexable.add(n);
            n2 = n + (bl ? 1 : this.term.size());
        }
        return expandableIntIndexable;
    }
}

