/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.algorithm;

import de.caff.annotation.NotNull;
import de.caff.generics.ExpandableIntIndexable;
import de.caff.generics.FloatIndexable;
import de.caff.generics.IntIndexable;
import java.util.Map;
import java.util.TreeMap;

public class FastFloatSequenceSearch {
    @NotNull
    private final FloatIndexable term;
    @NotNull
    private final Map<Float, int[]> skipInfo = new TreeMap<Float, int[]>(Float::compare);

    public FastFloatSequenceSearch(@NotNull FloatIndexable floatIndexable) {
        this.term = floatIndexable;
        int n = floatIndexable.size();
        for (int i = 0; i < n; ++i) {
            Float f = Float.valueOf(floatIndexable.get(i));
            int[] nArray = this.skipInfo.get(f);
            if (nArray == null) {
                nArray = new int[]{-i};
            } else {
                int n2 = nArray.length;
                int[] nArray2 = new int[n2 + 1];
                nArray2[0] = -i;
                System.arraycopy(nArray, 0, nArray2, 1, n2);
                nArray = nArray2;
            }
            this.skipInfo.put(f, nArray);
        }
    }

    public FastFloatSequenceSearch(float ... fArray) {
        this(FloatIndexable.viewArray(fArray));
    }

    @NotNull
    public FloatIndexable getSearchTerm() {
        return this.term;
    }

    public int findFirst(@NotNull FloatIndexable floatIndexable) {
        return this.findNext(floatIndexable, 0);
    }

    public int findNext(@NotNull FloatIndexable floatIndexable, int n) {
        return this.findNext(floatIndexable, n, floatIndexable.size());
    }

    private boolean checkSimpleMatch(@NotNull FloatIndexable floatIndexable, int n) {
        for (float f : this.term) {
            if (Float.compare(f, floatIndexable.get(n)) != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int findNext(@NotNull FloatIndexable floatIndexable, int n, int n2) {
        if (this.skipInfo.size() < 4) {
            int n3 = n2 - this.term.size();
            while (n < n3) {
                if (this.checkSimpleMatch(floatIndexable, n)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        while (n < n2) {
            int n4 = Math.min(n + this.term.size(), n2) - 1;
            int[] nArray = this.skipInfo.get(Float.valueOf(floatIndexable.get(n4)));
            if (nArray != null) {
                int n5 = 0;
                for (int n6 : nArray) {
                    int n7 = this.checkMatch(floatIndexable, n, n4, n2, n6);
                    if (n7 >= 0) {
                        return n7;
                    }
                    n5 = Math.min(n7, n5);
                }
                n += 1 - n5;
                continue;
            }
            n += this.term.size();
        }
        return -1;
    }

    private int checkMatch(@NotNull FloatIndexable floatIndexable, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            return n2 + this.term.size() <= n3 && this.equalsSequence(floatIndexable, n2, this.term.size()) ? n2 : -this.term.size();
        }
        if ((n2 += n4) < n) {
            return n2 - n;
        }
        int n5 = -n4 - this.term.size();
        int[] nArray = this.skipInfo.get(Float.valueOf(floatIndexable.get(n2)));
        if (nArray == null) {
            return n5;
        }
        for (int n6 : nArray) {
            int n7 = this.checkMatch(floatIndexable, n, n2, n3, n6);
            if (n7 >= 0) {
                return n7;
            }
            n5 = Math.min(n7, n5);
        }
        return n5;
    }

    private boolean equalsSequence(@NotNull FloatIndexable floatIndexable, int n, int n2) {
        if (n2 > this.term.size()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.term.get(i) == floatIndexable.get(n + i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public IntIndexable findAllMatches(@NotNull FloatIndexable floatIndexable, boolean bl) {
        int n;
        ExpandableIntIndexable expandableIntIndexable = ExpandableIntIndexable.empty();
        int n2 = 0;
        while ((n = this.findNext(floatIndexable, n2)) >= 0) {
            expandableIntIndexable = expandableIntIndexable.add(n);
            n2 = n + (bl ? 1 : this.term.size());
        }
        return expandableIntIndexable;
    }
}

