/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.algorithm;

import de.caff.annotation.NotNull;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.ExpandableIntIndexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.Primitives;
import java.util.Map;
import java.util.TreeMap;

public class FastDoubleSequenceSearch {
    @NotNull
    private final DoubleIndexable term;
    @NotNull
    private final Map<Double, int[]> skipInfo = new TreeMap<Double, int[]>(Double::compare);

    public FastDoubleSequenceSearch(@NotNull DoubleIndexable doubleIndexable) {
        this.term = doubleIndexable;
        int n = doubleIndexable.size();
        for (int i = 0; i < n; ++i) {
            Double d = doubleIndexable.get(i);
            int[] nArray = this.skipInfo.get(d);
            if (nArray == null) {
                nArray = new int[]{-i};
            } else {
                int n2 = nArray.length;
                int[] nArray2 = new int[n2 + 1];
                nArray2[0] = -i;
                System.arraycopy(nArray, 0, nArray2, 1, n2);
                nArray = nArray2;
            }
            this.skipInfo.put(d, nArray);
        }
    }

    public FastDoubleSequenceSearch(double ... dArray) {
        this(DoubleIndexable.viewArray(dArray));
    }

    @NotNull
    public DoubleIndexable getSearchTerm() {
        return this.term;
    }

    public int findFirst(@NotNull DoubleIndexable doubleIndexable) {
        return this.findNext(doubleIndexable, 0);
    }

    public int findNext(@NotNull DoubleIndexable doubleIndexable, int n) {
        return this.findNext(doubleIndexable, n, doubleIndexable.size());
    }

    private boolean checkSimpleMatch(@NotNull DoubleIndexable doubleIndexable, int n) {
        for (double d : this.term) {
            if (!Primitives.areEqual(d, doubleIndexable.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int findNext(@NotNull DoubleIndexable doubleIndexable, int n, int n2) {
        if (this.skipInfo.size() < 4) {
            int n3 = n2 - this.term.size();
            while (n < n3) {
                if (this.checkSimpleMatch(doubleIndexable, n)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        while (n < n2) {
            int n4 = Math.min(n + this.term.size(), n2) - 1;
            int[] nArray = this.skipInfo.get(doubleIndexable.get(n4));
            if (nArray != null) {
                int n5 = 0;
                for (int n6 : nArray) {
                    int n7 = this.checkMatch(doubleIndexable, n, n4, n2, n6);
                    if (n7 >= 0) {
                        return n7;
                    }
                    n5 = Math.min(n7, n5);
                }
                n += 1 - n5;
                continue;
            }
            n += this.term.size();
        }
        return -1;
    }

    private int checkMatch(@NotNull DoubleIndexable doubleIndexable, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            return n2 + this.term.size() <= n3 && this.equalsSequence(doubleIndexable, n2, this.term.size()) ? n2 : -this.term.size();
        }
        if ((n2 += n4) < n) {
            return n2 - n;
        }
        int n5 = -n4 - this.term.size();
        int[] nArray = this.skipInfo.get(doubleIndexable.get(n2));
        if (nArray == null) {
            return n5;
        }
        for (int n6 : nArray) {
            int n7 = this.checkMatch(doubleIndexable, n, n2, n3, n6);
            if (n7 >= 0) {
                return n7;
            }
            n5 = Math.min(n7, n5);
        }
        return n5;
    }

    private boolean equalsSequence(@NotNull DoubleIndexable doubleIndexable, int n, int n2) {
        if (n2 > this.term.size()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.term.get(i) == doubleIndexable.get(n + i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public IntIndexable findAllMatches(@NotNull DoubleIndexable doubleIndexable, boolean bl) {
        int n;
        ExpandableIntIndexable expandableIntIndexable = ExpandableIntIndexable.empty();
        int n2 = 0;
        while ((n = this.findNext(doubleIndexable, n2)) >= 0) {
            expandableIntIndexable = expandableIntIndexable.add(n);
            n2 = n + (bl ? 1 : this.term.size());
        }
        return expandableIntIndexable;
    }
}

