/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.algorithm;

import de.caff.annotation.NotNull;
import de.caff.generics.CharIndexable;
import de.caff.generics.ExpandableIntIndexable;
import de.caff.generics.IntIndexable;
import java.util.HashMap;
import java.util.Map;

public class FastCharSequenceSearch {
    @NotNull
    private final CharIndexable term;
    @NotNull
    private final Map<Character, int[]> skipInfo = new HashMap<Character, int[]>();

    public FastCharSequenceSearch(@NotNull CharIndexable charIndexable) {
        this.term = charIndexable;
        int n = charIndexable.size();
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(charIndexable.get(i));
            int[] nArray = this.skipInfo.get(c);
            if (nArray == null) {
                nArray = new int[]{-i};
            } else {
                int n2 = nArray.length;
                int[] nArray2 = new int[n2 + 1];
                nArray2[0] = -i;
                System.arraycopy(nArray, 0, nArray2, 1, n2);
                nArray = nArray2;
            }
            this.skipInfo.put(c, nArray);
        }
    }

    public FastCharSequenceSearch(@NotNull String string) {
        this(CharIndexable.viewString(string));
    }

    public FastCharSequenceSearch(char ... cArray) {
        this(CharIndexable.viewArray(cArray));
    }

    @NotNull
    public CharIndexable getSearchTerm() {
        return this.term;
    }

    public int findFirst(@NotNull CharIndexable charIndexable) {
        return this.findNext(charIndexable, 0);
    }

    public int findNext(@NotNull CharIndexable charIndexable, int n) {
        return this.findNext(charIndexable, n, charIndexable.size());
    }

    private boolean checkSimpleMatch(@NotNull CharIndexable charIndexable, int n) {
        for (char c : this.term) {
            if (c != charIndexable.get(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int findNext(@NotNull CharIndexable charIndexable, int n, int n2) {
        if (this.skipInfo.size() < 4) {
            int n3 = n2 - this.term.size();
            while (n < n3) {
                if (this.checkSimpleMatch(charIndexable, n)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        while (n < n2) {
            int n4 = Math.min(n + this.term.size(), n2) - 1;
            int[] nArray = this.skipInfo.get(Character.valueOf(charIndexable.get(n4)));
            if (nArray != null) {
                int n5 = 0;
                for (int n6 : nArray) {
                    int n7 = this.checkMatch(charIndexable, n, n4, n2, n6);
                    if (n7 >= 0) {
                        return n7;
                    }
                    n5 = Math.min(n7, n5);
                }
                n += 1 - n5;
                continue;
            }
            n += this.term.size();
        }
        return -1;
    }

    private int checkMatch(@NotNull CharIndexable charIndexable, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            return n2 + this.term.size() <= n3 && this.equalsSequence(charIndexable, n2, this.term.size()) ? n2 : -this.term.size();
        }
        if ((n2 += n4) < n) {
            return n2 - n;
        }
        int n5 = -n4 - this.term.size();
        int[] nArray = this.skipInfo.get(Character.valueOf(charIndexable.get(n2)));
        if (nArray == null) {
            return n5;
        }
        for (int n6 : nArray) {
            int n7 = this.checkMatch(charIndexable, n, n2, n3, n6);
            if (n7 >= 0) {
                return n7;
            }
            n5 = Math.min(n7, n5);
        }
        return n5;
    }

    private boolean equalsSequence(@NotNull CharIndexable charIndexable, int n, int n2) {
        if (n2 > this.term.size()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.term.get(i) == charIndexable.get(n + i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public IntIndexable findAllMatches(@NotNull CharIndexable charIndexable, boolean bl) {
        int n;
        ExpandableIntIndexable expandableIntIndexable = ExpandableIntIndexable.empty();
        int n2 = 0;
        while ((n = this.findNext(charIndexable, n2)) >= 0) {
            expandableIntIndexable = expandableIntIndexable.add(n);
            n2 = n + (bl ? 1 : this.term.size());
        }
        return expandableIntIndexable;
    }
}

