/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.algorithm;

import de.caff.annotation.NotNull;
import de.caff.generics.ByteIndexable;
import de.caff.generics.ExpandableIntIndexable;
import de.caff.generics.IntIndexable;

public class FastByteSequenceSearch {
    @NotNull
    private final ByteIndexable term;
    @NotNull
    private final int[][] skipInfo = new int[256][];

    public FastByteSequenceSearch(@NotNull ByteIndexable byteIndexable) {
        this.term = byteIndexable;
        int n = byteIndexable.size();
        for (int i = 0; i < n; ++i) {
            int n2 = byteIndexable.get(i) & 0xFF;
            int[] nArray = this.skipInfo[n2];
            if (nArray == null) {
                nArray = new int[]{-i};
            } else {
                int n3 = nArray.length;
                int[] nArray2 = new int[n3 + 1];
                nArray2[0] = -i;
                System.arraycopy(nArray, 0, nArray2, 1, n3);
                nArray = nArray2;
            }
            this.skipInfo[n2] = nArray;
        }
    }

    public FastByteSequenceSearch(byte ... byArray) {
        this(ByteIndexable.viewArray(byArray));
    }

    public FastByteSequenceSearch(int ... nArray) {
        this(IntIndexable.viewArray(nArray).viewAsByte().frozen());
    }

    @NotNull
    public ByteIndexable getSearchTerm() {
        return this.term;
    }

    public int findFirst(@NotNull ByteIndexable byteIndexable) {
        return this.findNext(byteIndexable, 0);
    }

    public int findNext(@NotNull ByteIndexable byteIndexable, int n) {
        return this.findNext(byteIndexable, n, byteIndexable.size());
    }

    private boolean checkSimpleMatch(@NotNull ByteIndexable byteIndexable, int n) {
        for (byte by : this.term) {
            if (by != byteIndexable.get(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int findNext(@NotNull ByteIndexable byteIndexable, int n, int n2) {
        if (this.skipInfo.length < 4) {
            int n3 = n2 - this.term.size();
            while (n < n3) {
                if (this.checkSimpleMatch(byteIndexable, n)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        while (n < n2) {
            int n4 = Math.min(n + this.term.size(), n2) - 1;
            int[] nArray = this.skipInfo[byteIndexable.get(n4) & 0xFF];
            if (nArray != null) {
                int n5 = 0;
                for (int n6 : nArray) {
                    int n7 = this.checkMatch(byteIndexable, n, n4, n2, n6);
                    if (n7 >= 0) {
                        return n7;
                    }
                    n5 = Math.min(n7, n5);
                }
                n += 1 - n5;
                continue;
            }
            n += this.term.size();
        }
        return -1;
    }

    private int checkMatch(@NotNull ByteIndexable byteIndexable, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            return n2 + this.term.size() <= n3 && this.equalsSequence(byteIndexable, n2, this.term.size()) ? n2 : -this.term.size();
        }
        if ((n2 += n4) < n) {
            return n2 - n;
        }
        int n5 = -n4 - this.term.size();
        int[] nArray = this.skipInfo[byteIndexable.get(n2) & 0xFF];
        if (nArray == null) {
            return n5;
        }
        for (int n6 : nArray) {
            int n7 = this.checkMatch(byteIndexable, n, n2, n3, n6);
            if (n7 >= 0) {
                return n7;
            }
            n5 = Math.min(n7, n5);
        }
        return n5;
    }

    private boolean equalsSequence(@NotNull ByteIndexable byteIndexable, int n, int n2) {
        if (n2 > this.term.size()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.term.get(i) == byteIndexable.get(n + i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public IntIndexable findAllMatches(@NotNull ByteIndexable byteIndexable, boolean bl) {
        int n;
        ExpandableIntIndexable expandableIntIndexable = ExpandableIntIndexable.empty();
        int n2 = 0;
        while ((n = this.findNext(byteIndexable, n2)) >= 0) {
            expandableIntIndexable = expandableIntIndexable.add(n);
            n2 = n + (bl ? 1 : this.term.size());
        }
        return expandableIntIndexable;
    }
}

