/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.algorithm;

import de.caff.annotation.NotNull;
import de.caff.generics.MutableByteIndexable;
import de.caff.generics.MutableIndexable;
import de.caff.generics.MutableIntIndexable;
import de.caff.generics.algorithm.FastSortByte;
import de.caff.generics.function.ByteOrdering;
import de.caff.generics.function.CharOrdering;
import de.caff.generics.function.DoubleOrdering;
import de.caff.generics.function.FloatOrdering;
import de.caff.generics.function.IntOrdering;
import de.caff.generics.function.LongOrdering;
import de.caff.generics.function.Ordering;
import de.caff.generics.function.ShortOrdering;

public final class DualPivotQuicksort {
    private static final int MAX_RUN_COUNT = 67;
    private static final int MAX_RUN_LENGTH = 33;
    private static final int QUICKSORT_THRESHOLD = 286;
    private static final int INSERTION_SORT_THRESHOLD = 47;
    private static final int COUNTING_SORT_THRESHOLD_FOR_BYTE = 29;
    private static final int COUNTING_SORT_THRESHOLD_FOR_SHORT_OR_CHAR = 3200;
    private static final int NUM_SHORT_VALUES = 65536;
    private static final int NUM_CHAR_VALUES = 65536;
    private static final int NUM_BYTE_VALUES = 256;

    private DualPivotQuicksort() {
    }

    public static void sort(int[] nArray, @NotNull IntOrdering intOrdering) {
        DualPivotQuicksort.sort(nArray, 0, nArray.length - 1, intOrdering);
    }

    public static void sort(int[] nArray, int n, int n2, @NotNull IntOrdering intOrdering) {
        int[] nArray2;
        int n3;
        int n4;
        if (n2 - n < 286) {
            DualPivotQuicksort.sort(nArray, n, n2, intOrdering, true);
            return;
        }
        int[] nArray3 = new int[68];
        int n5 = 0;
        nArray3[0] = n;
        int n6 = n;
        while (n6 < n2) {
            switch (intOrdering.checkInt(nArray[n6], nArray[n6 + 1])) {
                case Ascending: {
                    while (++n6 <= n2 && intOrdering.ascendingOrSame(nArray[n6 - 1], nArray[n6])) {
                    }
                    break;
                }
                case Descending: {
                    while (++n6 <= n2 && intOrdering.descendingOrSame(nArray[n6 - 1], nArray[n6])) {
                    }
                    n4 = nArray3[n5] - 1;
                    n3 = n6;
                    while (++n4 < --n3) {
                        int n7 = nArray[n4];
                        nArray[n4] = nArray[n3];
                        nArray[n3] = n7;
                    }
                    break;
                }
                default: {
                    n4 = 33;
                    while (++n6 <= n2 && intOrdering.same(nArray[n6 - 1], nArray[n6])) {
                        if (--n4 != 0) continue;
                        DualPivotQuicksort.sort(nArray, n, n2, intOrdering, true);
                        return;
                    }
                    break block0;
                }
            }
            if (++n5 == 67) {
                DualPivotQuicksort.sort(nArray, n, n2, intOrdering, true);
                return;
            }
            nArray3[n5] = n6;
        }
        if (nArray3[n5] == n2++) {
            nArray3[++n5] = n2;
        } else if (n5 == 1) {
            return;
        }
        n4 = 0;
        n3 = 1;
        while ((n3 <<= 1) < n5) {
            n4 = (byte)(n4 ^ 1);
        }
        if (n4 == 0) {
            nArray2 = nArray;
            nArray = new int[nArray2.length];
            n3 = n - 1;
            while (++n3 < n2) {
                nArray[n3] = nArray2[n3];
            }
        } else {
            nArray2 = new int[nArray.length];
        }
        while (n5 > 1) {
            int n8;
            int n9;
            n3 = 0;
            for (n9 = 0 + 2; n9 <= n5; n9 += 2) {
                int n10;
                n8 = nArray3[n9];
                int n11 = nArray3[n9 - 1];
                int n12 = n10 = nArray3[n9 - 2];
                int n13 = n11;
                while (n10 < n8) {
                    nArray2[n10] = n13 >= n8 || n12 < n11 && intOrdering.ascending(nArray[n12], nArray[n13]) ? nArray[n12++] : nArray[n13++];
                    ++n10;
                }
                nArray3[++n3] = n8;
            }
            if ((n5 & 1) != 0) {
                n9 = n2;
                n8 = nArray3[n5 - 1];
                while (--n9 >= n8) {
                    nArray2[n9] = nArray[n9];
                }
                nArray3[++n3] = n2;
            }
            int[] nArray4 = nArray;
            nArray = nArray2;
            nArray2 = nArray4;
            n5 = n3;
        }
    }

    private static void sort(int[] nArray, int n, int n2, @NotNull IntOrdering intOrdering, boolean bl) {
        int n3;
        int n4 = n2 - n + 1;
        if (n4 < 47) {
            if (bl) {
                int n5;
                int n6 = n5 = n;
                while (n5 < n2) {
                    int n7 = nArray[n5 + 1];
                    while (intOrdering.ascending(n7, nArray[n6])) {
                        nArray[n6 + 1] = nArray[n6];
                        if (n6-- != n) continue;
                    }
                    nArray[n6 + 1] = n7;
                    n6 = ++n5;
                }
            } else {
                do {
                    if (n < n2) continue;
                    return;
                } while (intOrdering.descendingOrSame(nArray[++n], nArray[n - 1]));
                int n8 = n;
                while (++n <= n2) {
                    int n9 = nArray[n8];
                    int n10 = nArray[n];
                    if (intOrdering.ascending(n9, n10)) {
                        n10 = n9;
                        n9 = nArray[n];
                    }
                    while (intOrdering.ascending(n9, nArray[--n8])) {
                        nArray[n8 + 2] = nArray[n8];
                    }
                    nArray[++n8 + 1] = n9;
                    while (intOrdering.ascending(n10, nArray[--n8])) {
                        nArray[n8 + 1] = nArray[n8];
                    }
                    nArray[n8 + 1] = n10;
                    n8 = ++n;
                }
                n8 = nArray[n2];
                while (intOrdering.ascending(n8, nArray[--n2])) {
                    nArray[n2 + 1] = nArray[n2];
                }
                nArray[n2 + 1] = n8;
            }
            return;
        }
        int n11 = (n4 >> 3) + (n4 >> 6) + 1;
        int n12 = n + n2 >>> 1;
        int n13 = n12 - n11;
        int n14 = n13 - n11;
        int n15 = n12 + n11;
        int n16 = n15 + n11;
        if (intOrdering.ascending(nArray[n13], nArray[n14])) {
            n3 = nArray[n13];
            nArray[n13] = nArray[n14];
            nArray[n14] = n3;
        }
        if (intOrdering.ascending(nArray[n12], nArray[n13])) {
            n3 = nArray[n12];
            nArray[n12] = nArray[n13];
            nArray[n13] = n3;
            if (intOrdering.ascending(n3, nArray[n14])) {
                nArray[n13] = nArray[n14];
                nArray[n14] = n3;
            }
        }
        if (intOrdering.ascending(nArray[n15], nArray[n12])) {
            n3 = nArray[n15];
            nArray[n15] = nArray[n12];
            nArray[n12] = n3;
            if (intOrdering.ascending(n3, nArray[n13])) {
                nArray[n12] = nArray[n13];
                nArray[n13] = n3;
                if (intOrdering.ascending(n3, nArray[n14])) {
                    nArray[n13] = nArray[n14];
                    nArray[n14] = n3;
                }
            }
        }
        if (intOrdering.ascending(nArray[n16], nArray[n15])) {
            n3 = nArray[n16];
            nArray[n16] = nArray[n15];
            nArray[n15] = n3;
            if (intOrdering.ascending(n3, nArray[n12])) {
                nArray[n15] = nArray[n12];
                nArray[n12] = n3;
                if (intOrdering.ascending(n3, nArray[n13])) {
                    nArray[n12] = nArray[n13];
                    nArray[n13] = n3;
                    if (intOrdering.ascending(n3, nArray[n14])) {
                        nArray[n13] = nArray[n14];
                        nArray[n14] = n3;
                    }
                }
            }
        }
        n3 = n;
        int n17 = n2;
        if (intOrdering.different(nArray[n14], nArray[n13]) && intOrdering.different(nArray[n13], nArray[n12]) && intOrdering.different(nArray[n12], nArray[n15]) && intOrdering.different(nArray[n15], nArray[n16])) {
            int n18;
            int n19 = nArray[n13];
            int n20 = nArray[n15];
            nArray[n13] = nArray[n];
            nArray[n15] = nArray[n2];
            while (intOrdering.ascending(nArray[++n3], n19)) {
            }
            while (intOrdering.descending(nArray[--n17], n20)) {
            }
            int n21 = n3 - 1;
            block9: while (++n21 <= n17) {
                n18 = nArray[n21];
                if (intOrdering.ascending(n18, n19)) {
                    nArray[n21] = nArray[n3];
                    nArray[n3] = n18;
                    ++n3;
                    continue;
                }
                if (!intOrdering.descending(n18, n20)) continue;
                while (intOrdering.descending(nArray[n17], n20)) {
                    if (n17-- != n21) continue;
                    break block9;
                }
                if (intOrdering.ascending(nArray[n17], n19)) {
                    nArray[n21] = nArray[n3];
                    nArray[n3] = nArray[n17];
                    ++n3;
                } else {
                    nArray[n21] = nArray[n17];
                }
                nArray[n17] = n18;
                --n17;
            }
            nArray[n] = nArray[n3 - 1];
            nArray[n3 - 1] = n19;
            nArray[n2] = nArray[n17 + 1];
            nArray[n17 + 1] = n20;
            DualPivotQuicksort.sort(nArray, n, n3 - 2, intOrdering, bl);
            DualPivotQuicksort.sort(nArray, n17 + 2, n2, intOrdering, false);
            if (n3 < n14 && n16 < n17) {
                while (intOrdering.same(nArray[n3], n19)) {
                    ++n3;
                }
                while (intOrdering.same(nArray[n17], n20)) {
                    --n17;
                }
                n21 = n3 - 1;
                block13: while (++n21 <= n17) {
                    n18 = nArray[n21];
                    if (intOrdering.same(n18, n19)) {
                        nArray[n21] = nArray[n3];
                        nArray[n3] = n18;
                        ++n3;
                        continue;
                    }
                    if (!intOrdering.same(n18, n20)) continue;
                    while (intOrdering.same(nArray[n17], n20)) {
                        if (n17-- != n21) continue;
                        break block13;
                    }
                    if (intOrdering.same(nArray[n17], n19)) {
                        nArray[n21] = nArray[n3];
                        nArray[n3] = n19;
                        ++n3;
                    } else {
                        nArray[n21] = nArray[n17];
                    }
                    nArray[n17] = n18;
                    --n17;
                }
            }
            DualPivotQuicksort.sort(nArray, n3, n17, intOrdering, false);
        } else {
            int n22 = nArray[n12];
            for (int i = n3; i <= n17; ++i) {
                if (intOrdering.same(nArray[i], n22)) continue;
                int n23 = nArray[i];
                if (intOrdering.ascending(n23, n22)) {
                    nArray[i] = nArray[n3];
                    nArray[n3] = n23;
                    ++n3;
                    continue;
                }
                while (intOrdering.descending(nArray[n17], n22)) {
                    --n17;
                }
                if (intOrdering.ascending(nArray[n17], n22)) {
                    nArray[i] = nArray[n3];
                    nArray[n3] = nArray[n17];
                    ++n3;
                } else {
                    nArray[i] = n22;
                }
                nArray[n17] = n23;
                --n17;
            }
            DualPivotQuicksort.sort(nArray, n, n3 - 1, intOrdering, bl);
            DualPivotQuicksort.sort(nArray, n17 + 1, n2, intOrdering, false);
        }
    }

    public static void sort(long[] lArray, @NotNull LongOrdering longOrdering) {
        DualPivotQuicksort.sort(lArray, 0, lArray.length - 1, longOrdering);
    }

    public static void sort(long[] lArray, int n, int n2, @NotNull LongOrdering longOrdering) {
        long[] lArray2;
        int n3;
        int n4;
        if (n2 - n < 286) {
            DualPivotQuicksort.sort(lArray, n, n2, longOrdering, true);
            return;
        }
        int[] nArray = new int[68];
        int n5 = 0;
        nArray[0] = n;
        int n6 = n;
        while (n6 < n2) {
            switch (longOrdering.checkLong(lArray[n6], lArray[n6 + 1])) {
                case Ascending: {
                    while (++n6 <= n2 && longOrdering.ascendingOrSame(lArray[n6 - 1], lArray[n6])) {
                    }
                    break;
                }
                case Descending: {
                    while (++n6 <= n2 && longOrdering.descendingOrSame(lArray[n6 - 1], lArray[n6])) {
                    }
                    n4 = nArray[n5] - 1;
                    n3 = n6;
                    while (++n4 < --n3) {
                        long l = lArray[n4];
                        lArray[n4] = lArray[n3];
                        lArray[n3] = l;
                    }
                    break;
                }
                default: {
                    n4 = 33;
                    while (++n6 <= n2 && longOrdering.same(lArray[n6 - 1], lArray[n6])) {
                        if (--n4 != 0) continue;
                        DualPivotQuicksort.sort(lArray, n, n2, longOrdering, true);
                        return;
                    }
                    break block0;
                }
            }
            if (++n5 == 67) {
                DualPivotQuicksort.sort(lArray, n, n2, longOrdering, true);
                return;
            }
            nArray[n5] = n6;
        }
        if (nArray[n5] == n2++) {
            nArray[++n5] = n2;
        } else if (n5 == 1) {
            return;
        }
        n4 = 0;
        n3 = 1;
        while ((n3 <<= 1) < n5) {
            n4 = (byte)(n4 ^ 1);
        }
        if (n4 == 0) {
            lArray2 = lArray;
            lArray = new long[lArray2.length];
            n3 = n - 1;
            while (++n3 < n2) {
                lArray[n3] = lArray2[n3];
            }
        } else {
            lArray2 = new long[lArray.length];
        }
        while (n5 > 1) {
            int n7;
            int n8;
            n3 = 0;
            for (n8 = 0 + 2; n8 <= n5; n8 += 2) {
                int n9;
                n7 = nArray[n8];
                int n10 = nArray[n8 - 1];
                int n11 = n9 = nArray[n8 - 2];
                int n12 = n10;
                while (n9 < n7) {
                    lArray2[n9] = n12 >= n7 || n11 < n10 && longOrdering.ascendingOrSame(lArray[n11], lArray[n12]) ? lArray[n11++] : lArray[n12++];
                    ++n9;
                }
                nArray[++n3] = n7;
            }
            if ((n5 & 1) != 0) {
                n8 = n2;
                n7 = nArray[n5 - 1];
                while (--n8 >= n7) {
                    lArray2[n8] = lArray[n8];
                }
                nArray[++n3] = n2;
            }
            long[] lArray3 = lArray;
            lArray = lArray2;
            lArray2 = lArray3;
            n5 = n3;
        }
    }

    private static void sort(long[] lArray, int n, int n2, @NotNull LongOrdering longOrdering, boolean bl) {
        long l;
        int n3 = n2 - n + 1;
        if (n3 < 47) {
            if (bl) {
                int n4;
                int n5 = n4 = n;
                while (n4 < n2) {
                    long l2 = lArray[n4 + 1];
                    while (longOrdering.ascending(l2, lArray[n5])) {
                        lArray[n5 + 1] = lArray[n5];
                        if (n5-- != n) continue;
                    }
                    lArray[n5 + 1] = l2;
                    n5 = ++n4;
                }
            } else {
                do {
                    if (n < n2) continue;
                    return;
                } while (longOrdering.descendingOrSame(lArray[++n], lArray[n - 1]));
                int n6 = n;
                while (++n <= n2) {
                    long l3 = lArray[n6];
                    long l4 = lArray[n];
                    if (longOrdering.ascending(l3, l4)) {
                        l4 = l3;
                        l3 = lArray[n];
                    }
                    while (longOrdering.ascending(l3, lArray[--n6])) {
                        lArray[n6 + 2] = lArray[n6];
                    }
                    lArray[++n6 + 1] = l3;
                    while (longOrdering.ascending(l4, lArray[--n6])) {
                        lArray[n6 + 1] = lArray[n6];
                    }
                    lArray[n6 + 1] = l4;
                    n6 = ++n;
                }
                long l5 = lArray[n2];
                while (longOrdering.ascending(l5, lArray[--n2])) {
                    lArray[n2 + 1] = lArray[n2];
                }
                lArray[n2 + 1] = l5;
            }
            return;
        }
        int n7 = (n3 >> 3) + (n3 >> 6) + 1;
        int n8 = n + n2 >>> 1;
        int n9 = n8 - n7;
        int n10 = n9 - n7;
        int n11 = n8 + n7;
        int n12 = n11 + n7;
        if (longOrdering.ascending(lArray[n9], lArray[n10])) {
            l = lArray[n9];
            lArray[n9] = lArray[n10];
            lArray[n10] = l;
        }
        if (longOrdering.ascending(lArray[n8], lArray[n9])) {
            l = lArray[n8];
            lArray[n8] = lArray[n9];
            lArray[n9] = l;
            if (longOrdering.ascending(l, lArray[n10])) {
                lArray[n9] = lArray[n10];
                lArray[n10] = l;
            }
        }
        if (longOrdering.ascending(lArray[n11], lArray[n8])) {
            l = lArray[n11];
            lArray[n11] = lArray[n8];
            lArray[n8] = l;
            if (longOrdering.ascending(l, lArray[n9])) {
                lArray[n8] = lArray[n9];
                lArray[n9] = l;
                if (longOrdering.ascending(l, lArray[n10])) {
                    lArray[n9] = lArray[n10];
                    lArray[n10] = l;
                }
            }
        }
        if (longOrdering.ascending(lArray[n12], lArray[n11])) {
            l = lArray[n12];
            lArray[n12] = lArray[n11];
            lArray[n11] = l;
            if (longOrdering.ascending(l, lArray[n8])) {
                lArray[n11] = lArray[n8];
                lArray[n8] = l;
                if (longOrdering.ascending(l, lArray[n9])) {
                    lArray[n8] = lArray[n9];
                    lArray[n9] = l;
                    if (longOrdering.ascending(l, lArray[n10])) {
                        lArray[n9] = lArray[n10];
                        lArray[n10] = l;
                    }
                }
            }
        }
        int n13 = n;
        int n14 = n2;
        if (longOrdering.different(lArray[n10], lArray[n9]) && longOrdering.different(lArray[n9], lArray[n8]) && longOrdering.different(lArray[n8], lArray[n11]) && longOrdering.different(lArray[n11], lArray[n12])) {
            long l6;
            long l7 = lArray[n9];
            long l8 = lArray[n11];
            lArray[n9] = lArray[n];
            lArray[n11] = lArray[n2];
            while (longOrdering.ascending(lArray[++n13], l7)) {
            }
            while (longOrdering.descending(lArray[--n14], l8)) {
            }
            int n15 = n13 - 1;
            block9: while (++n15 <= n14) {
                l6 = lArray[n15];
                if (longOrdering.ascending(l6, l7)) {
                    lArray[n15] = lArray[n13];
                    lArray[n13] = l6;
                    ++n13;
                    continue;
                }
                if (!longOrdering.descending(l6, l8)) continue;
                while (longOrdering.descending(lArray[n14], l8)) {
                    if (n14-- != n15) continue;
                    break block9;
                }
                if (longOrdering.ascending(lArray[n14], l7)) {
                    lArray[n15] = lArray[n13];
                    lArray[n13] = lArray[n14];
                    ++n13;
                } else {
                    lArray[n15] = lArray[n14];
                }
                lArray[n14] = l6;
                --n14;
            }
            lArray[n] = lArray[n13 - 1];
            lArray[n13 - 1] = l7;
            lArray[n2] = lArray[n14 + 1];
            lArray[n14 + 1] = l8;
            DualPivotQuicksort.sort(lArray, n, n13 - 2, longOrdering, bl);
            DualPivotQuicksort.sort(lArray, n14 + 2, n2, longOrdering, false);
            if (n13 < n10 && n12 < n14) {
                while (longOrdering.same(lArray[n13], l7)) {
                    ++n13;
                }
                while (longOrdering.same(lArray[n14], l8)) {
                    --n14;
                }
                n15 = n13 - 1;
                block13: while (++n15 <= n14) {
                    l6 = lArray[n15];
                    if (longOrdering.same(l6, l7)) {
                        lArray[n15] = lArray[n13];
                        lArray[n13] = l6;
                        ++n13;
                        continue;
                    }
                    if (!longOrdering.same(l6, l8)) continue;
                    while (longOrdering.same(lArray[n14], l8)) {
                        if (n14-- != n15) continue;
                        break block13;
                    }
                    if (longOrdering.same(lArray[n14], l7)) {
                        lArray[n15] = lArray[n13];
                        lArray[n13] = l7;
                        ++n13;
                    } else {
                        lArray[n15] = lArray[n14];
                    }
                    lArray[n14] = l6;
                    --n14;
                }
            }
            DualPivotQuicksort.sort(lArray, n13, n14, longOrdering, false);
        } else {
            long l9 = lArray[n8];
            for (int i = n13; i <= n14; ++i) {
                if (longOrdering.same(lArray[i], l9)) continue;
                long l10 = lArray[i];
                if (longOrdering.ascending(l10, l9)) {
                    lArray[i] = lArray[n13];
                    lArray[n13] = l10;
                    ++n13;
                    continue;
                }
                while (longOrdering.descending(lArray[n14], l9)) {
                    --n14;
                }
                if (longOrdering.ascending(lArray[n14], l9)) {
                    lArray[i] = lArray[n13];
                    lArray[n13] = lArray[n14];
                    ++n13;
                } else {
                    lArray[i] = l9;
                }
                lArray[n14] = l10;
                --n14;
            }
            DualPivotQuicksort.sort(lArray, n, n13 - 1, longOrdering, bl);
            DualPivotQuicksort.sort(lArray, n14 + 1, n2, longOrdering, false);
        }
    }

    public static void sort(@NotNull short[] sArray, @NotNull ShortOrdering shortOrdering) {
        DualPivotQuicksort.sort(sArray, 0, sArray.length - 1, shortOrdering);
    }

    public static void sort(@NotNull short[] sArray, int n, int n2, @NotNull ShortOrdering shortOrdering) {
        if (n2 - n > 3200) {
            int n3;
            int n4 = n2 - n + 1;
            int[] nArray = new int[65536];
            short[] sArray2 = new short[Math.min(65536, n4)];
            int n5 = 0;
            for (n3 = n; n3 <= n2; ++n3) {
                int n6 = sArray[n3] - Short.MIN_VALUE;
                int n7 = nArray[n6];
                nArray[n6] = n7 + 1;
                if (n7 != 0) continue;
                sArray2[n5++] = sArray[n3];
            }
            if (n5 < n4) {
                DualPivotQuicksort.doSort(sArray2, 0, n5 - 1, shortOrdering);
                n3 = n;
                for (int i = 0; i < n5; ++i) {
                    short s = sArray2[i];
                    int n8 = nArray[s - Short.MIN_VALUE];
                    assert (n8 > 0);
                    while (--n8 >= 0) {
                        sArray[n3++] = s;
                    }
                }
                return;
            }
        }
        DualPivotQuicksort.doSort(sArray, n, n2, shortOrdering);
    }

    private static void doSort(short[] sArray, int n, int n2, @NotNull ShortOrdering shortOrdering) {
        short[] sArray2;
        int n3;
        int n4;
        if (n2 - n < 286) {
            DualPivotQuicksort.sort(sArray, n, n2, shortOrdering, true);
            return;
        }
        int[] nArray = new int[68];
        int n5 = 0;
        nArray[0] = n;
        int n6 = n;
        while (n6 < n2) {
            switch (shortOrdering.checkShort(sArray[n6], sArray[n6 + 1])) {
                case Ascending: {
                    while (++n6 <= n2 && shortOrdering.ascendingOrSame(sArray[n6 - 1], sArray[n6])) {
                    }
                    break;
                }
                case Descending: {
                    while (++n6 <= n2 && sArray[n6 - 1] >= sArray[n6]) {
                    }
                    n4 = nArray[n5] - 1;
                    n3 = n6;
                    while (++n4 < --n3) {
                        short s = sArray[n4];
                        sArray[n4] = sArray[n3];
                        sArray[n3] = s;
                    }
                    break;
                }
                default: {
                    n4 = 33;
                    while (++n6 <= n2 && sArray[n6 - 1] == sArray[n6]) {
                        if (--n4 != 0) continue;
                        DualPivotQuicksort.sort(sArray, n, n2, shortOrdering, true);
                        return;
                    }
                    break block0;
                }
            }
            if (++n5 == 67) {
                DualPivotQuicksort.sort(sArray, n, n2, shortOrdering, true);
                return;
            }
            nArray[n5] = n6;
        }
        if (nArray[n5] == n2++) {
            nArray[++n5] = n2;
        } else if (n5 == 1) {
            return;
        }
        n4 = 0;
        n3 = 1;
        while ((n3 <<= 1) < n5) {
            n4 = (byte)(n4 ^ 1);
        }
        if (n4 == 0) {
            sArray2 = sArray;
            sArray = new short[sArray2.length];
            n3 = n - 1;
            while (++n3 < n2) {
                sArray[n3] = sArray2[n3];
            }
        } else {
            sArray2 = new short[sArray.length];
        }
        while (n5 > 1) {
            int n7;
            int n8;
            n3 = 0;
            for (n8 = 0 + 2; n8 <= n5; n8 += 2) {
                int n9;
                n7 = nArray[n8];
                int n10 = nArray[n8 - 1];
                int n11 = n9 = nArray[n8 - 2];
                int n12 = n10;
                while (n9 < n7) {
                    sArray2[n9] = n12 >= n7 || n11 < n10 && shortOrdering.ascendingOrSame(sArray[n11], sArray[n12]) ? sArray[n11++] : sArray[n12++];
                    ++n9;
                }
                nArray[++n3] = n7;
            }
            if ((n5 & 1) != 0) {
                n8 = n2;
                n7 = nArray[n5 - 1];
                while (--n8 >= n7) {
                    sArray2[n8] = sArray[n8];
                }
                nArray[++n3] = n2;
            }
            short[] sArray3 = sArray;
            sArray = sArray2;
            sArray2 = sArray3;
            n5 = n3;
        }
    }

    private static void sort(short[] sArray, int n, int n2, @NotNull ShortOrdering shortOrdering, boolean bl) {
        int n3;
        int n4 = n2 - n + 1;
        if (n4 < 47) {
            if (bl) {
                int n5;
                int n6 = n5 = n;
                while (n5 < n2) {
                    short s = sArray[n5 + 1];
                    while (shortOrdering.ascending(s, sArray[n6])) {
                        sArray[n6 + 1] = sArray[n6];
                        if (n6-- != n) continue;
                    }
                    sArray[n6 + 1] = s;
                    n6 = ++n5;
                }
            } else {
                do {
                    if (n < n2) continue;
                    return;
                } while (shortOrdering.descendingOrSame(sArray[++n], sArray[n - 1]));
                int n7 = n;
                while (++n <= n2) {
                    short s = sArray[n7];
                    short s2 = sArray[n];
                    if (shortOrdering.ascending(s, s2)) {
                        s2 = s;
                        s = sArray[n];
                    }
                    while (shortOrdering.ascending(s, sArray[--n7])) {
                        sArray[n7 + 2] = sArray[n7];
                    }
                    sArray[++n7 + 1] = s;
                    while (shortOrdering.ascending(s2, sArray[--n7])) {
                        sArray[n7 + 1] = sArray[n7];
                    }
                    sArray[n7 + 1] = s2;
                    n7 = ++n;
                }
                n7 = sArray[n2];
                while (shortOrdering.ascending((short)n7, sArray[--n2])) {
                    sArray[n2 + 1] = sArray[n2];
                }
                sArray[n2 + 1] = n7;
            }
            return;
        }
        int n8 = (n4 >> 3) + (n4 >> 6) + 1;
        int n9 = n + n2 >>> 1;
        int n10 = n9 - n8;
        int n11 = n10 - n8;
        int n12 = n9 + n8;
        int n13 = n12 + n8;
        if (shortOrdering.ascending(sArray[n10], sArray[n11])) {
            n3 = sArray[n10];
            sArray[n10] = sArray[n11];
            sArray[n11] = n3;
        }
        if (shortOrdering.ascending(sArray[n9], sArray[n10])) {
            n3 = sArray[n9];
            sArray[n9] = sArray[n10];
            sArray[n10] = n3;
            if (shortOrdering.ascending((short)n3, sArray[n11])) {
                sArray[n10] = sArray[n11];
                sArray[n11] = n3;
            }
        }
        if (shortOrdering.ascending(sArray[n12], sArray[n9])) {
            n3 = sArray[n12];
            sArray[n12] = sArray[n9];
            sArray[n9] = n3;
            if (shortOrdering.ascending((short)n3, sArray[n10])) {
                sArray[n9] = sArray[n10];
                sArray[n10] = n3;
                if (shortOrdering.ascending((short)n3, sArray[n11])) {
                    sArray[n10] = sArray[n11];
                    sArray[n11] = n3;
                }
            }
        }
        if (shortOrdering.ascending(sArray[n13], sArray[n12])) {
            n3 = sArray[n13];
            sArray[n13] = sArray[n12];
            sArray[n12] = n3;
            if (shortOrdering.ascending((short)n3, sArray[n9])) {
                sArray[n12] = sArray[n9];
                sArray[n9] = n3;
                if (shortOrdering.ascending((short)n3, sArray[n10])) {
                    sArray[n9] = sArray[n10];
                    sArray[n10] = n3;
                    if (shortOrdering.ascending((short)n3, sArray[n11])) {
                        sArray[n10] = sArray[n11];
                        sArray[n11] = n3;
                    }
                }
            }
        }
        n3 = n;
        int n14 = n2;
        if (shortOrdering.different(sArray[n11], sArray[n10]) && shortOrdering.different(sArray[n10], sArray[n9]) && shortOrdering.different(sArray[n9], sArray[n12]) && shortOrdering.different(sArray[n12], sArray[n13])) {
            short s;
            short s3 = sArray[n10];
            short s4 = sArray[n12];
            sArray[n10] = sArray[n];
            sArray[n12] = sArray[n2];
            while (shortOrdering.ascending(sArray[++n3], s3)) {
            }
            while (shortOrdering.descending(sArray[--n14], s4)) {
            }
            int n15 = n3 - 1;
            block9: while (++n15 <= n14) {
                s = sArray[n15];
                if (shortOrdering.ascending(s, s3)) {
                    sArray[n15] = sArray[n3];
                    sArray[n3] = s;
                    ++n3;
                    continue;
                }
                if (!shortOrdering.descending(s, s4)) continue;
                while (shortOrdering.descending(sArray[n14], s4)) {
                    if (n14-- != n15) continue;
                    break block9;
                }
                if (shortOrdering.ascending(sArray[n14], s3)) {
                    sArray[n15] = sArray[n3];
                    sArray[n3] = sArray[n14];
                    ++n3;
                } else {
                    sArray[n15] = sArray[n14];
                }
                sArray[n14] = s;
                --n14;
            }
            sArray[n] = sArray[n3 - 1];
            sArray[n3 - 1] = s3;
            sArray[n2] = sArray[n14 + 1];
            sArray[n14 + 1] = s4;
            DualPivotQuicksort.sort(sArray, n, n3 - 2, shortOrdering, bl);
            DualPivotQuicksort.sort(sArray, n14 + 2, n2, shortOrdering, false);
            if (n3 < n11 && n13 < n14) {
                while (shortOrdering.same(sArray[n3], s3)) {
                    ++n3;
                }
                while (shortOrdering.same(sArray[n14], s4)) {
                    --n14;
                }
                n15 = n3 - 1;
                block13: while (++n15 <= n14) {
                    s = sArray[n15];
                    if (shortOrdering.same(s, s3)) {
                        sArray[n15] = sArray[n3];
                        sArray[n3] = s;
                        ++n3;
                        continue;
                    }
                    if (!shortOrdering.same(s, s4)) continue;
                    while (shortOrdering.same(sArray[n14], s4)) {
                        if (n14-- != n15) continue;
                        break block13;
                    }
                    if (shortOrdering.same(sArray[n14], s3)) {
                        sArray[n15] = sArray[n3];
                        sArray[n3] = s3;
                        ++n3;
                    } else {
                        sArray[n15] = sArray[n14];
                    }
                    sArray[n14] = s;
                    --n14;
                }
            }
            DualPivotQuicksort.sort(sArray, n3, n14, shortOrdering, false);
        } else {
            short s = sArray[n9];
            for (int i = n3; i <= n14; ++i) {
                if (shortOrdering.same(sArray[i], s)) continue;
                short s5 = sArray[i];
                if (shortOrdering.ascending(s5, s)) {
                    sArray[i] = sArray[n3];
                    sArray[n3] = s5;
                    ++n3;
                    continue;
                }
                while (shortOrdering.descending(sArray[n14], s)) {
                    --n14;
                }
                if (shortOrdering.ascending(sArray[n14], s)) {
                    sArray[i] = sArray[n3];
                    sArray[n3] = sArray[n14];
                    ++n3;
                } else {
                    sArray[i] = s;
                }
                sArray[n14] = s5;
                --n14;
            }
            DualPivotQuicksort.sort(sArray, n, n3 - 1, shortOrdering, bl);
            DualPivotQuicksort.sort(sArray, n14 + 1, n2, shortOrdering, false);
        }
    }

    public static void sort(@NotNull char[] cArray, @NotNull CharOrdering charOrdering) {
        DualPivotQuicksort.sort(cArray, 0, cArray.length - 1, charOrdering);
    }

    public static void sort(@NotNull char[] cArray, int n, int n2, @NotNull CharOrdering charOrdering) {
        if (n2 - n > 3200) {
            int n3;
            int n4 = n2 - n + 1;
            int[] nArray = new int[65536];
            char[] cArray2 = new char[Math.min(65536, n4)];
            int n5 = 0;
            for (n3 = n; n3 <= n2; ++n3) {
                char c = cArray[n3];
                int n6 = nArray[c];
                nArray[c] = n6 + 1;
                if (n6 != 0) continue;
                cArray2[n5++] = cArray[n3];
            }
            if (n5 < n4) {
                DualPivotQuicksort.doSort(cArray2, 0, n5 - 1, charOrdering);
                n3 = n;
                for (int i = 0; i < n5; ++i) {
                    char c = cArray2[i];
                    int n7 = nArray[c];
                    assert (n7 > 0);
                    while (--n7 >= 0) {
                        cArray[n3++] = c;
                    }
                }
                return;
            }
        }
        DualPivotQuicksort.doSort(cArray, n, n2, charOrdering);
    }

    private static void doSort(@NotNull char[] cArray, int n, int n2, @NotNull CharOrdering charOrdering) {
        char[] cArray2;
        int n3;
        int n4;
        if (n2 - n < 286) {
            DualPivotQuicksort.sort(cArray, n, n2, charOrdering, true);
            return;
        }
        int[] nArray = new int[68];
        int n5 = 0;
        nArray[0] = n;
        int n6 = n;
        while (n6 < n2) {
            switch (charOrdering.checkChar(cArray[n6], cArray[n6 + 1])) {
                case Ascending: {
                    while (++n6 <= n2 && charOrdering.ascendingOrSame(cArray[n6 - 1], cArray[n6])) {
                    }
                    break;
                }
                case Descending: {
                    while (++n6 <= n2 && charOrdering.descendingOrSame(cArray[n6 - 1], cArray[n6])) {
                    }
                    n4 = nArray[n5] - 1;
                    n3 = n6;
                    while (++n4 < --n3) {
                        char c = cArray[n4];
                        cArray[n4] = cArray[n3];
                        cArray[n3] = c;
                    }
                    break;
                }
                default: {
                    n4 = 33;
                    while (++n6 <= n2 && charOrdering.same(cArray[n6 - 1], cArray[n6])) {
                        if (--n4 != 0) continue;
                        DualPivotQuicksort.sort(cArray, n, n2, charOrdering, true);
                        return;
                    }
                    break block0;
                }
            }
            if (++n5 == 67) {
                DualPivotQuicksort.sort(cArray, n, n2, charOrdering, true);
                return;
            }
            nArray[n5] = n6;
        }
        if (nArray[n5] == n2++) {
            nArray[++n5] = n2;
        } else if (n5 == 1) {
            return;
        }
        n4 = 0;
        n3 = 1;
        while ((n3 <<= 1) < n5) {
            n4 = (byte)(n4 ^ 1);
        }
        if (n4 == 0) {
            cArray2 = cArray;
            cArray = new char[cArray2.length];
            n3 = n - 1;
            while (++n3 < n2) {
                cArray[n3] = cArray2[n3];
            }
        } else {
            cArray2 = new char[cArray.length];
        }
        while (n5 > 1) {
            int n7;
            int n8;
            n3 = 0;
            for (n8 = 0 + 2; n8 <= n5; n8 += 2) {
                int n9;
                n7 = nArray[n8];
                int n10 = nArray[n8 - 1];
                int n11 = n9 = nArray[n8 - 2];
                int n12 = n10;
                while (n9 < n7) {
                    cArray2[n9] = n12 >= n7 || n11 < n10 && charOrdering.ascendingOrSame(cArray[n11], cArray[n12]) ? cArray[n11++] : cArray[n12++];
                    ++n9;
                }
                nArray[++n3] = n7;
            }
            if ((n5 & 1) != 0) {
                n8 = n2;
                n7 = nArray[n5 - 1];
                while (--n8 >= n7) {
                    cArray2[n8] = cArray[n8];
                }
                nArray[++n3] = n2;
            }
            char[] cArray3 = cArray;
            cArray = cArray2;
            cArray2 = cArray3;
            n5 = n3;
        }
    }

    private static void sort(@NotNull char[] cArray, int n, int n2, @NotNull CharOrdering charOrdering, boolean bl) {
        int n3;
        int n4 = n2 - n + 1;
        if (n4 < 47) {
            if (bl) {
                int n5;
                int n6 = n5 = n;
                while (n5 < n2) {
                    char c = cArray[n5 + 1];
                    while (charOrdering.ascending(c, cArray[n6])) {
                        cArray[n6 + 1] = cArray[n6];
                        if (n6-- != n) continue;
                    }
                    cArray[n6 + 1] = c;
                    n6 = ++n5;
                }
            } else {
                do {
                    if (n < n2) continue;
                    return;
                } while (charOrdering.descendingOrSame(cArray[++n], cArray[n - 1]));
                int n7 = n;
                while (++n <= n2) {
                    char c = cArray[n7];
                    char c2 = cArray[n];
                    if (charOrdering.ascending(c, c2)) {
                        c2 = c;
                        c = cArray[n];
                    }
                    while (charOrdering.ascending(c, cArray[--n7])) {
                        cArray[n7 + 2] = cArray[n7];
                    }
                    cArray[++n7 + 1] = c;
                    while (charOrdering.ascending(c2, cArray[--n7])) {
                        cArray[n7 + 1] = cArray[n7];
                    }
                    cArray[n7 + 1] = c2;
                    n7 = ++n;
                }
                n7 = cArray[n2];
                while (charOrdering.ascending((char)n7, cArray[--n2])) {
                    cArray[n2 + 1] = cArray[n2];
                }
                cArray[n2 + 1] = n7;
            }
            return;
        }
        int n8 = (n4 >> 3) + (n4 >> 6) + 1;
        int n9 = n + n2 >>> 1;
        int n10 = n9 - n8;
        int n11 = n10 - n8;
        int n12 = n9 + n8;
        int n13 = n12 + n8;
        if (charOrdering.ascending(cArray[n10], cArray[n11])) {
            n3 = cArray[n10];
            cArray[n10] = cArray[n11];
            cArray[n11] = n3;
        }
        if (charOrdering.ascending(cArray[n9], cArray[n10])) {
            n3 = cArray[n9];
            cArray[n9] = cArray[n10];
            cArray[n10] = n3;
            if (charOrdering.ascending((char)n3, cArray[n11])) {
                cArray[n10] = cArray[n11];
                cArray[n11] = n3;
            }
        }
        if (charOrdering.ascending(cArray[n12], cArray[n9])) {
            n3 = cArray[n12];
            cArray[n12] = cArray[n9];
            cArray[n9] = n3;
            if (charOrdering.ascending((char)n3, cArray[n10])) {
                cArray[n9] = cArray[n10];
                cArray[n10] = n3;
                if (charOrdering.ascending((char)n3, cArray[n11])) {
                    cArray[n10] = cArray[n11];
                    cArray[n11] = n3;
                }
            }
        }
        if (charOrdering.ascending(cArray[n13], cArray[n12])) {
            n3 = cArray[n13];
            cArray[n13] = cArray[n12];
            cArray[n12] = n3;
            if (charOrdering.ascending((char)n3, cArray[n9])) {
                cArray[n12] = cArray[n9];
                cArray[n9] = n3;
                if (charOrdering.ascending((char)n3, cArray[n10])) {
                    cArray[n9] = cArray[n10];
                    cArray[n10] = n3;
                    if (charOrdering.ascending((char)n3, cArray[n11])) {
                        cArray[n10] = cArray[n11];
                        cArray[n11] = n3;
                    }
                }
            }
        }
        n3 = n;
        int n14 = n2;
        if (charOrdering.different(cArray[n11], cArray[n10]) && charOrdering.different(cArray[n10], cArray[n9]) && charOrdering.different(cArray[n9], cArray[n12]) && charOrdering.different(cArray[n12], cArray[n13])) {
            char c;
            char c3 = cArray[n10];
            char c4 = cArray[n12];
            cArray[n10] = cArray[n];
            cArray[n12] = cArray[n2];
            while (charOrdering.ascending(cArray[++n3], c3)) {
            }
            while (charOrdering.descending(cArray[--n14], c4)) {
            }
            int n15 = n3 - 1;
            block9: while (++n15 <= n14) {
                c = cArray[n15];
                if (charOrdering.ascending(c, c3)) {
                    cArray[n15] = cArray[n3];
                    cArray[n3] = c;
                    ++n3;
                    continue;
                }
                if (!charOrdering.descending(c, c4)) continue;
                while (charOrdering.descending(cArray[n14], c4)) {
                    if (n14-- != n15) continue;
                    break block9;
                }
                if (charOrdering.ascending(cArray[n14], c3)) {
                    cArray[n15] = cArray[n3];
                    cArray[n3] = cArray[n14];
                    ++n3;
                } else {
                    cArray[n15] = cArray[n14];
                }
                cArray[n14] = c;
                --n14;
            }
            cArray[n] = cArray[n3 - 1];
            cArray[n3 - 1] = c3;
            cArray[n2] = cArray[n14 + 1];
            cArray[n14 + 1] = c4;
            DualPivotQuicksort.sort(cArray, n, n3 - 2, charOrdering, bl);
            DualPivotQuicksort.sort(cArray, n14 + 2, n2, charOrdering, false);
            if (n3 < n11 && n13 < n14) {
                while (charOrdering.same(cArray[n3], c3)) {
                    ++n3;
                }
                while (charOrdering.same(cArray[n14], c4)) {
                    --n14;
                }
                n15 = n3 - 1;
                block13: while (++n15 <= n14) {
                    c = cArray[n15];
                    if (charOrdering.same(c, c3)) {
                        cArray[n15] = cArray[n3];
                        cArray[n3] = c;
                        ++n3;
                        continue;
                    }
                    if (!charOrdering.same(c, c4)) continue;
                    while (charOrdering.same(cArray[n14], c4)) {
                        if (n14-- != n15) continue;
                        break block13;
                    }
                    if (charOrdering.same(cArray[n14], c3)) {
                        cArray[n15] = cArray[n3];
                        cArray[n3] = c3;
                        ++n3;
                    } else {
                        cArray[n15] = cArray[n14];
                    }
                    cArray[n14] = c;
                    --n14;
                }
            }
            DualPivotQuicksort.sort(cArray, n3, n14, charOrdering, false);
        } else {
            char c = cArray[n9];
            for (int i = n3; i <= n14; ++i) {
                if (charOrdering.same(cArray[i], c)) continue;
                char c5 = cArray[i];
                if (charOrdering.ascending(c5, c)) {
                    cArray[i] = cArray[n3];
                    cArray[n3] = c5;
                    ++n3;
                    continue;
                }
                while (charOrdering.descending(cArray[n14], c)) {
                    --n14;
                }
                if (charOrdering.ascending(cArray[n14], c)) {
                    cArray[i] = cArray[n3];
                    cArray[n3] = cArray[n14];
                    ++n3;
                } else {
                    cArray[i] = c;
                }
                cArray[n14] = c5;
                --n14;
            }
            DualPivotQuicksort.sort(cArray, n, n3 - '\u0001', charOrdering, bl);
            DualPivotQuicksort.sort(cArray, n14 + 1, n2, charOrdering, false);
        }
    }

    public static void sort(@NotNull byte[] byArray, @NotNull ByteOrdering byteOrdering) {
        DualPivotQuicksort.sort(byArray, 0, byArray.length - 1, byteOrdering);
    }

    public static void sort(@NotNull byte[] byArray, int n, int n2, @NotNull ByteOrdering byteOrdering) {
        if (n2 - n > 29) {
            int n3;
            int n4 = n2 - n + 1;
            int[] nArray = new int[256];
            byte[] byArray2 = new byte[Math.min(256, n4)];
            int n5 = 0;
            for (n3 = n; n3 <= n2; ++n3) {
                int n6 = byArray[n3] - -128;
                int n7 = nArray[n6];
                nArray[n6] = n7 + 1;
                if (n7 != 0) continue;
                byArray2[n5++] = byArray[n3];
            }
            if (n5 < n4) {
                if (n5 > 29) {
                    FastSortByte.quickSort(MutableByteIndexable.viewArray(byArray2, 0, n5), byteOrdering);
                } else {
                    DualPivotQuicksort.insertionSort(byArray2, 0, n5 - 1, byteOrdering);
                }
                n3 = n;
                for (int i = 0; i < n5; ++i) {
                    byte by = byArray2[i];
                    int n8 = nArray[by - -128];
                    assert (n8 > 0);
                    while (--n8 >= 0) {
                        byArray[n3++] = by;
                    }
                }
                assert (n3 == n4);
                return;
            }
        }
        DualPivotQuicksort.insertionSort(byArray, n, n2, byteOrdering);
    }

    private static void insertionSort(@NotNull byte[] byArray, int n, int n2, @NotNull ByteOrdering byteOrdering) {
        int n3;
        int n4 = n3 = n;
        while (n3 < n2) {
            byte by = byArray[n3 + 1];
            while (byteOrdering.ascending(by, byArray[n4])) {
                byArray[n4 + 1] = byArray[n4];
                if (n4-- != n) continue;
            }
            byArray[n4 + 1] = by;
            n4 = ++n3;
        }
    }

    public static void sort(@NotNull float[] fArray, @NotNull FloatOrdering floatOrdering) {
        DualPivotQuicksort.sort(fArray, 0, fArray.length - 1, floatOrdering);
    }

    public static void sort(@NotNull float[] fArray, int n, int n2, @NotNull FloatOrdering floatOrdering) {
        float[] fArray2;
        int n3;
        int n4;
        if (n2 - n < 286) {
            DualPivotQuicksort.sort(fArray, n, n2, floatOrdering, true);
            return;
        }
        int[] nArray = new int[68];
        int n5 = 0;
        nArray[0] = n;
        int n6 = n;
        while (n6 < n2) {
            switch (floatOrdering.checkFloat(fArray[n6], fArray[n6 + 1])) {
                case Ascending: {
                    while (++n6 <= n2 && floatOrdering.ascendingOrSame(fArray[n6 - 1], fArray[n6])) {
                    }
                    break;
                }
                case Descending: {
                    while (++n6 <= n2 && fArray[n6 - 1] >= fArray[n6]) {
                    }
                    n4 = nArray[n5] - 1;
                    n3 = n6;
                    while (++n4 < --n3) {
                        float f = fArray[n4];
                        fArray[n4] = fArray[n3];
                        fArray[n3] = f;
                    }
                    break;
                }
                default: {
                    n4 = 33;
                    while (++n6 <= n2 && fArray[n6 - 1] == fArray[n6]) {
                        if (--n4 != 0) continue;
                        DualPivotQuicksort.sort(fArray, n, n2, floatOrdering, true);
                        return;
                    }
                    break block0;
                }
            }
            if (++n5 == 67) {
                DualPivotQuicksort.sort(fArray, n, n2, floatOrdering, true);
                return;
            }
            nArray[n5] = n6;
        }
        if (nArray[n5] == n2++) {
            nArray[++n5] = n2;
        } else if (n5 == 1) {
            return;
        }
        n4 = 0;
        n3 = 1;
        while ((n3 <<= 1) < n5) {
            n4 = (byte)(n4 ^ 1);
        }
        if (n4 == 0) {
            fArray2 = fArray;
            fArray = new float[fArray2.length];
            n3 = n - 1;
            while (++n3 < n2) {
                fArray[n3] = fArray2[n3];
            }
        } else {
            fArray2 = new float[fArray.length];
        }
        while (n5 > 1) {
            int n7;
            int n8;
            n3 = 0;
            for (n8 = 0 + 2; n8 <= n5; n8 += 2) {
                int n9;
                n7 = nArray[n8];
                int n10 = nArray[n8 - 1];
                int n11 = n9 = nArray[n8 - 2];
                int n12 = n10;
                while (n9 < n7) {
                    fArray2[n9] = n12 >= n7 || n11 < n10 && floatOrdering.ascendingOrSame(fArray[n11], fArray[n12]) ? fArray[n11++] : fArray[n12++];
                    ++n9;
                }
                nArray[++n3] = n7;
            }
            if ((n5 & 1) != 0) {
                n8 = n2;
                n7 = nArray[n5 - 1];
                while (--n8 >= n7) {
                    fArray2[n8] = fArray[n8];
                }
                nArray[++n3] = n2;
            }
            float[] fArray3 = fArray;
            fArray = fArray2;
            fArray2 = fArray3;
            n5 = n3;
        }
    }

    private static void sort(@NotNull float[] fArray, int n, int n2, @NotNull FloatOrdering floatOrdering, boolean bl) {
        float f;
        int n3 = n2 - n + 1;
        if (n3 < 47) {
            if (bl) {
                int n4;
                int n5 = n4 = n;
                while (n4 < n2) {
                    float f2 = fArray[n4 + 1];
                    while (floatOrdering.ascending(f2, fArray[n5])) {
                        fArray[n5 + 1] = fArray[n5];
                        if (n5-- != n) continue;
                    }
                    fArray[n5 + 1] = f2;
                    n5 = ++n4;
                }
            } else {
                do {
                    if (n < n2) continue;
                    return;
                } while (floatOrdering.descendingOrSame(fArray[++n], fArray[n - 1]));
                int n6 = n;
                while (++n <= n2) {
                    float f3 = fArray[n6];
                    float f4 = fArray[n];
                    if (floatOrdering.ascending(f3, f4)) {
                        f4 = f3;
                        f3 = fArray[n];
                    }
                    while (floatOrdering.ascending(f3, fArray[--n6])) {
                        fArray[n6 + 2] = fArray[n6];
                    }
                    fArray[++n6 + 1] = f3;
                    while (floatOrdering.ascending(f4, fArray[--n6])) {
                        fArray[n6 + 1] = fArray[n6];
                    }
                    fArray[n6 + 1] = f4;
                    n6 = ++n;
                }
                float f5 = fArray[n2];
                while (floatOrdering.ascending(f5, fArray[--n2])) {
                    fArray[n2 + 1] = fArray[n2];
                }
                fArray[n2 + 1] = f5;
            }
            return;
        }
        int n7 = (n3 >> 3) + (n3 >> 6) + 1;
        int n8 = n + n2 >>> 1;
        int n9 = n8 - n7;
        int n10 = n9 - n7;
        int n11 = n8 + n7;
        int n12 = n11 + n7;
        if (floatOrdering.ascending(fArray[n9], fArray[n10])) {
            f = fArray[n9];
            fArray[n9] = fArray[n10];
            fArray[n10] = f;
        }
        if (floatOrdering.ascending(fArray[n8], fArray[n9])) {
            f = fArray[n8];
            fArray[n8] = fArray[n9];
            fArray[n9] = f;
            if (floatOrdering.ascending(f, fArray[n10])) {
                fArray[n9] = fArray[n10];
                fArray[n10] = f;
            }
        }
        if (floatOrdering.ascending(fArray[n11], fArray[n8])) {
            f = fArray[n11];
            fArray[n11] = fArray[n8];
            fArray[n8] = f;
            if (floatOrdering.ascending(f, fArray[n9])) {
                fArray[n8] = fArray[n9];
                fArray[n9] = f;
                if (floatOrdering.ascending(f, fArray[n10])) {
                    fArray[n9] = fArray[n10];
                    fArray[n10] = f;
                }
            }
        }
        if (floatOrdering.ascending(fArray[n12], fArray[n11])) {
            f = fArray[n12];
            fArray[n12] = fArray[n11];
            fArray[n11] = f;
            if (floatOrdering.ascending(f, fArray[n8])) {
                fArray[n11] = fArray[n8];
                fArray[n8] = f;
                if (floatOrdering.ascending(f, fArray[n9])) {
                    fArray[n8] = fArray[n9];
                    fArray[n9] = f;
                    if (floatOrdering.ascending(f, fArray[n10])) {
                        fArray[n9] = fArray[n10];
                        fArray[n10] = f;
                    }
                }
            }
        }
        int n13 = n;
        int n14 = n2;
        if (floatOrdering.different(fArray[n10], fArray[n9]) && floatOrdering.different(fArray[n9], fArray[n8]) && floatOrdering.different(fArray[n8], fArray[n11]) && floatOrdering.different(fArray[n11], fArray[n12])) {
            float f6;
            float f7 = fArray[n9];
            float f8 = fArray[n11];
            fArray[n9] = fArray[n];
            fArray[n11] = fArray[n2];
            while (floatOrdering.ascending(fArray[++n13], f7)) {
            }
            while (floatOrdering.descending(fArray[--n14], f8)) {
            }
            int n15 = n13 - 1;
            block9: while (++n15 <= n14) {
                f6 = fArray[n15];
                if (floatOrdering.ascending(f6, f7)) {
                    fArray[n15] = fArray[n13];
                    fArray[n13] = f6;
                    ++n13;
                    continue;
                }
                if (!floatOrdering.descending(f6, f8)) continue;
                while (floatOrdering.descending(fArray[n14], f8)) {
                    if (n14-- != n15) continue;
                    break block9;
                }
                if (floatOrdering.ascending(fArray[n14], f7)) {
                    fArray[n15] = fArray[n13];
                    fArray[n13] = fArray[n14];
                    ++n13;
                } else {
                    fArray[n15] = fArray[n14];
                }
                fArray[n14] = f6;
                --n14;
            }
            fArray[n] = fArray[n13 - 1];
            fArray[n13 - 1] = f7;
            fArray[n2] = fArray[n14 + 1];
            fArray[n14 + 1] = f8;
            DualPivotQuicksort.sort(fArray, n, n13 - 2, floatOrdering, bl);
            DualPivotQuicksort.sort(fArray, n14 + 2, n2, floatOrdering, false);
            if (n13 < n10 && n12 < n14) {
                while (floatOrdering.same(fArray[n13], f7)) {
                    ++n13;
                }
                while (floatOrdering.same(fArray[n14], f8)) {
                    --n14;
                }
                n15 = n13 - 1;
                block13: while (++n15 <= n14) {
                    f6 = fArray[n15];
                    if (floatOrdering.same(f6, f7)) {
                        fArray[n15] = fArray[n13];
                        fArray[n13] = f6;
                        ++n13;
                        continue;
                    }
                    if (!floatOrdering.same(f6, f8)) continue;
                    while (floatOrdering.same(fArray[n14], f8)) {
                        if (n14-- != n15) continue;
                        break block13;
                    }
                    if (floatOrdering.same(fArray[n14], f7)) {
                        fArray[n15] = fArray[n13];
                        fArray[n13] = fArray[n14];
                        ++n13;
                    } else {
                        fArray[n15] = fArray[n14];
                    }
                    fArray[n14] = f6;
                    --n14;
                }
            }
            DualPivotQuicksort.sort(fArray, n13, n14, floatOrdering, false);
        } else {
            float f9 = fArray[n8];
            for (int i = n13; i <= n14; ++i) {
                if (floatOrdering.same(fArray[i], f9)) continue;
                float f10 = fArray[i];
                if (floatOrdering.ascending(f10, f9)) {
                    fArray[i] = fArray[n13];
                    fArray[n13] = f10;
                    ++n13;
                    continue;
                }
                while (floatOrdering.descending(fArray[n14], f9)) {
                    --n14;
                }
                if (floatOrdering.ascending(fArray[n14], f9)) {
                    fArray[i] = fArray[n13];
                    fArray[n13] = fArray[n14];
                    ++n13;
                } else {
                    fArray[i] = fArray[n14];
                }
                fArray[n14] = f10;
                --n14;
            }
            DualPivotQuicksort.sort(fArray, n, n13 - 1, floatOrdering, bl);
            DualPivotQuicksort.sort(fArray, n14 + 1, n2, floatOrdering, false);
        }
    }

    public static void sort(@NotNull double[] dArray, @NotNull DoubleOrdering doubleOrdering) {
        DualPivotQuicksort.sort(dArray, 0, dArray.length - 1, doubleOrdering);
    }

    public static void sort(double[] dArray, int n, int n2, @NotNull DoubleOrdering doubleOrdering) {
        double[] dArray2;
        int n3;
        int n4;
        if (n2 - n < 286) {
            DualPivotQuicksort.sort(dArray, n, n2, doubleOrdering, true);
            return;
        }
        int[] nArray = new int[68];
        int n5 = 0;
        nArray[0] = n;
        int n6 = n;
        while (n6 < n2) {
            switch (doubleOrdering.checkDouble(dArray[n6], dArray[n6 + 1])) {
                case Ascending: {
                    while (++n6 <= n2 && doubleOrdering.ascendingOrSame(dArray[n6 - 1], dArray[n6])) {
                    }
                    break;
                }
                case Descending: {
                    while (++n6 <= n2 && doubleOrdering.descendingOrSame(dArray[n6 - 1], dArray[n6])) {
                    }
                    n4 = nArray[n5] - 1;
                    n3 = n6;
                    while (++n4 < --n3) {
                        double d = dArray[n4];
                        dArray[n4] = dArray[n3];
                        dArray[n3] = d;
                    }
                    break;
                }
                default: {
                    n4 = 33;
                    while (++n6 <= n2 && doubleOrdering.same(dArray[n6 - 1], dArray[n6])) {
                        if (--n4 != 0) continue;
                        DualPivotQuicksort.sort(dArray, n, n2, doubleOrdering, true);
                        return;
                    }
                    break block0;
                }
            }
            if (++n5 == 67) {
                DualPivotQuicksort.sort(dArray, n, n2, doubleOrdering, true);
                return;
            }
            nArray[n5] = n6;
        }
        if (nArray[n5] == n2++) {
            nArray[++n5] = n2;
        } else if (n5 == 1) {
            return;
        }
        n4 = 0;
        n3 = 1;
        while ((n3 <<= 1) < n5) {
            n4 = (byte)(n4 ^ 1);
        }
        if (n4 == 0) {
            dArray2 = dArray;
            dArray = new double[dArray2.length];
            n3 = n - 1;
            while (++n3 < n2) {
                dArray[n3] = dArray2[n3];
            }
        } else {
            dArray2 = new double[dArray.length];
        }
        while (n5 > 1) {
            int n7;
            int n8;
            n3 = 0;
            for (n8 = 0 + 2; n8 <= n5; n8 += 2) {
                int n9;
                n7 = nArray[n8];
                int n10 = nArray[n8 - 1];
                int n11 = n9 = nArray[n8 - 2];
                int n12 = n10;
                while (n9 < n7) {
                    dArray2[n9] = n12 >= n7 || n11 < n10 && doubleOrdering.ascendingOrSame(dArray[n11], dArray[n12]) ? dArray[n11++] : dArray[n12++];
                    ++n9;
                }
                nArray[++n3] = n7;
            }
            if ((n5 & 1) != 0) {
                n8 = n2;
                n7 = nArray[n5 - 1];
                while (--n8 >= n7) {
                    dArray2[n8] = dArray[n8];
                }
                nArray[++n3] = n2;
            }
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
            n5 = n3;
        }
    }

    private static void sort(@NotNull double[] dArray, int n, int n2, @NotNull DoubleOrdering doubleOrdering, boolean bl) {
        double d;
        int n3 = n2 - n + 1;
        if (n3 < 47) {
            if (bl) {
                int n4;
                int n5 = n4 = n;
                while (n4 < n2) {
                    double d2 = dArray[n4 + 1];
                    while (doubleOrdering.ascending(d2, dArray[n5])) {
                        dArray[n5 + 1] = dArray[n5];
                        if (n5-- != n) continue;
                    }
                    dArray[n5 + 1] = d2;
                    n5 = ++n4;
                }
            } else {
                do {
                    if (n < n2) continue;
                    return;
                } while (doubleOrdering.descendingOrSame(dArray[++n], dArray[n - 1]));
                int n6 = n;
                while (++n <= n2) {
                    double d3 = dArray[n6];
                    double d4 = dArray[n];
                    if (doubleOrdering.ascending(d3, d4)) {
                        d4 = d3;
                        d3 = dArray[n];
                    }
                    while (doubleOrdering.ascending(d3, dArray[--n6])) {
                        dArray[n6 + 2] = dArray[n6];
                    }
                    dArray[++n6 + 1] = d3;
                    while (doubleOrdering.ascending(d4, dArray[--n6])) {
                        dArray[n6 + 1] = dArray[n6];
                    }
                    dArray[n6 + 1] = d4;
                    n6 = ++n;
                }
                double d5 = dArray[n2];
                while (doubleOrdering.ascending(d5, dArray[--n2])) {
                    dArray[n2 + 1] = dArray[n2];
                }
                dArray[n2 + 1] = d5;
            }
            return;
        }
        int n7 = (n3 >> 3) + (n3 >> 6) + 1;
        int n8 = n + n2 >>> 1;
        int n9 = n8 - n7;
        int n10 = n9 - n7;
        int n11 = n8 + n7;
        int n12 = n11 + n7;
        if (doubleOrdering.ascending(dArray[n9], dArray[n10])) {
            d = dArray[n9];
            dArray[n9] = dArray[n10];
            dArray[n10] = d;
        }
        if (doubleOrdering.ascending(dArray[n8], dArray[n9])) {
            d = dArray[n8];
            dArray[n8] = dArray[n9];
            dArray[n9] = d;
            if (doubleOrdering.ascending(d, dArray[n10])) {
                dArray[n9] = dArray[n10];
                dArray[n10] = d;
            }
        }
        if (doubleOrdering.ascending(dArray[n11], dArray[n8])) {
            d = dArray[n11];
            dArray[n11] = dArray[n8];
            dArray[n8] = d;
            if (doubleOrdering.ascending(d, dArray[n9])) {
                dArray[n8] = dArray[n9];
                dArray[n9] = d;
                if (doubleOrdering.ascending(d, dArray[n10])) {
                    dArray[n9] = dArray[n10];
                    dArray[n10] = d;
                }
            }
        }
        if (doubleOrdering.ascending(dArray[n12], dArray[n11])) {
            d = dArray[n12];
            dArray[n12] = dArray[n11];
            dArray[n11] = d;
            if (doubleOrdering.ascending(d, dArray[n8])) {
                dArray[n11] = dArray[n8];
                dArray[n8] = d;
                if (doubleOrdering.ascending(d, dArray[n9])) {
                    dArray[n8] = dArray[n9];
                    dArray[n9] = d;
                    if (doubleOrdering.ascending(d, dArray[n10])) {
                        dArray[n9] = dArray[n10];
                        dArray[n10] = d;
                    }
                }
            }
        }
        int n13 = n;
        int n14 = n2;
        if (doubleOrdering.same(dArray[n10], dArray[n9]) && doubleOrdering.same(dArray[n9], dArray[n8]) && doubleOrdering.same(dArray[n8], dArray[n11]) && doubleOrdering.same(dArray[n11], dArray[n12])) {
            double d6;
            double d7 = dArray[n9];
            double d8 = dArray[n11];
            dArray[n9] = dArray[n];
            dArray[n11] = dArray[n2];
            while (doubleOrdering.ascending(dArray[++n13], d7)) {
            }
            while (doubleOrdering.descending(dArray[--n14], d8)) {
            }
            int n15 = n13 - 1;
            block9: while (++n15 <= n14) {
                d6 = dArray[n15];
                if (doubleOrdering.ascending(d6, d7)) {
                    dArray[n15] = dArray[n13];
                    dArray[n13] = d6;
                    ++n13;
                    continue;
                }
                if (!doubleOrdering.descending(d6, d8)) continue;
                while (doubleOrdering.descending(dArray[n14], d8)) {
                    if (n14-- != n15) continue;
                    break block9;
                }
                if (doubleOrdering.ascending(dArray[n14], d7)) {
                    dArray[n15] = dArray[n13];
                    dArray[n13] = dArray[n14];
                    ++n13;
                } else {
                    dArray[n15] = dArray[n14];
                }
                dArray[n14] = d6;
                --n14;
            }
            dArray[n] = dArray[n13 - 1];
            dArray[n13 - 1] = d7;
            dArray[n2] = dArray[n14 + 1];
            dArray[n14 + 1] = d8;
            DualPivotQuicksort.sort(dArray, n, n13 - 2, doubleOrdering, bl);
            DualPivotQuicksort.sort(dArray, n14 + 2, n2, doubleOrdering, false);
            if (n13 < n10 && n12 < n14) {
                while (doubleOrdering.same(dArray[n13], d7)) {
                    ++n13;
                }
                while (doubleOrdering.same(dArray[n14], d8)) {
                    --n14;
                }
                n15 = n13 - 1;
                block13: while (++n15 <= n14) {
                    d6 = dArray[n15];
                    if (doubleOrdering.same(d6, d7)) {
                        dArray[n15] = dArray[n13];
                        dArray[n13] = d6;
                        ++n13;
                        continue;
                    }
                    if (!doubleOrdering.same(d6, d8)) continue;
                    while (doubleOrdering.same(dArray[n14], d8)) {
                        if (n14-- != n15) continue;
                        break block13;
                    }
                    if (doubleOrdering.same(dArray[n14], d7)) {
                        dArray[n15] = dArray[n13];
                        dArray[n13] = dArray[n14];
                        ++n13;
                    } else {
                        dArray[n15] = dArray[n14];
                    }
                    dArray[n14] = d6;
                    --n14;
                }
            }
            DualPivotQuicksort.sort(dArray, n13, n14, doubleOrdering, false);
        } else {
            double d9 = dArray[n8];
            for (int i = n13; i <= n14; ++i) {
                if (doubleOrdering.same(dArray[i], d9)) continue;
                double d10 = dArray[i];
                if (doubleOrdering.ascending(d10, d9)) {
                    dArray[i] = dArray[n13];
                    dArray[n13] = d10;
                    ++n13;
                    continue;
                }
                while (doubleOrdering.descending(dArray[n14], d9)) {
                    --n14;
                }
                if (doubleOrdering.ascending(dArray[n14], d9)) {
                    dArray[i] = dArray[n13];
                    dArray[n13] = dArray[n14];
                    ++n13;
                } else {
                    dArray[i] = dArray[n14];
                }
                dArray[n14] = d10;
                --n14;
            }
            DualPivotQuicksort.sort(dArray, n, n13 - 1, doubleOrdering, bl);
            DualPivotQuicksort.sort(dArray, n14 + 1, n2, doubleOrdering, false);
        }
    }

    static <T> void sort(@NotNull MutableIndexable<T> mutableIndexable, @NotNull Ordering<? super T> ordering) {
        MutableIndexable<Object> mutableIndexable2;
        int n;
        int n2 = mutableIndexable.size() - 1;
        if (n2 - 0 < 286) {
            DualPivotQuicksort.sort(mutableIndexable, ordering, true);
            return;
        }
        int[] nArray = new int[68];
        int n3 = 0;
        nArray[0] = 0;
        int n4 = 0;
        while (n4 < n2) {
            switch (ordering.check(mutableIndexable.get(n4), mutableIndexable.get(n4 + 1))) {
                case Ascending: {
                    while (++n4 <= n2 && ordering.ascendingOrSame(mutableIndexable.get(n4 - 1), mutableIndexable.get(n4))) {
                    }
                    break;
                }
                case Descending: {
                    while (++n4 <= n2 && ordering.descendingOrSame(mutableIndexable.get(n4 - 1), mutableIndexable.get(n4))) {
                    }
                    mutableIndexable.revert(nArray[n3] - 1, n4);
                    break;
                }
                default: {
                    n = 33;
                    while (++n4 <= n2 && ordering.same(mutableIndexable.get(n4 - 1), mutableIndexable.get(n4))) {
                        if (--n != 0) continue;
                        DualPivotQuicksort.sort(mutableIndexable, ordering, true);
                        return;
                    }
                    break block0;
                }
            }
            if (++n3 == 67) {
                DualPivotQuicksort.sort(mutableIndexable, ordering, true);
                return;
            }
            nArray[n3] = n4;
        }
        if (nArray[n3] == n2++) {
            nArray[++n3] = n2;
        } else if (n3 == 1) {
            return;
        }
        n = 0;
        int n5 = 1;
        while ((n5 <<= 1) < n3) {
            n = (byte)(n ^ 1);
        }
        if (n == 0) {
            mutableIndexable2 = mutableIndexable;
            mutableIndexable = mutableIndexable2.getCopy();
        } else {
            mutableIndexable2 = MutableIndexable.nulled(mutableIndexable.size());
        }
        while (n3 > 1) {
            int n6;
            int n7;
            n5 = 0;
            for (n7 = 0 + 2; n7 <= n3; n7 += 2) {
                int n8;
                n6 = nArray[n7];
                int n9 = nArray[n7 - 1];
                int n10 = n8 = nArray[n7 - 2];
                int n11 = n9;
                while (n8 < n6) {
                    if (n11 >= n6 || n10 < n9 && ordering.ascending(mutableIndexable.get(n10), mutableIndexable.get(n11))) {
                        mutableIndexable2.set(n8, mutableIndexable.get(n10++));
                    } else {
                        mutableIndexable2.set(n8, mutableIndexable.get(n11++));
                    }
                    ++n8;
                }
                nArray[++n5] = n6;
            }
            if ((n3 & 1) != 0) {
                n7 = n2;
                n6 = nArray[n3 - 1];
                while (--n7 >= n6) {
                    mutableIndexable2.set(n7, mutableIndexable.get(n7));
                }
                nArray[++n5] = n2;
            }
            MutableIndexable<T> mutableIndexable3 = mutableIndexable;
            mutableIndexable = mutableIndexable2;
            mutableIndexable2 = mutableIndexable3;
            n3 = n5;
        }
    }

    private static <T> void sort(@NotNull MutableIndexable<T> mutableIndexable, @NotNull Ordering<? super T> ordering, boolean bl) {
        Object t;
        int n = mutableIndexable.size();
        int n2 = 0;
        int n3 = n - 1;
        if (n < 47) {
            if (bl) {
                int n4;
                int n5 = n4 = n2;
                while (n4 < n3) {
                    Object t2 = mutableIndexable.get(n4 + 1);
                    while (ordering.ascending(t2, mutableIndexable.get(n5))) {
                        mutableIndexable.set(n5 + 1, mutableIndexable.get(n5));
                        if (n5-- != n2) continue;
                    }
                    mutableIndexable.set(n5 + 1, t2);
                    n5 = ++n4;
                }
            } else {
                do {
                    if (n2 < n3) continue;
                    return;
                } while (ordering.descendingOrSame(mutableIndexable.get(++n2), mutableIndexable.get(n2 - 1)));
                int n6 = n2;
                while (++n2 <= n3) {
                    Object t3;
                    Object t4 = mutableIndexable.get(n6);
                    if (ordering.ascending(t4, t3 = mutableIndexable.get(n2))) {
                        t3 = t4;
                        t4 = mutableIndexable.get(n2);
                    }
                    while (--n6 >= 0 && ordering.ascending(t4, mutableIndexable.get(n6))) {
                        mutableIndexable.set(n6 + 2, mutableIndexable.get(n6));
                    }
                    mutableIndexable.set(++n6 + 1, t4);
                    while (--n6 >= 0 && ordering.ascending(t3, mutableIndexable.get(n6))) {
                        mutableIndexable.set(n6 + 1, mutableIndexable.get(n6));
                    }
                    mutableIndexable.set(n6 + 1, t3);
                    n6 = ++n2;
                }
                Object t5 = mutableIndexable.get(n3);
                while (--n3 >= 0 && ordering.ascending(t5, mutableIndexable.get(n3))) {
                    mutableIndexable.set(n3 + 1, mutableIndexable.get(n3));
                }
                mutableIndexable.set(n3 + 1, t5);
            }
            return;
        }
        int n7 = (n >> 3) + (n >> 6) + 1;
        int n8 = n2 + n3 >>> 1;
        int n9 = n8 - n7;
        int n10 = n9 - n7;
        int n11 = n8 + n7;
        int n12 = n11 + n7;
        if (ordering.ascending(mutableIndexable.get(n9), mutableIndexable.get(n10))) {
            mutableIndexable.swap(n10, n9);
        }
        if (ordering.ascending(mutableIndexable.get(n8), mutableIndexable.get(n9))) {
            t = mutableIndexable.get(n8);
            mutableIndexable.set(n8, mutableIndexable.get(n9));
            mutableIndexable.set(n9, t);
            if (ordering.ascending(t, mutableIndexable.get(n10))) {
                mutableIndexable.set(n9, mutableIndexable.get(n10));
                mutableIndexable.set(n10, t);
            }
        }
        if (ordering.ascending(mutableIndexable.get(n11), mutableIndexable.get(n8))) {
            t = mutableIndexable.get(n11);
            mutableIndexable.set(n11, mutableIndexable.get(n8));
            mutableIndexable.set(n8, t);
            if (ordering.ascending(t, mutableIndexable.get(n9))) {
                mutableIndexable.set(n8, mutableIndexable.get(n9));
                mutableIndexable.set(n9, t);
                if (ordering.ascending(t, mutableIndexable.get(n10))) {
                    mutableIndexable.set(n9, mutableIndexable.get(n10));
                    mutableIndexable.set(n10, t);
                }
            }
        }
        if (ordering.ascending(mutableIndexable.get(n12), mutableIndexable.get(n11))) {
            t = mutableIndexable.get(n12);
            mutableIndexable.set(n12, mutableIndexable.get(n11));
            mutableIndexable.set(n11, t);
            if (ordering.ascending(t, mutableIndexable.get(n8))) {
                mutableIndexable.set(n11, mutableIndexable.get(n8));
                mutableIndexable.set(n8, t);
                if (ordering.ascending(t, mutableIndexable.get(n9))) {
                    mutableIndexable.set(n8, mutableIndexable.get(n9));
                    mutableIndexable.set(n9, t);
                    if (ordering.ascending(t, mutableIndexable.get(n10))) {
                        mutableIndexable.set(n9, mutableIndexable.get(n10));
                        mutableIndexable.set(n10, t);
                    }
                }
            }
        }
        int n13 = n2;
        int n14 = n3;
        if (ordering.different(mutableIndexable.get(n10), mutableIndexable.get(n9)) && ordering.different(mutableIndexable.get(n9), mutableIndexable.get(n8)) && ordering.different(mutableIndexable.get(n8), mutableIndexable.get(n11)) && ordering.different(mutableIndexable.get(n11), mutableIndexable.get(n12))) {
            Object t6;
            Object t7 = mutableIndexable.get(n9);
            Object t8 = mutableIndexable.get(n11);
            mutableIndexable.set(n9, mutableIndexable.get(n2));
            mutableIndexable.set(n11, mutableIndexable.get(n3));
            while (ordering.ascending(mutableIndexable.get(++n13), t7)) {
            }
            while (ordering.descending(mutableIndexable.get(--n14), t8)) {
            }
            int n15 = n13 - 1;
            block9: while (++n15 <= n14) {
                t6 = mutableIndexable.get(n15);
                if (ordering.ascending(t6, t7)) {
                    mutableIndexable.set(n15, mutableIndexable.get(n13));
                    mutableIndexable.set(n13, t6);
                    ++n13;
                    continue;
                }
                if (!ordering.descending(t6, t8)) continue;
                while (ordering.descending(mutableIndexable.get(n14), t8)) {
                    if (n14-- != n15) continue;
                    break block9;
                }
                if (ordering.ascending(mutableIndexable.get(n14), t7)) {
                    mutableIndexable.set(n15, mutableIndexable.get(n13));
                    mutableIndexable.set(n13, mutableIndexable.get(n14));
                    ++n13;
                } else {
                    mutableIndexable.set(n15, mutableIndexable.get(n14));
                }
                mutableIndexable.set(n14, t6);
                --n14;
            }
            mutableIndexable.set(n2, mutableIndexable.get(n13 - 1));
            mutableIndexable.set(n13 - 1, t7);
            mutableIndexable.set(n3, mutableIndexable.get(n14 + 1));
            mutableIndexable.set(n14 + 1, t8);
            DualPivotQuicksort.sort(mutableIndexable.subSet(n2, n13 - 1), ordering, bl);
            DualPivotQuicksort.sort(mutableIndexable.subSet(n14 + 2, n3 + 1), ordering, false);
            if (n13 < n10 && n12 < n14) {
                while (ordering.same(mutableIndexable.get(n13), t7)) {
                    ++n13;
                }
                while (ordering.same(mutableIndexable.get(n14), t8)) {
                    --n14;
                }
                n15 = n13 - 1;
                block13: while (++n15 <= n14) {
                    t6 = mutableIndexable.get(n15);
                    if (ordering.same(t6, t7)) {
                        mutableIndexable.set(n15, mutableIndexable.get(n13));
                        mutableIndexable.set(n13, t6);
                        ++n13;
                        continue;
                    }
                    if (!ordering.same(t6, t8)) continue;
                    while (ordering.same(mutableIndexable.get(n14), t8)) {
                        if (n14-- != n15) continue;
                        break block13;
                    }
                    if (ordering.same(mutableIndexable.get(n14), t7)) {
                        mutableIndexable.set(n15, mutableIndexable.get(n13));
                        mutableIndexable.set(n13, t7);
                        ++n13;
                    } else {
                        mutableIndexable.set(n15, mutableIndexable.get(n14));
                    }
                    mutableIndexable.set(n14, t6);
                    --n14;
                }
            }
            DualPivotQuicksort.sort(mutableIndexable.subSet(n13, n14 + 1), ordering, false);
        } else {
            Object t9 = mutableIndexable.get(n8);
            for (int i = n13; i <= n14; ++i) {
                if (ordering.same(mutableIndexable.get(i), t9)) continue;
                Object t10 = mutableIndexable.get(i);
                if (ordering.ascending(t10, t9)) {
                    mutableIndexable.set(i, mutableIndexable.get(n13));
                    mutableIndexable.set(n13, t10);
                    ++n13;
                    continue;
                }
                while (ordering.descending(mutableIndexable.get(n14), t9)) {
                    --n14;
                }
                if (ordering.ascending(mutableIndexable.get(n14), t9)) {
                    mutableIndexable.set(i, mutableIndexable.get(n13));
                    mutableIndexable.set(n13, mutableIndexable.get(n14));
                    ++n13;
                } else {
                    mutableIndexable.set(i, t9);
                }
                mutableIndexable.set(n14, t10);
                --n14;
            }
            DualPivotQuicksort.sort(mutableIndexable.subSet(n2, n13), ordering, bl);
            DualPivotQuicksort.sort(mutableIndexable.subSet(n14 + 1, n3 + 1), ordering, false);
        }
    }

    public static void sort(@NotNull MutableIntIndexable mutableIntIndexable) {
        DualPivotQuicksort.sort(mutableIntIndexable, IntOrdering.ASCENDING);
    }

    public static void sort(@NotNull MutableIntIndexable mutableIntIndexable, @NotNull IntOrdering intOrdering) {
        MutableIntIndexable mutableIntIndexable2;
        int n;
        int n2 = mutableIntIndexable.size() - 1;
        if (n2 - 0 < 286) {
            DualPivotQuicksort.sort(mutableIntIndexable, intOrdering, true);
            return;
        }
        int[] nArray = new int[68];
        int n3 = 0;
        nArray[0] = 0;
        int n4 = 0;
        while (n4 < n2) {
            switch (intOrdering.checkInt(mutableIntIndexable.get(n4), mutableIntIndexable.get(n4 + 1))) {
                case Ascending: {
                    while (++n4 <= n2 && intOrdering.ascendingOrSame(mutableIntIndexable.get(n4 - 1), mutableIntIndexable.get(n4))) {
                    }
                    break;
                }
                case Descending: {
                    while (++n4 <= n2 && intOrdering.descendingOrSame(mutableIntIndexable.get(n4 - 1), mutableIntIndexable.get(n4))) {
                    }
                    mutableIntIndexable.revert(nArray[n3] - 1, n4);
                    break;
                }
                default: {
                    n = 33;
                    while (++n4 <= n2 && intOrdering.same(mutableIntIndexable.get(n4 - 1), mutableIntIndexable.get(n4))) {
                        if (--n != 0) continue;
                        DualPivotQuicksort.sort(mutableIntIndexable, intOrdering, true);
                        return;
                    }
                    break block0;
                }
            }
            if (++n3 == 67) {
                DualPivotQuicksort.sort(mutableIntIndexable, intOrdering, true);
                return;
            }
            nArray[n3] = n4;
        }
        if (nArray[n3] == n2++) {
            nArray[++n3] = n2;
        } else if (n3 == 1) {
            return;
        }
        n = 0;
        int n5 = 1;
        while ((n5 <<= 1) < n3) {
            n = (byte)(n ^ 1);
        }
        if (n == 0) {
            mutableIntIndexable2 = mutableIntIndexable;
            mutableIntIndexable = mutableIntIndexable2.getCopy();
        } else {
            mutableIntIndexable2 = MutableIntIndexable.zeroed(mutableIntIndexable.size());
        }
        while (n3 > 1) {
            int n6;
            int n7;
            n5 = 0;
            for (n7 = 0 + 2; n7 <= n3; n7 += 2) {
                int n8;
                n6 = nArray[n7];
                int n9 = nArray[n7 - 1];
                int n10 = n8 = nArray[n7 - 2];
                int n11 = n9;
                while (n8 < n6) {
                    if (n11 >= n6 || n10 < n9 && intOrdering.ascending(mutableIntIndexable.get(n10), mutableIntIndexable.get(n11))) {
                        mutableIntIndexable2.set(n8, mutableIntIndexable.get(n10++));
                    } else {
                        mutableIntIndexable2.set(n8, mutableIntIndexable.get(n11++));
                    }
                    ++n8;
                }
                nArray[++n5] = n6;
            }
            if ((n3 & 1) != 0) {
                n7 = n2;
                n6 = nArray[n3 - 1];
                while (--n7 >= n6) {
                    mutableIntIndexable2.set(n7, mutableIntIndexable.get(n7));
                }
                nArray[++n5] = n2;
            }
            MutableIntIndexable mutableIntIndexable3 = mutableIntIndexable;
            mutableIntIndexable = mutableIntIndexable2;
            mutableIntIndexable2 = mutableIntIndexable3;
            n3 = n5;
        }
    }

    private static <T> void sort(@NotNull MutableIntIndexable mutableIntIndexable, @NotNull IntOrdering intOrdering, boolean bl) {
        int n;
        int n2 = mutableIntIndexable.size();
        int n3 = 0;
        int n4 = n2 - 1;
        if (n2 < 47) {
            if (bl) {
                int n5;
                int n6 = n5 = n3;
                while (n5 < n4) {
                    int n7 = mutableIntIndexable.get(n5 + 1);
                    while (intOrdering.ascending(n7, mutableIntIndexable.get(n6))) {
                        mutableIntIndexable.set(n6 + 1, mutableIntIndexable.get(n6));
                        if (n6-- != n3) continue;
                    }
                    mutableIntIndexable.set(n6 + 1, n7);
                    n6 = ++n5;
                }
            } else {
                do {
                    if (n3 < n4) continue;
                    return;
                } while (intOrdering.descendingOrSame(mutableIntIndexable.get(++n3), mutableIntIndexable.get(n3 - 1)));
                int n8 = n3;
                while (++n3 <= n4) {
                    int n9;
                    int n10 = mutableIntIndexable.get(n8);
                    if (intOrdering.ascending(n10, n9 = mutableIntIndexable.get(n3))) {
                        n9 = n10;
                        n10 = mutableIntIndexable.get(n3);
                    }
                    while (--n8 >= 0 && intOrdering.ascending(n10, mutableIntIndexable.get(n8))) {
                        mutableIntIndexable.set(n8 + 2, mutableIntIndexable.get(n8));
                    }
                    mutableIntIndexable.set(++n8 + 1, n10);
                    while (--n8 >= 0 && intOrdering.ascending(n9, mutableIntIndexable.get(n8))) {
                        mutableIntIndexable.set(n8 + 1, mutableIntIndexable.get(n8));
                    }
                    mutableIntIndexable.set(n8 + 1, n9);
                    n8 = ++n3;
                }
                n8 = mutableIntIndexable.get(n4);
                while (--n4 >= 0 && intOrdering.ascending(n8, mutableIntIndexable.get(n4))) {
                    mutableIntIndexable.set(n4 + 1, mutableIntIndexable.get(n4));
                }
                mutableIntIndexable.set(n4 + 1, n8);
            }
            return;
        }
        int n11 = (n2 >> 3) + (n2 >> 6) + 1;
        int n12 = n3 + n4 >>> 1;
        int n13 = n12 - n11;
        int n14 = n13 - n11;
        int n15 = n12 + n11;
        int n16 = n15 + n11;
        if (intOrdering.ascending(mutableIntIndexable.get(n13), mutableIntIndexable.get(n14))) {
            mutableIntIndexable.swap(n14, n13);
        }
        if (intOrdering.ascending(mutableIntIndexable.get(n12), mutableIntIndexable.get(n13))) {
            n = mutableIntIndexable.get(n12);
            mutableIntIndexable.set(n12, mutableIntIndexable.get(n13));
            mutableIntIndexable.set(n13, n);
            if (intOrdering.ascending(n, mutableIntIndexable.get(n14))) {
                mutableIntIndexable.set(n13, mutableIntIndexable.get(n14));
                mutableIntIndexable.set(n14, n);
            }
        }
        if (intOrdering.ascending(mutableIntIndexable.get(n15), mutableIntIndexable.get(n12))) {
            n = mutableIntIndexable.get(n15);
            mutableIntIndexable.set(n15, mutableIntIndexable.get(n12));
            mutableIntIndexable.set(n12, n);
            if (intOrdering.ascending(n, mutableIntIndexable.get(n13))) {
                mutableIntIndexable.set(n12, mutableIntIndexable.get(n13));
                mutableIntIndexable.set(n13, n);
                if (intOrdering.ascending(n, mutableIntIndexable.get(n14))) {
                    mutableIntIndexable.set(n13, mutableIntIndexable.get(n14));
                    mutableIntIndexable.set(n14, n);
                }
            }
        }
        if (intOrdering.ascending(mutableIntIndexable.get(n16), mutableIntIndexable.get(n15))) {
            n = mutableIntIndexable.get(n16);
            mutableIntIndexable.set(n16, mutableIntIndexable.get(n15));
            mutableIntIndexable.set(n15, n);
            if (intOrdering.ascending(n, mutableIntIndexable.get(n12))) {
                mutableIntIndexable.set(n15, mutableIntIndexable.get(n12));
                mutableIntIndexable.set(n12, n);
                if (intOrdering.ascending(n, mutableIntIndexable.get(n13))) {
                    mutableIntIndexable.set(n12, mutableIntIndexable.get(n13));
                    mutableIntIndexable.set(n13, n);
                    if (intOrdering.ascending(n, mutableIntIndexable.get(n14))) {
                        mutableIntIndexable.set(n13, mutableIntIndexable.get(n14));
                        mutableIntIndexable.set(n14, n);
                    }
                }
            }
        }
        n = n3;
        int n17 = n4;
        if (intOrdering.different(mutableIntIndexable.get(n14), mutableIntIndexable.get(n13)) && intOrdering.different(mutableIntIndexable.get(n13), mutableIntIndexable.get(n12)) && intOrdering.different(mutableIntIndexable.get(n12), mutableIntIndexable.get(n15)) && intOrdering.different(mutableIntIndexable.get(n15), mutableIntIndexable.get(n16))) {
            int n18;
            int n19 = mutableIntIndexable.get(n13);
            int n20 = mutableIntIndexable.get(n15);
            mutableIntIndexable.set(n13, mutableIntIndexable.get(n3));
            mutableIntIndexable.set(n15, mutableIntIndexable.get(n4));
            while (intOrdering.ascending(mutableIntIndexable.get(++n), n19)) {
            }
            while (intOrdering.descending(mutableIntIndexable.get(--n17), n20)) {
            }
            int n21 = n - 1;
            block9: while (++n21 <= n17) {
                n18 = mutableIntIndexable.get(n21);
                if (intOrdering.ascending(n18, n19)) {
                    mutableIntIndexable.set(n21, mutableIntIndexable.get(n));
                    mutableIntIndexable.set(n, n18);
                    ++n;
                    continue;
                }
                if (!intOrdering.descending(n18, n20)) continue;
                while (intOrdering.descending(mutableIntIndexable.get(n17), n20)) {
                    if (n17-- != n21) continue;
                    break block9;
                }
                if (intOrdering.ascending(mutableIntIndexable.get(n17), n19)) {
                    mutableIntIndexable.set(n21, mutableIntIndexable.get(n));
                    mutableIntIndexable.set(n, mutableIntIndexable.get(n17));
                    ++n;
                } else {
                    mutableIntIndexable.set(n21, mutableIntIndexable.get(n17));
                }
                mutableIntIndexable.set(n17, n18);
                --n17;
            }
            mutableIntIndexable.set(n3, mutableIntIndexable.get(n - 1));
            mutableIntIndexable.set(n - 1, n19);
            mutableIntIndexable.set(n4, mutableIntIndexable.get(n17 + 1));
            mutableIntIndexable.set(n17 + 1, n20);
            DualPivotQuicksort.sort(mutableIntIndexable.subSet(n3, n - 1), intOrdering, bl);
            DualPivotQuicksort.sort(mutableIntIndexable.subSet(n17 + 2, n4 + 1), intOrdering, false);
            if (n < n14 && n16 < n17) {
                while (intOrdering.same(mutableIntIndexable.get(n), n19)) {
                    ++n;
                }
                while (intOrdering.same(mutableIntIndexable.get(n17), n20)) {
                    --n17;
                }
                n21 = n - 1;
                block13: while (++n21 <= n17) {
                    n18 = mutableIntIndexable.get(n21);
                    if (intOrdering.same(n18, n19)) {
                        mutableIntIndexable.set(n21, mutableIntIndexable.get(n));
                        mutableIntIndexable.set(n, n18);
                        ++n;
                        continue;
                    }
                    if (!intOrdering.same(n18, n20)) continue;
                    while (intOrdering.same(mutableIntIndexable.get(n17), n20)) {
                        if (n17-- != n21) continue;
                        break block13;
                    }
                    if (intOrdering.same(mutableIntIndexable.get(n17), n19)) {
                        mutableIntIndexable.set(n21, mutableIntIndexable.get(n));
                        mutableIntIndexable.set(n, n19);
                        ++n;
                    } else {
                        mutableIntIndexable.set(n21, mutableIntIndexable.get(n17));
                    }
                    mutableIntIndexable.set(n17, n18);
                    --n17;
                }
            }
            DualPivotQuicksort.sort(mutableIntIndexable.subSet(n, n17 + 1), intOrdering, false);
        } else {
            int n22 = mutableIntIndexable.get(n12);
            for (int i = n; i <= n17; ++i) {
                if (intOrdering.same(mutableIntIndexable.get(i), n22)) continue;
                int n23 = mutableIntIndexable.get(i);
                if (intOrdering.ascending(n23, n22)) {
                    mutableIntIndexable.set(i, mutableIntIndexable.get(n));
                    mutableIntIndexable.set(n, n23);
                    ++n;
                    continue;
                }
                while (intOrdering.descending(mutableIntIndexable.get(n17), n22)) {
                    --n17;
                }
                if (intOrdering.ascending(mutableIntIndexable.get(n17), n22)) {
                    mutableIntIndexable.set(i, mutableIntIndexable.get(n));
                    mutableIntIndexable.set(n, mutableIntIndexable.get(n17));
                    ++n;
                } else {
                    mutableIntIndexable.set(i, n22);
                }
                mutableIntIndexable.set(n17, n23);
                --n17;
            }
            DualPivotQuicksort.sort(mutableIntIndexable.subSet(n3, n), intOrdering, bl);
            DualPivotQuicksort.sort(mutableIntIndexable.subSet(n17 + 1, n4 + 1), intOrdering, false);
        }
    }
}

