/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;

public class WeakPropertyChangeListener
implements PropertyChangeListener {
    private WeakReference<PropertyChangeListener> wrapped;

    public WeakPropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        this.wrapped = new WeakReference<PropertyChangeListener>(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener propertyChangeListener = this.getListener();
        if (propertyChangeListener != null) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public boolean isValid() {
        return this.getListener() != null;
    }

    @Nullable
    private PropertyChangeListener getListener() {
        PropertyChangeListener propertyChangeListener;
        PropertyChangeListener propertyChangeListener2 = propertyChangeListener = this.wrapped != null ? (PropertyChangeListener)this.wrapped.get() : null;
        if (propertyChangeListener == null) {
            this.wrapped = null;
        }
        return propertyChangeListener;
    }

    public static void removeWeakPropertyListener(@NotNull PropertyChangeSupport propertyChangeSupport, @NotNull PropertyChangeListener propertyChangeListener) {
        for (PropertyChangeListener propertyChangeListener2 : propertyChangeSupport.getPropertyChangeListeners()) {
            if (!(propertyChangeListener2 instanceof WeakPropertyChangeListener)) continue;
            WeakPropertyChangeListener weakPropertyChangeListener = (WeakPropertyChangeListener)propertyChangeListener2;
            Object t = weakPropertyChangeListener.wrapped.get();
            if (t != propertyChangeListener && t != null) continue;
            propertyChangeSupport.removePropertyChangeListener(propertyChangeListener2);
        }
    }

    public static void removeWeakPropertyListener(@NotNull PropertyChangeSupport propertyChangeSupport, @NotNull String string, @NotNull PropertyChangeListener propertyChangeListener) {
        for (PropertyChangeListener propertyChangeListener2 : propertyChangeSupport.getPropertyChangeListeners(string)) {
            if (!(propertyChangeListener2 instanceof WeakPropertyChangeListener)) continue;
            WeakPropertyChangeListener weakPropertyChangeListener = (WeakPropertyChangeListener)propertyChangeListener2;
            if (weakPropertyChangeListener.wrapped != propertyChangeListener && weakPropertyChangeListener.wrapped != null) continue;
            propertyChangeSupport.removePropertyChangeListener(propertyChangeListener2);
        }
    }
}

