/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.AbstractBasicUnmodifiableList;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class UnmodifiableListShortArrayWrapper
extends AbstractBasicUnmodifiableList<Short> {
    private final short[] array;
    private final int start;
    private final int length;

    public UnmodifiableListShortArrayWrapper(@NotNull short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new IllegalArgumentException("'null' array not allowed!");
        }
        if (n < 0 || n > sArray.length) {
            throw new IllegalArgumentException("'start' does not point into array!");
        }
        if (n2 < 0 || n + n2 > sArray.length) {
            throw new IllegalArgumentException("'length' invalid!");
        }
        this.array = sArray;
        this.start = n;
        this.length = n2;
    }

    public UnmodifiableListShortArrayWrapper(@NotNull short[] sArray) {
        this(sArray, 0, sArray.length);
    }

    public UnmodifiableListShortArrayWrapper(@NotNull short[] sArray, int n) {
        this(sArray, 0, n);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = new Object[this.length];
        if (!this.isEmpty()) {
            for (int i = 0; i < this.length; ++i) {
                objectArray[i] = this.array[this.start + i];
            }
        }
        return objectArray;
    }

    @Override
    public Short get(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException("Invalid index " + n);
        }
        return this.array[this.start + n];
    }

    @Override
    public int indexOf(Object object) {
        short s = (Short)object;
        for (int i = 0; i < this.length; ++i) {
            if (this.array[this.start + i] != s) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        short s = (Short)object;
        for (int i = this.length - 1; i >= 0; --i) {
            if (this.array[this.start + i] != s) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public boolean containsAll(@NotNull Collection collection) {
        for (Object e : collection) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Iterator<Short> iterator() {
        return new MyIterator();
    }

    @Override
    @NotNull
    public List<Short> subList(int n, int n2) {
        if (n < 0 || n2 > this.length || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        return n3 == 0 ? Collections.emptyList() : new UnmodifiableListShortArrayWrapper(this.array, this.start + n, n3);
    }

    @Override
    @NotNull
    public ListIterator<Short> listIterator() {
        return new MyListIterator();
    }

    @Override
    @NotNull
    public ListIterator<Short> listIterator(int n) {
        return new MyListIterator(n);
    }

    @Override
    @NotNull
    public <S> S[] toArray(@NotNull S[] objectArray) {
        if (objectArray.length < this.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.length);
        }
        for (int i = 0; i < this.length; ++i) {
            objectArray[i] = this.array[this.start + i];
        }
        if (objectArray.length > this.length) {
            objectArray[this.length] = null;
        }
        return objectArray;
    }

    private class MyListIterator
    extends MyIterator
    implements ListIterator<Short> {
        private MyListIterator() {
        }

        private MyListIterator(int n) {
            this.index += n;
        }

        @Override
        public int nextIndex() {
            return this.index - UnmodifiableListShortArrayWrapper.this.start;
        }

        @Override
        public int previousIndex() {
            return this.index - UnmodifiableListShortArrayWrapper.this.start - 1;
        }

        @Override
        public boolean hasPrevious() {
            return this.index - UnmodifiableListShortArrayWrapper.this.start >= 1;
        }

        @Override
        public Short previous() {
            if (this.index - UnmodifiableListShortArrayWrapper.this.start < 1) {
                throw new NoSuchElementException();
            }
            return UnmodifiableListShortArrayWrapper.this.array[--this.index];
        }

        @Override
        public void add(Short s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Short s) {
            throw new UnsupportedOperationException();
        }
    }

    private class MyIterator
    implements Iterator<Short> {
        protected int index;

        private MyIterator() {
            this.index = UnmodifiableListShortArrayWrapper.this.start;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index - UnmodifiableListShortArrayWrapper.this.start < UnmodifiableListShortArrayWrapper.this.length;
        }

        @Override
        public Short next() {
            if (this.index - UnmodifiableListShortArrayWrapper.this.start == UnmodifiableListShortArrayWrapper.this.length) {
                throw new NoSuchElementException();
            }
            return UnmodifiableListShortArrayWrapper.this.array[this.index++];
        }
    }
}

