/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.AbstractBasicUnmodifiableList;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class UnmodifiableListIntArrayWrapper
extends AbstractBasicUnmodifiableList<Integer> {
    private final int[] array;
    private final int start;
    private final int length;

    public UnmodifiableListIntArrayWrapper(@NotNull int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new IllegalArgumentException("'null' array not allowed!");
        }
        if (n < 0 || n > nArray.length) {
            throw new IllegalArgumentException("'start' does not point into array!");
        }
        if (n2 < 0 || n + n2 > nArray.length) {
            throw new IllegalArgumentException("'length' invalid!");
        }
        this.array = nArray;
        this.start = n;
        this.length = n2;
    }

    public UnmodifiableListIntArrayWrapper(@NotNull int[] nArray) {
        this(nArray, 0, nArray.length);
    }

    public UnmodifiableListIntArrayWrapper(@NotNull int[] nArray, int n) {
        this(nArray, 0, n);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = new Object[this.length];
        if (!this.isEmpty()) {
            for (int i = 0; i < this.length; ++i) {
                objectArray[i] = this.array[this.start + i];
            }
        }
        return objectArray;
    }

    @Override
    public Integer get(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException("Invalid index " + n);
        }
        return this.array[this.start + n];
    }

    @Override
    public int indexOf(Object object) {
        int n = (Integer)object;
        for (int i = 0; i < this.length; ++i) {
            if (this.array[this.start + i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = (Integer)object;
        for (int i = this.length - 1; i >= 0; --i) {
            if (this.array[this.start + i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public boolean containsAll(@NotNull Collection collection) {
        for (Object e : collection) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return new MyIterator();
    }

    @Override
    @NotNull
    public List<Integer> subList(int n, int n2) {
        if (n < 0 || n2 > this.length || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        return n3 == 0 ? Collections.emptyList() : new UnmodifiableListIntArrayWrapper(this.array, this.start + n, n3);
    }

    @Override
    @NotNull
    public ListIterator<Integer> listIterator() {
        return new MyListIterator();
    }

    @Override
    @NotNull
    public ListIterator<Integer> listIterator(int n) {
        return new MyListIterator(n);
    }

    @Override
    @NotNull
    public <S> S[] toArray(@NotNull S[] objectArray) {
        if (objectArray.length < this.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.length);
        }
        for (int i = 0; i < this.length; ++i) {
            objectArray[i] = this.array[this.start + i];
        }
        if (objectArray.length > this.length) {
            objectArray[this.length] = null;
        }
        return objectArray;
    }

    private class MyListIterator
    extends MyIterator
    implements ListIterator<Integer> {
        private MyListIterator() {
        }

        private MyListIterator(int n) {
            this.index += n;
        }

        @Override
        public int nextIndex() {
            return this.index - UnmodifiableListIntArrayWrapper.this.start;
        }

        @Override
        public int previousIndex() {
            return this.index - UnmodifiableListIntArrayWrapper.this.start - 1;
        }

        @Override
        public boolean hasPrevious() {
            return this.index - UnmodifiableListIntArrayWrapper.this.start >= 1;
        }

        @Override
        public Integer previous() {
            if (this.index - UnmodifiableListIntArrayWrapper.this.start < 1) {
                throw new NoSuchElementException();
            }
            return UnmodifiableListIntArrayWrapper.this.array[--this.index];
        }

        @Override
        public void add(Integer n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Integer n) {
            throw new UnsupportedOperationException();
        }
    }

    private class MyIterator
    implements Iterator<Integer> {
        protected int index;

        private MyIterator() {
            this.index = UnmodifiableListIntArrayWrapper.this.start;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index - UnmodifiableListIntArrayWrapper.this.start < UnmodifiableListIntArrayWrapper.this.length;
        }

        @Override
        public Integer next() {
            if (this.index - UnmodifiableListIntArrayWrapper.this.start == UnmodifiableListIntArrayWrapper.this.length) {
                throw new NoSuchElementException();
            }
            return UnmodifiableListIntArrayWrapper.this.array[this.index++];
        }
    }
}

