/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.AbstractBasicUnmodifiableList;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class UnmodifiableListByteArrayWrapper
extends AbstractBasicUnmodifiableList<Byte> {
    private final byte[] array;
    private final int start;
    private final int length;

    public UnmodifiableListByteArrayWrapper(@NotNull byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("'null' array not allowed!");
        }
        if (n < 0 || n > byArray.length) {
            throw new IllegalArgumentException("'start' does not point into array!");
        }
        if (n2 < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("'length' invalid!");
        }
        this.array = byArray;
        this.start = n;
        this.length = n2;
    }

    public UnmodifiableListByteArrayWrapper(@NotNull byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public UnmodifiableListByteArrayWrapper(@NotNull byte[] byArray, int n) {
        this(byArray, 0, n);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = new Object[this.length];
        if (!this.isEmpty()) {
            for (int i = 0; i < this.length; ++i) {
                objectArray[i] = this.array[this.start + i];
            }
        }
        return objectArray;
    }

    @Override
    public Byte get(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException("Invalid index " + n);
        }
        return this.array[this.start + n];
    }

    @Override
    public int indexOf(Object object) {
        byte by = (Byte)object;
        for (int i = 0; i < this.length; ++i) {
            if (this.array[this.start + i] != by) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        byte by = (Byte)object;
        for (int i = this.length - 1; i >= 0; --i) {
            if (this.array[this.start + i] != by) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public boolean containsAll(@NotNull Collection collection) {
        for (Object e : collection) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Iterator<Byte> iterator() {
        return new MyIterator();
    }

    @Override
    @NotNull
    public List<Byte> subList(int n, int n2) {
        if (n < 0 || n2 > this.length || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        return n3 == 0 ? Collections.emptyList() : new UnmodifiableListByteArrayWrapper(this.array, this.start + n, n3);
    }

    @Override
    @NotNull
    public ListIterator<Byte> listIterator() {
        return new MyListIterator();
    }

    @Override
    @NotNull
    public ListIterator<Byte> listIterator(int n) {
        return new MyListIterator(n);
    }

    @Override
    @NotNull
    public <S> S[] toArray(@NotNull S[] objectArray) {
        if (objectArray.length < this.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.length);
        }
        for (int i = 0; i < this.length; ++i) {
            objectArray[i] = this.array[this.start + i];
        }
        if (objectArray.length > this.length) {
            objectArray[this.length] = null;
        }
        return objectArray;
    }

    private class MyListIterator
    extends MyIterator
    implements ListIterator<Byte> {
        private MyListIterator() {
        }

        private MyListIterator(int n) {
            this.index += n;
        }

        @Override
        public int nextIndex() {
            return this.index - UnmodifiableListByteArrayWrapper.this.start;
        }

        @Override
        public int previousIndex() {
            return this.index - UnmodifiableListByteArrayWrapper.this.start - 1;
        }

        @Override
        public boolean hasPrevious() {
            return this.index - UnmodifiableListByteArrayWrapper.this.start >= 1;
        }

        @Override
        public Byte previous() {
            if (this.index - UnmodifiableListByteArrayWrapper.this.start < 1) {
                throw new NoSuchElementException();
            }
            return UnmodifiableListByteArrayWrapper.this.array[--this.index];
        }

        @Override
        public void add(Byte by) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Byte by) {
            throw new UnsupportedOperationException();
        }
    }

    private class MyIterator
    implements Iterator<Byte> {
        protected int index;

        private MyIterator() {
            this.index = UnmodifiableListByteArrayWrapper.this.start;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index - UnmodifiableListByteArrayWrapper.this.start < UnmodifiableListByteArrayWrapper.this.length;
        }

        @Override
        public Byte next() {
            if (this.index - UnmodifiableListByteArrayWrapper.this.start == UnmodifiableListByteArrayWrapper.this.length) {
                throw new NoSuchElementException();
            }
            return UnmodifiableListByteArrayWrapper.this.array[this.index++];
        }
    }
}

