/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.AbstractBasicUnmodifiableList;
import de.caff.generics.Types;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class UnmodifiableListArrayWrapper<T>
extends AbstractBasicUnmodifiableList<T> {
    private final T[] array;
    private final int start;
    private final int length;

    public UnmodifiableListArrayWrapper(@NotNull T[] TArray, int n, int n2) {
        if (TArray == null) {
            throw new IllegalArgumentException("'null' array not allowed!");
        }
        if (n < 0 || n > TArray.length) {
            throw new IllegalArgumentException("'start' does not point into array!");
        }
        if (n2 < 0 || n + n2 > TArray.length) {
            throw new IllegalArgumentException("'length' invalid!");
        }
        this.array = TArray;
        this.start = n;
        this.length = n2;
    }

    @SafeVarargs
    public UnmodifiableListArrayWrapper(T ... TArray) {
        this(TArray, 0, TArray.length);
    }

    public UnmodifiableListArrayWrapper(@NotNull T[] TArray, int n) {
        this(TArray, 0, n);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = new Object[this.length];
        if (!this.isEmpty()) {
            System.arraycopy(this.array, this.start, objectArray, 0, this.length);
        }
        return objectArray;
    }

    @Override
    public T get(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException("Invalid index " + n);
        }
        return this.array[this.start + n];
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.length; ++i) {
            T t = this.array[this.start + i];
            if (!(object == null ? t == null : object.equals(t))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        for (int i = this.length - 1; i >= 0; --i) {
            T t = this.array[this.start + i];
            if (!(object == null ? t == null : object.equals(t))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public boolean containsAll(@NotNull Collection collection) {
        for (Object e : collection) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    @Override
    @NotNull
    public List<T> subList(int n, int n2) {
        if (n < 0 || n2 > this.length || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        return n3 == 0 ? Collections.emptyList() : new UnmodifiableListArrayWrapper<T>(this.array, this.start + n, n3);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return new MyListIterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int n) {
        return new MyListIterator(n);
    }

    @Override
    @NotNull
    public <S> S[] toArray(@NotNull S[] SArray) {
        if (SArray.length < this.length) {
            return Arrays.copyOf(this.array, this.length, SArray.getClass());
        }
        System.arraycopy(this.array, this.start, SArray, 0, this.length);
        if (SArray.length > this.length) {
            SArray[this.length] = null;
        }
        return SArray;
    }

    public static void main(String[] stringArray) {
        List<String> list = Types.asList(stringArray);
        while (!list.isEmpty()) {
            list = list.subList(1, list.size());
        }
    }

    private class MyListIterator
    extends MyIterator
    implements ListIterator<T> {
        private MyListIterator() {
        }

        private MyListIterator(int n) {
            this.index += n;
        }

        @Override
        public int nextIndex() {
            return this.index - UnmodifiableListArrayWrapper.this.start;
        }

        @Override
        public int previousIndex() {
            return this.index - UnmodifiableListArrayWrapper.this.start - 1;
        }

        @Override
        public boolean hasPrevious() {
            return this.index - UnmodifiableListArrayWrapper.this.start > 0;
        }

        @Override
        public T previous() {
            if (this.index - UnmodifiableListArrayWrapper.this.start < 1) {
                throw new NoSuchElementException();
            }
            return UnmodifiableListArrayWrapper.this.array[--this.index];
        }

        @Override
        public void add(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private class MyIterator
    implements Iterator<T> {
        protected int index;

        private MyIterator() {
            this.index = UnmodifiableListArrayWrapper.this.start;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index - UnmodifiableListArrayWrapper.this.start < UnmodifiableListArrayWrapper.this.length;
        }

        @Override
        public T next() {
            if (this.index - UnmodifiableListArrayWrapper.this.start == UnmodifiableListArrayWrapper.this.length) {
                throw new NoSuchElementException();
            }
            return UnmodifiableListArrayWrapper.this.array[this.index++];
        }
    }
}

