/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.UnionBase;
import de.caff.generics.function.FragileProcedure1;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class Union<T1, T2>
extends UnionBase<T1, T2> {
    private Union() {
    }

    @Override
    @NotNull
    public abstract T1 get1() throws IllegalStateException;

    @Override
    @NotNull
    public abstract T2 get2() throws IllegalStateException;

    @Override
    @NotNull
    public abstract Object getValue();

    @NotNull
    public static <V1, V2> Union<V1, V2> t1(final @NotNull V1 V1) {
        if (V1 == null) {
            throw new IllegalArgumentException("null value is not allowed!");
        }
        return new Union<V1, V2>(){

            @Override
            public boolean has1() {
                return true;
            }

            @Override
            public boolean has2() {
                return false;
            }

            @Override
            @NotNull
            public V1 get1() throws IllegalStateException {
                return V1;
            }

            @Override
            @NotNull
            public V2 get2() throws IllegalStateException {
                throw new IllegalStateException("Requesting type 2 from a union containing type 1!");
            }

            @Override
            @NotNull
            public Object getValue() {
                return V1;
            }

            @Override
            public void dispose(@NotNull Consumer<? super V1> consumer, @NotNull Consumer<? super V2> consumer2) {
                consumer.accept(V1);
            }

            @Override
            @NotNull
            public Union<V1, V2> disposeOnly1(@NotNull Consumer<? super V1> consumer) {
                consumer.accept(V1);
                return this;
            }

            @Override
            @NotNull
            public Union<V1, V2> disposeOnly2(@NotNull Consumer<? super V2> consumer) {
                return this;
            }

            @Override
            @NotNull
            public <E extends Exception> Union<V1, V2> disposeFragile1(@NotNull FragileProcedure1<E, ? super V1> fragileProcedure1) throws E {
                fragileProcedure1.apply(V1);
                return this;
            }

            @Override
            @NotNull
            public <E extends Exception> Union<V1, V2> disposeFragile2(@NotNull FragileProcedure1<E, ? super V2> fragileProcedure1) throws E {
                return this;
            }

            public int hashCode() {
                return Objects.hash(V1);
            }

            public boolean equals(Object object) {
                return UnionBase.isEqual1(this, object);
            }

            @NotNull
            public String toString() {
                return "Union{1:" + V1 + "}";
            }
        };
    }

    @NotNull
    public static <V1, V2> Union<V1, V2> t2(final @NotNull V2 V2) {
        if (V2 == null) {
            throw new IllegalArgumentException("null value is not allowed!");
        }
        return new Union<V1, V2>(){

            @Override
            public boolean has1() {
                return false;
            }

            @Override
            public boolean has2() {
                return true;
            }

            @Override
            @NotNull
            public V1 get1() throws IllegalStateException {
                throw new IllegalStateException("Requesting type 1 from a union containing type 2!");
            }

            @Override
            @NotNull
            public V2 get2() throws IllegalStateException {
                return V2;
            }

            @Override
            @NotNull
            public Object getValue() {
                return V2;
            }

            @Override
            public void dispose(@NotNull Consumer<? super V1> consumer, @NotNull Consumer<? super V2> consumer2) {
                consumer2.accept(V2);
            }

            @Override
            @NotNull
            public Union<V1, V2> disposeOnly1(@NotNull Consumer<? super V1> consumer) {
                return this;
            }

            @Override
            @NotNull
            public Union<V1, V2> disposeOnly2(@NotNull Consumer<? super V2> consumer) {
                consumer.accept(V2);
                return this;
            }

            @Override
            @NotNull
            public <E extends Exception> Union<V1, V2> disposeFragile1(@NotNull FragileProcedure1<E, ? super V1> fragileProcedure1) throws E {
                return this;
            }

            @Override
            @NotNull
            public <E extends Exception> Union<V1, V2> disposeFragile2(@NotNull FragileProcedure1<E, ? super V2> fragileProcedure1) throws E {
                fragileProcedure1.apply(V2);
                return this;
            }

            public int hashCode() {
                return Objects.hash(V2);
            }

            public boolean equals(Object object) {
                return UnionBase.isEqual1(this, object);
            }

            @NotNull
            public String toString() {
                return "Union{2:" + V2 + "}";
            }
        };
    }
}

