/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.Matcher;
import java.util.Objects;

@FunctionalInterface
public interface UniformMatcher<T>
extends Matcher<T, T> {
    public static final UniformMatcher<Object> IDENTICAL = (object, object2) -> object == object2;
    public static final UniformMatcher<Object> NATURAL = (object, object2) -> object.equals(object2);
    public static final UniformMatcher<Object> NATURAL_NULL_SAFE = Objects::deepEquals;

    @NotNull
    public static <V> UniformMatcher<V> identical() {
        return IDENTICAL;
    }

    @NotNull
    public static <V> UniformMatcher<V> natural() {
        return NATURAL;
    }

    @NotNull
    public static <V> UniformMatcher<V> naturalNullSafe() {
        return NATURAL_NULL_SAFE;
    }
}

