/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.FragileTypeConverter;
import de.caff.generics.TypeConverterException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

final class TypesImplMap {
    private TypesImplMap() {
    }

    @NotNull
    static <C extends Collection<? super T>, T, S> C mapImpl(@NotNull C c, @NotNull Iterator<S> iterator, @NotNull Function<? super S, T> function) {
        while (iterator.hasNext()) {
            c.add(function.apply(iterator.next()));
        }
        return c;
    }

    @NotNull
    static <C extends Consumer<? super T>, T, S> C mapImpl(@NotNull C c, @NotNull Iterator<S> iterator, @NotNull Function<? super S, T> function) {
        while (iterator.hasNext()) {
            c.accept(function.apply(iterator.next()));
        }
        return c;
    }

    @NotNull
    static <M extends Map<? super T, ? super S>, T, S> M mapMImpl(@NotNull M m, @NotNull Iterator<S> iterator, @NotNull Function<? super S, T> function) {
        while (iterator.hasNext()) {
            S s = iterator.next();
            m.put(function.apply(s), s);
        }
        return m;
    }

    @NotNull
    static <M extends Map<? super S, ? super T>, T, S> M mapRImpl(@NotNull M m, @NotNull Iterator<S> iterator, @NotNull Function<? super S, T> function) {
        while (iterator.hasNext()) {
            S s = iterator.next();
            m.put(s, function.apply(s));
        }
        return m;
    }

    @NotNull
    static <C extends Collection<? super T>, T, S> C mapImpl(@NotNull C c, @NotNull Enumeration<S> enumeration, @NotNull Function<? super S, T> function) {
        while (enumeration.hasMoreElements()) {
            c.add(function.apply(enumeration.nextElement()));
        }
        return c;
    }

    @NotNull
    static <M extends Map<? super T, ? super S>, T, S> M mapMImpl(@NotNull M m, @NotNull Enumeration<S> enumeration, @NotNull Function<? super S, T> function) {
        while (enumeration.hasMoreElements()) {
            S s = enumeration.nextElement();
            m.put(function.apply(s), s);
        }
        return m;
    }

    @NotNull
    static <M extends Map<? super S, ? super T>, T, S> M mapRImpl(@NotNull M m, @NotNull Enumeration<S> enumeration, @NotNull Function<? super S, T> function) {
        while (enumeration.hasMoreElements()) {
            S s = enumeration.nextElement();
            m.put(s, function.apply(s));
        }
        return m;
    }

    @NotNull
    static <MT extends Map<? super KT, ? super VT>, KT, VT, KS, VS> MT mapImpl(@NotNull MT MT, @NotNull Map<KS, VS> map, @NotNull Function<Map.Entry<KS, VS>, ? extends Map.Entry<KT, VT>> function) {
        for (Map.Entry<KS, VS> entry : map.entrySet()) {
            Map.Entry<KT, VT> entry2 = function.apply(entry);
            if (entry2 == null) continue;
            MT.put(entry2.getKey(), entry2.getValue());
        }
        return MT;
    }

    @NotNull
    static <MT extends Map<? super KT, ? super VT>, KT, VT, KS, VS> MT mapXImpl(@NotNull MT MT, @NotNull Map<KS, VS> map, @NotNull Function<Map.Entry<? super KS, ? super VS>, ? extends Iterable<? extends Map.Entry<? extends KT, ? extends VT>>> function) {
        for (Map.Entry<KS, VS> entry : map.entrySet()) {
            Iterable<Map.Entry<KT, VT>> iterable = function.apply(entry);
            for (Map.Entry<KT, VT> entry2 : iterable) {
                MT.put(entry2.getKey(), entry2.getValue());
            }
        }
        return MT;
    }

    @NotNull
    static <C extends Collection<? super T>, T, S> C mapXImpl(@NotNull C c, @NotNull Iterator<S> iterator, @NotNull Function<? super S, ? extends Iterable<T>> function) {
        while (iterator.hasNext()) {
            for (T t : function.apply(iterator.next())) {
                c.add(t);
            }
        }
        return c;
    }

    @NotNull
    static <C extends Collection<? super T>, T, S> C mapXImpl(@NotNull C c, @NotNull Enumeration<S> enumeration, @NotNull Function<? super S, ? extends Iterable<T>> function) {
        while (enumeration.hasMoreElements()) {
            for (T t : function.apply(enumeration.nextElement())) {
                c.add(t);
            }
        }
        return c;
    }

    @NotNull
    static <C extends Collection<? super T>, T, S> C mapImpl(@NotNull C c, @NotNull Iterator<S> iterator, @NotNull Function<? super S, T> function, @Nullable T t) {
        while (iterator.hasNext()) {
            T t2 = function.apply(iterator.next());
            if (t == t2) continue;
            c.add(t2);
        }
        return c;
    }

    @NotNull
    static <C extends Consumer<? super T>, T, S> C mapImpl(@NotNull C c, @NotNull Iterator<S> iterator, @NotNull Function<? super S, T> function, @Nullable T t) {
        while (iterator.hasNext()) {
            T t2 = function.apply(iterator.next());
            if (t == t2) continue;
            c.accept(t2);
        }
        return c;
    }

    @NotNull
    static <M extends Map<? super T, ? super S>, T, S> M mapMImpl(@NotNull M m, @NotNull Iterator<S> iterator, @NotNull Function<? super S, T> function, @Nullable T t) {
        while (iterator.hasNext()) {
            S s = iterator.next();
            T t2 = function.apply(s);
            if (t == t2) continue;
            m.put(t2, s);
        }
        return m;
    }

    @NotNull
    static <M extends Map<? super S, ? super T>, T, S> M mapRImpl(@NotNull M m, @NotNull Iterator<S> iterator, @NotNull Function<? super S, T> function, @Nullable T t) {
        while (iterator.hasNext()) {
            S s = iterator.next();
            T t2 = function.apply(s);
            if (t == t2) continue;
            m.put(s, t2);
        }
        return m;
    }

    @NotNull
    static <C extends Collection<? super T>, T, S> C mapImpl(@NotNull C c, @NotNull Enumeration<S> enumeration, @NotNull Function<? super S, T> function, @Nullable T t) {
        while (enumeration.hasMoreElements()) {
            T t2 = function.apply(enumeration.nextElement());
            if (t == t2) continue;
            c.add(t2);
        }
        return c;
    }

    @NotNull
    static <M extends Map<? super T, ? super S>, T, S> M mapMImpl(@NotNull M m, @NotNull Enumeration<S> enumeration, @NotNull Function<? super S, T> function, @Nullable T t) {
        while (enumeration.hasMoreElements()) {
            S s = enumeration.nextElement();
            T t2 = function.apply(s);
            if (t == t2) continue;
            m.put(t2, s);
        }
        return m;
    }

    @NotNull
    static <M extends Map<? super S, ? super T>, T, S> M mapRImpl(@NotNull M m, @NotNull Enumeration<S> enumeration, @NotNull Function<? super S, T> function, @Nullable T t) {
        while (enumeration.hasMoreElements()) {
            S s = enumeration.nextElement();
            T t2 = function.apply(s);
            if (t == t2) continue;
            m.put(s, t2);
        }
        return m;
    }

    @NotNull
    static <C extends Collection<? super T>, T, S> C mapEImpl(@NotNull C c, @NotNull Iterator<S> iterator, @NotNull FragileTypeConverter<T, ? super S> fragileTypeConverter) throws TypeConverterException {
        while (iterator.hasNext()) {
            c.add(fragileTypeConverter.convert(iterator.next()));
        }
        return c;
    }

    @NotNull
    static <M extends Map<? super T, ? super S>, T, S> M mapMEImpl(@NotNull M m, @NotNull Iterator<S> iterator, @NotNull FragileTypeConverter<T, ? super S> fragileTypeConverter) throws TypeConverterException {
        while (iterator.hasNext()) {
            S s = iterator.next();
            m.put(fragileTypeConverter.convert(s), s);
        }
        return m;
    }

    @NotNull
    static <M extends Map<? super S, ? super T>, T, S> M mapREImpl(@NotNull M m, @NotNull Iterator<S> iterator, @NotNull FragileTypeConverter<T, ? super S> fragileTypeConverter) throws TypeConverterException {
        while (iterator.hasNext()) {
            S s = iterator.next();
            m.put(s, fragileTypeConverter.convert(s));
        }
        return m;
    }

    @NotNull
    static <C extends Collection<? super T>, T, S> C mapEImpl(@NotNull C c, @NotNull Enumeration<S> enumeration, @NotNull FragileTypeConverter<T, ? super S> fragileTypeConverter) throws TypeConverterException {
        while (enumeration.hasMoreElements()) {
            c.add(fragileTypeConverter.convert(enumeration.nextElement()));
        }
        return c;
    }

    @NotNull
    static <M extends Map<? super T, ? super S>, T, S> M mapMEImpl(@NotNull M m, @NotNull Enumeration<S> enumeration, @NotNull FragileTypeConverter<T, ? super S> fragileTypeConverter) throws TypeConverterException {
        while (enumeration.hasMoreElements()) {
            S s = enumeration.nextElement();
            m.put(fragileTypeConverter.convert(s), s);
        }
        return m;
    }

    @NotNull
    static <M extends Map<? super S, ? super T>, T, S> M mapREImpl(@NotNull M m, @NotNull Enumeration<S> enumeration, @NotNull FragileTypeConverter<T, ? super S> fragileTypeConverter) throws TypeConverterException {
        while (enumeration.hasMoreElements()) {
            S s = enumeration.nextElement();
            m.put(s, fragileTypeConverter.convert(s));
        }
        return m;
    }

    @NotNull
    static <C extends Collection<? super T>, T, S> C mapXEImpl(@NotNull C c, @NotNull Iterator<S> iterator, @NotNull FragileTypeConverter<? extends Iterable<T>, ? super S> fragileTypeConverter) throws TypeConverterException {
        while (iterator.hasNext()) {
            for (T t : fragileTypeConverter.convert(iterator.next())) {
                c.add(t);
            }
        }
        return c;
    }

    @NotNull
    static <C extends Collection<? super T>, T, S> C mapXEImpl(@NotNull C c, @NotNull Enumeration<S> enumeration, @NotNull FragileTypeConverter<? extends Iterable<T>, ? super S> fragileTypeConverter) throws TypeConverterException {
        while (enumeration.hasMoreElements()) {
            for (T t : fragileTypeConverter.convert(enumeration.nextElement())) {
                c.add(t);
            }
        }
        return c;
    }

    @NotNull
    static <C extends Collection<? super T>, T, S> C mapEImpl(@NotNull C c, @NotNull Iterator<S> iterator, @NotNull FragileTypeConverter<T, ? super S> fragileTypeConverter, @Nullable T t) throws TypeConverterException {
        while (iterator.hasNext()) {
            T t2 = fragileTypeConverter.convert(iterator.next());
            if (t == t2) continue;
            c.add(t2);
        }
        return c;
    }

    @NotNull
    static <M extends Map<? super T, ? super S>, T, S> M mapMEImpl(@NotNull M m, @NotNull Iterator<S> iterator, @NotNull FragileTypeConverter<T, ? super S> fragileTypeConverter, @Nullable T t) throws TypeConverterException {
        while (iterator.hasNext()) {
            S s = iterator.next();
            T t2 = fragileTypeConverter.convert(s);
            if (t == t2) continue;
            m.put(t2, s);
        }
        return m;
    }

    @NotNull
    static <M extends Map<? super S, ? super T>, T, S> M mapREImpl(@NotNull M m, @NotNull Iterator<S> iterator, @NotNull FragileTypeConverter<T, ? super S> fragileTypeConverter, @Nullable T t) throws TypeConverterException {
        while (iterator.hasNext()) {
            S s = iterator.next();
            T t2 = fragileTypeConverter.convert(s);
            if (t == t2) continue;
            m.put(s, t2);
        }
        return m;
    }

    @NotNull
    static <C extends Collection<? super T>, T, S> C mapEImpl(@NotNull C c, @NotNull Enumeration<S> enumeration, @NotNull FragileTypeConverter<T, ? super S> fragileTypeConverter, @Nullable T t) throws TypeConverterException {
        while (enumeration.hasMoreElements()) {
            T t2 = fragileTypeConverter.convert(enumeration.nextElement());
            if (t == t2) continue;
            c.add(t2);
        }
        return c;
    }

    @NotNull
    static <M extends Map<? super T, ? super S>, T, S> M mapMEImpl(@NotNull M m, @NotNull Enumeration<S> enumeration, @NotNull FragileTypeConverter<T, ? super S> fragileTypeConverter, @Nullable T t) throws TypeConverterException {
        while (enumeration.hasMoreElements()) {
            S s = enumeration.nextElement();
            T t2 = fragileTypeConverter.convert(s);
            if (t == t2) continue;
            m.put(t2, s);
        }
        return m;
    }

    @NotNull
    static <M extends Map<? super S, ? super T>, T, S> M mapREImpl(@NotNull M m, @NotNull Enumeration<S> enumeration, @NotNull FragileTypeConverter<T, ? super S> fragileTypeConverter, @Nullable T t) throws TypeConverterException {
        while (enumeration.hasMoreElements()) {
            S s = enumeration.nextElement();
            T t2 = fragileTypeConverter.convert(s);
            if (t == t2) continue;
            m.put(s, t2);
        }
        return m;
    }
}

