/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Predicate;

final class TypesImpFilter {
    private TypesImpFilter() {
    }

    @NotNull
    public static <C extends Collection<? super T>, T> C filterImpl(@NotNull C c, @NotNull Iterator<T> iterator, @NotNull Predicate<? super T> predicate) {
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!predicate.test(t)) continue;
            c.add(t);
        }
        return c;
    }

    @NotNull
    public static <C extends Collection<? super T>, T> C filterImpl(@NotNull C c, @NotNull Enumeration<T> enumeration, @NotNull Predicate<? super T> predicate) {
        while (enumeration.hasMoreElements()) {
            T t = enumeration.nextElement();
            if (!predicate.test(t)) continue;
            c.add(t);
        }
        return c;
    }
}

