/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SynchronizedList<T>
implements List<T> {
    private final List<T> baseList;
    private List<T> copyList;

    public SynchronizedList(@NotNull List<T> list) {
        this.baseList = list;
    }

    @NotNull
    private synchronized List<T> getCopy() {
        if (this.copyList == null) {
            this.copyList = Collections.unmodifiableList(new ArrayList<T>(this.baseList));
        }
        return this.copyList;
    }

    private synchronized void clearCopy() {
        this.copyList = null;
    }

    @Override
    public synchronized int size() {
        return this.baseList.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.baseList.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.getCopy().contains(object);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        final Iterator<T> iterator = this.getCopy().iterator();
        return new Iterator<T>(){
            private T current;
            private boolean hasCurrent;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                this.current = iterator.next();
                this.hasCurrent = true;
                return this.current;
            }

            @Override
            public void remove() {
                if (!this.hasCurrent) {
                    throw new IllegalStateException("Cannot delete w/o iterating!");
                }
                SynchronizedList.this.remove(this.current);
            }
        };
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return this.getCopy().listIterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int n) {
        return this.getCopy().listIterator(n);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.getCopy().toArray();
    }

    @Override
    @NotNull
    public <U> U[] toArray(@NotNull U[] UArray) {
        return this.getCopy().toArray(UArray);
    }

    @Override
    public synchronized boolean add(T t) {
        if (this.baseList.add(t)) {
            this.clearCopy();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean remove(Object object) {
        if (this.baseList.remove(object)) {
            this.clearCopy();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        return this.getCopy().containsAll(collection);
    }

    @Override
    public synchronized boolean addAll(@NotNull Collection<? extends T> collection) {
        if (this.baseList.addAll(collection)) {
            this.clearCopy();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeAll(@NotNull Collection<?> collection) {
        if (this.baseList.removeAll(collection)) {
            this.clearCopy();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean retainAll(@NotNull Collection<?> collection) {
        if (this.baseList.retainAll(collection)) {
            this.clearCopy();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        if (!this.baseList.isEmpty()) {
            this.baseList.clear();
            this.clearCopy();
        }
    }

    @Override
    public synchronized boolean addAll(int n, @NotNull Collection<? extends T> collection) {
        this.clearCopy();
        return this.baseList.addAll(n, collection);
    }

    @Override
    public T get(int n) {
        return this.getCopy().get(n);
    }

    @Override
    public synchronized T set(int n, T t) {
        this.clearCopy();
        return this.baseList.set(n, t);
    }

    @Override
    public synchronized void add(int n, T t) {
        this.clearCopy();
        this.baseList.add(n, t);
    }

    @Override
    public synchronized T remove(int n) {
        this.clearCopy();
        return this.baseList.remove(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.getCopy().indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getCopy().lastIndexOf(object);
    }

    @Override
    @NotNull
    public List<T> subList(int n, int n2) {
        throw new UnsupportedOperationException("No sublisting for synchronized list.");
    }

    @Override
    public synchronized void sort(Comparator<? super T> comparator) {
        this.clearCopy();
        this.baseList.sort(comparator);
    }

    @NotNull
    public static <U> SynchronizedList<U> create(@NotNull List<U> list) {
        return new SynchronizedList<U>(list);
    }
}

